#pragma once
#include <iostream>
#include <string>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#ifdef __WIN_OS__
#include <conio.h>
#endif
#ifdef __LIN_OS__
#include <ncurses.h>
#endif
#include <string.h>
#include <cstddef> 
#include "MDFUtil.h"

using namespace std;

class XMLParser
{
private:	
	typedef
		struct attribute {
		string key;
		string value;
		attribute *a;
	}attributetype;

	typedef
		struct node {		
		string name;
		string text;
		attribute *attr;
		node *child;
		node *sibling;
	} nodetype;
	
	nodetype *p = NULL;
	
	std::string root_element_name;
	std::string retrieve_string(char *buffer, int size);
	std::string retrieve_node_content(char *&buffer);
	std::string remove_newlines(std::string string);
	void sub_buffer(char *&buffer, char match_char);
	void clean_string(std::string &string_buffer);
	void retrieve_child(char *&buffer, XMLParser::nodetype *&childnode);
	nodetype *retrieve_element(char *&buffer);
	attributetype *parse_attribute(std::string str_buffer);
	void parse_xmlfile(char *buffer);

public:
	XMLParser();	
	attributetype *tempattr;	
	nodetype *resultnode;
	void SetRootElem(string elementname);
	void LoadXMLFile(string filename);
	std::string ReadNodeKeyAsString(std::string key, std::string elementname);
	~XMLParser();
};

