//..
//..Frequency Module ..
//..developed by GTS..
//..
//..Intel(R) Corporation (C) 2019
//..

//..
//..measurefreq.cpp
//..


#include "..\include\measurefreq.h"


void MeasureFrequency::wait_mils(long mils)
{
	clock_t endwait;
	clock_t curwait;
	endwait = clock() + mils;
	curwait = clock();

	while (curwait < endwait)
	{
		curwait = clock();
	}
}

double MeasureFrequency::measuredFrequency()
{
	int iLoop = 10;
	unsigned __int64 uiStart64 = 0;
	unsigned __int64 uiEnd64 = 0;
	double fDifference = 0;
	double fCycles = 0;
	double fCalcFreq = 0;
	int y = 0;

	for (int x = 0; x < iLoop; x++)
	{
		uiStart64 = __rdtsc();
		wait_mils(100);
		uiEnd64 = __rdtsc();

		fDifference = ((double)uiEnd64 - (double)uiStart64) / 1000;

		std::cout << ".";

		fCycles += (fDifference / 100000);

		y = x;
	}

	fCalcFreq = (fCycles / (y + 1));

	return fCalcFreq;
}

//..call dtor
MeasureFrequency::~MeasureFrequency()
{
}




