#ifndef __GPUSTRESSW_H
#define __GPUSTRESSW_H

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <iostream>
#include <sstream>
#include <list>
#include <csignal>
#include <chrono>
#include <thread>
#include <ctime>
#include <future>
#include <regex>
#include <algorithm>

#include "../Include/OSDef.h"
#include "../Include/XMLParser.h"
#include "../Include/TextData.h"
#include "../Include/MDFUtil.h"
//#include "../Include/GlobalConfig.h"


unsigned long int ulRetEAX = 0;
unsigned long int ulRetEDX = 0;

XMLParser xd;

// Declare config object
//GlobalConfig gGlobalConfig;
TextData td;

#define CLOCKS_PER_MS (CLOCKS_PER_SEC / 1000)

//std::time_t tCurrentTime = std::time(nullptr);
std::time_t tStartTime;
std::time_t tEndTime;
std::time_t tTotalTime;

clock_t start;
clock_t timeElapsed;
unsigned msElapsed;
unsigned msTarget;

bool bOverride = false;
bool bGen9 = false;
bool bGen8 = false;
bool bGen7 = false;
bool bGen6 = false;
bool bGen6Pentium = false;
bool bGen6Celeron = false;
bool bGen5 = false;
bool bGen4 = false;
bool bGen3 = false;
bool bGen2 = false;
bool bNotSupported = false;
static const int iBSmax = 48;
std::string sProcessorBrandString;

enum ReturnValueDef
{
	Success = 0,
	Fail,
	Indeterminate,
	NoCompare,
	InvalidArgs,
	ConfigMismatch
};

enum TextColor
{
	Red = 0,
	Green,
	Yellow
};

enum VarType
{
	vtINT = 0,
	vtSTRING
};

std::thread *tTimer;
std::thread *tEXE;

size_t stFoundBrandID;
size_t stFoundGenID;

std::string sGenID_9 = "-9";
std::string sGenID_8 = "-8";
std::string sGenID_7 = "-7";
std::string sGenID_6 = "-6";
std::string sGenID_6Pentium = "G4";
std::string sGenID_6Celeron = "G3";
std::string sGenID_5 = "-5";
std::string sGenID_4 = "-4";
std::string sGenID_3 = "-3";
std::string sGenID_2 = "-2";
std::string sGPUStressWVersion;
std::string sGPUStressWTimeInMins;
std::string sMatrixSize;
std::string sEXE;
std::string sGEN9;
std::string sGEN8;
std::string sGEN7;
std::string sGEN6;
std::string sGEN6Pentium;
std::string sGEN6Celeron;
std::string sGEN5;
std::string sGEN4;
std::string sGEN3;
std::string sGEN2;
std::string sCLFILE; std::string sKILL = "taskkill /im GEMM.exe /f";
std::string sGPUStressWResultsFile = "GPUStressW_Results.txt";
std::string sGPUStressWLocalConfigFile = "GPUStressW_LocalConfig.xml";
std::string sGPUStressWLocalConfgFileMsg = "..!!..GPUStressW_LocalConfig.xml file does not exist..!!..";
std::string sBuildEXE;

int igPassFailStatus = 0;  // Default with success
int igPrintConfig = 0;
int igPauseApp = 0;
int igDefaultLoadTimeInMins = 0;
int iColorText = 0;
int iDebugFlag = 0;
int iPrintVersionFlag = 1;
int iPrintSuccessFlag = 1;
int iSec;
int iMin;
int iHour;
int iOptionValid;
int iRun;
int iArgIndex;
//int iMSZ;

// Prototypes
void Init(void);
void PrintSuccess(void);
void handleArgs(int argc, char *argv[]);
bool is_integer(const std::string & s);
bool isOptionValid(int iArgLocal, int argcLocal, char *argvLocal[], VarType vt);
void PrintColorMsg(std::string sMsg, TextColor iColor);
void PauseWQuit(void);
void PrintVersion(void);
void SignalFun(int iSigNum);
void CleanUp(void);
void WriteResultsFile(int iPassFailStatus);
void Help(void);
void ReadLocalConfig(void);

#endif  //__GPUSTRESSW_H