//..
//..visParticle - OpenGL GPU exerciser..
//..developed by GTS..
//..
//..Intel(R) Corporation (C) 2016
//..

#ifndef __VISPARTICLE_H
#define __VISPARTICLE_H

#include <algorithm>
#include <cstdlib>
#include <ctime>
#include <iostream>
#include <vector>
#include <regex>
#include <set>
#include <csignal>
#include <math.h>
#include <stdlib.h>


using std::set;
using std::vector;
using std::string;

#include "imageloader.h"
#include "vec3f.h"
#include "freeglut_std.h"
#include "TextData.h"
#include "MDFUtil.h"
#include "../Include/OSDef.h"

TextData td;

std::time_t tStartTime;
std::time_t tEndTime;
std::time_t tTotalTime;

const float PI = 3.1415926535f;

std::string sTitle = "IPDT visParticle - ";

	// .W // windows 
#if defined __WIN_32__
std::string sVersion = "1.0.11.32b.W";
#endif

#if defined __WIN_64__
std::string sVersion = "1.0.11.64b.W";
#endif

std::string visParticleResultsFile = "visParticle_Results.txt";
std::string sPassMessage = "Test Result - PASS";
std::string sFailMessage = "Test Result - FAIL";
std::string sIndeterminateMessage = "Test Result - Indeterminate";
std::string sTime = "";
std::string sWindowSize = "";
std::wstring sParticleSize;

enum VarType
{
	vtINT = 0,
	vtFLOAT
};

enum ReturnValueDef
{
	Success = 0,
	Fail,
	Indeterminate,
	NoCompare,
	InvalidArgs,
	ConfigMismatch
};

int igPassFailStatus = 0;
int iArgIndex;
int iOptionValid;
int iRun = 1;
int iMin;
int iSec;
int iOptionMinutes = 0;
int iOptionSeconds = 0;
int iDefaultTimeSecs = 20;
int iWindowSize = 0;
int iDefaultWindowSize = 400;
int iTimeMS = 0;

const int iNumberOfParticles = 18000;


float iDefaultParticleSize = 1.0;
float iParticleSize = 0;
float size;

size_t iVec;

//Represents a single particle
struct Particle
{
	Vec3f pos;
	Vec3f velocity;
	Vec3f color;
	float timeAlive; //The amount of time that this particle has been alive.
	float lifespan;  //The total amount of time that this particle is to live.
};

const float GRAVITY = 3.0f;
//const int NUM_PARTICLES = 16000;
//The interval of time, in seconds, by which the particle engine periodically
//steps.
const float STEP_TIME = 0.01f;
//The length of the sides of the quadrilateral drawn for each particle.
//const float PARTICLE_SIZE = 0.05f;
//const float PARTICLE_SIZE = 4.0f;
//float PARTICLE_SIZE = 2.75f;

const int TIMER_MS = 25; //The number of milliseconds to which the timer is set

GLuint _textureId;

void SignalFun(int iSigNum);



#endif // __VISPARTICLE_H
