%define name mpt2sasbtm
%define version 08.00.00.00
%define release 1
Summary: LSI MPT Fusion drivers for SAS 2.0
Name: %{name}
Version: %{version}
Release: %{release}
Vendor: LSI Corporation
License: GPL
Group: System Environment/Kernel
Source0: %{name}-%{version}.tar.gz
URL: http://www.lsi.com
Distribution: LSI Coporation
BuildRoot: /var/tmp/%{name}-buildroot
Packager: Sathya Prakash <sathya.prakash@lsi.com>

%description
Drivers for (suse i686, x86_64, ia64 and updates) for the
LSI Corporation MPT Fusion Architecture parts.

# prep #########################################################################
%prep
echo prep %{version}
%setup -c -b 0

# build ########################################################################
%build
echo build %{version}
for kernel in `ls -1 /lib/modules | grep 2.6.9-[6/7/8]`; do
	make build KERNEL=$kernel;
done;

# install ######################################################################
%install
echo install %{version}
echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/file.list.%{name}
for kernel in `ls -1 /lib/modules | grep 2.6.9-[6/7/8]`; do
	MPTLINUX_IPATH=/lib/modules/${kernel}/weak-updates/mpt2sas
	mkdir -p $RPM_BUILD_ROOT/lib/modules/${kernel}/weak-updates/mpt2sas

	# create the file list used in %files to indicate which files are in package
	echo "$MPTLINUX_IPATH/mpt2sasbtm.ko.new" >> $RPM_BUILD_DIR/file.list.%{name}

	make install PREFIX=$RPM_BUILD_ROOT KERNEL=$kernel
	mv -f $RPM_BUILD_ROOT/$MPTLINUX_IPATH/mpt2sasbtm.ko \
		$RPM_BUILD_ROOT/$MPTLINUX_IPATH/mpt2sasbtm.ko.new
done;

# attach sources to rpm
if [ -f /etc/redhat-release ]; then
	mkdir -p $RPM_BUILD_ROOT/usr/src/redhat/SOURCES
	cp $RPM_SOURCE_DIR/%{name}-%{version}.tar.gz $RPM_BUILD_ROOT/usr/src/redhat/SOURCES
	echo "/usr/src/redhat/SOURCES/%{name}-%{version}.tar.gz" >> $RPM_BUILD_DIR/file.list.%{name}
elif [ -f /etc/SuSE-release ]; then
	mkdir -p $RPM_BUILD_ROOT/usr/src/packages/SOURCES
	cp $RPM_SOURCE_DIR/%{name}-%{version}.tar.gz $RPM_BUILD_ROOT/usr/src/packages/SOURCES
	echo "/usr/src/packages/SOURCES/%{name}-%{version}.tar.gz" >> $RPM_BUILD_DIR/file.list.%{name}
fi;

# pre #########################################################################
%pre
echo pre %{version}
system_arch=`uname -m`
if [ -f /etc/SuSE-release ] && [ ${system_arch} == i686 ]; then
	system_arch=i586;
fi;
if [ %{_target_cpu} != ${system_arch} ]; then
	echo "ERROR: Failed installing this rpm!!!!"
	echo "This rpm is intended for %{_target_cpu} platform. It seems your system is ${system_arch}.";
	exit 1;
fi;

# post #########################################################################
%post
echo post %{version}
# add mpt2sasbtm so its in the ramdisk conf files
if [ -f /etc/redhat-release ]; then
	if [ -f /etc/modprobe.conf ] ; then
		sed -e '/mpt2sasbtm/d' /etc/modprobe.conf > modprobe.edit;
		echo "alias scsi_hostadapter mpt2sasbtm" >> modprobe.edit;
		mv -f modprobe.edit /etc/modprobe.conf;
	fi;
elif [ -f /etc/SuSE-release ]; then
	if [ -f /etc/sysconfig/kernel ] ; then
		sed -e 's/mpt2sasbtm//g' /etc/sysconfig/kernel > kernel.edit;
		sed -e 's/INITRD_MODULES="/INITRD_MODULES="mpt2sasbtm /g' kernel.edit > kernel.edit.1;
		mv -f kernel.edit.1 /etc/sysconfig/kernel;
		rm -fr kernel.edit;
	fi;
fi

for kernel in `ls -1 /lib/modules | grep 2.6.9-[6/7/8]`; do

	if [ ! -e /boot/vmlinuz-${kernel} ]; then
		continue;
	fi;

	MPTLINUX_IPATH=/lib/modules/${kernel}/weak-updates/mpt2sas
	if [ ! -e $MPTLINUX_IPATH/mpt2sasbtm.ko.new ]; then
		continue;
	fi;

	echo "The mpt driver for kernel ${kernel} is now version 08.00.00.00";
	cp -f $MPTLINUX_IPATH/mpt2sasbtm.ko.new $MPTLINUX_IPATH/mpt2sasbtm.ko

	# Remake the initrd image
	if [ -f /etc/redhat-release ]; then

		MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas
		if [ -e $MPTLINUX_IPATH/mpt2sasbtm.ko ]; then
			mv $MPTLINUX_IPATH/mpt2sasbtm.ko \
				$MPTLINUX_IPATH/mpt2sasbtm.ko.orig
		fi;

		MPTLINUX_IPATH=/lib/modules/${kernel}/updates
		if [ -e $MPTLINUX_IPATH/mpt2sasbtm.ko ]; then
			mv $MPTLINUX_IPATH/mpt2sasbtm.ko \
				$MPTLINUX_IPATH/mpt2sasbtm.ko.orig
		fi;

		MPTLINUX_IPATH=/lib/modules/${kernel}/extra/mpt2sas
		if [ -e $MPTLINUX_IPATH/mpt2sasbtm.ko ]; then
			mv $MPTLINUX_IPATH/mpt2sasbtm.ko \
				$MPTLINUX_IPATH/mpt2sasbtm.ko.orig
		fi;

		# Red Hat path
		if [ -d /boot/efi/efi/redhat ]; then
			bootpart=/boot/efi/efi/redhat;
		elif [ -d /boot/efi ]; then
			bootpart=/boot/efi;
		else
			bootpart=/boot;
		fi
		depmod -v ${kernel} > /dev/null 2>&1;
		mkinitrd -f ${bootpart}/initrd-${kernel}.img ${kernel}
	elif [ -f /etc/SuSE-release ]; then
		# SuSE path
		depmod -v ${kernel} > /dev/null 2>&1;
		mkinitrd -k vmlinuz-${kernel} -i /boot/initrd-${kernel}
	fi;
done;
echo -e "post Install Done."

# postun #######################################################################
%postun
echo postun %{version}
for kernel in `ls -1 /lib/modules | grep 2.6.9-[6/7/8]`; do

	if [ ! -e /boot/vmlinuz-${kernel} ]; then
		continue;
	fi;

	# restore original initrd images
	if [ -f /etc/redhat-release ]; then

		MPTLINUX_IPATH=/lib/modules/${kernel}/weak-updates/mpt2sas
		if [ ! -e $MPTLINUX_IPATH/mpt2sasbtm.ko.new ] && \
		    [ -e $MPTLINUX_IPATH/mpt2sasbtm.ko ]; then

			rm -f $MPTLINUX_IPATH/mpt2sasbtm.ko;

			MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas
			if [ -e $MPTLINUX_IPATH/mpt2sasbtm.ko.orig ]; then
				mv $MPTLINUX_IPATH/mpt2sasbtm.ko.orig \
					$MPTLINUX_IPATH/mpt2sasbtm.ko
			fi;

			MPTLINUX_IPATH=/lib/modules/${kernel}/updates
			if [ -e $MPTLINUX_IPATH/mpt2sasbtm.ko.orig ]; then
				mv $MPTLINUX_IPATH/mpt2sasbtm.ko.orig \
					$MPTLINUX_IPATH/mpt2sasbtm.ko
			fi;

			MPTLINUX_IPATH=/lib/modules/${kernel}/extra/mpt2sas
			if [ -e $MPTLINUX_IPATH/mpt2sasbtm.ko.orig ]; then
				mv $MPTLINUX_IPATH/mpt2sasbtm.ko.orig \
					$MPTLINUX_IPATH/mpt2sasbtm.ko
			fi;
		fi;

		# Red Hat path
		if [ -d /boot/efi/efi/redhat ]; then
			bootpart=/boot/efi/efi/redhat;
		elif [ -d /boot/efi ]; then
			bootpart=/boot/efi;
		else
			bootpart=/boot;
		fi

		if [ ! -f /lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas/mpt2sasbtm.ko ] && \
		   [ ! -f /lib/modules/${kernel}/updates/mpt2sasbtm.ko ] && \
		   [ ! -f /lib/modules/${kernel}/weak-updates/mpt2sas/mpt2sasbtm.ko ] && \
		   [ ! -f /lib/modules/${kernel}/extra/mpt2sas/mpt2sasbtm.ko ]; then
			sed -e '/mpt2sasbtm/d' /etc/modprobe.conf > modprobe.edit;
			mv -f modprobe.edit /etc/modprobe.conf;
		fi;

		depmod -v ${kernel} > /dev/null 2>&1;
		mkinitrd -f ${bootpart}/initrd-${kernel}.img ${kernel}
	elif [ -f /etc/SuSE-release ]; then
		# SuSE path

		MPTLINUX_IPATH=/lib/modules/${kernel}/weak-updates/mpt2sas
		if [ ! -e $MPTLINUX_IPATH/mpt2sasbtm.ko.new ] && \
		    [ -e $MPTLINUX_IPATH/mpt2sasbtm.ko ]; then
			rm -f $MPTLINUX_IPATH/mpt2sasbtm.ko;
		fi;

		if [ ! -f /lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas/mpt2sasbtm.ko ] && \
		   [ ! -f /lib/modules/${kernel}/weak-updates/mpt2sas/mpt2sasbtm.ko ]; then
			sed -e 's/mpt2sasbtm//g' /etc/sysconfig/kernel > kernel.edit;
			mv -f kernel.edit /etc/sysconfig/kernel;
		fi;

		depmod -v ${kernel} > /dev/null 2>&1;
		mkinitrd -k vmlinuz-${kernel} -i /boot/initrd-${kernel}
	fi;
done;
echo -e "Uninstall Done."

# files ########################################################################
%files -f ../file.list.%{name}

# changelog  ###################################################################
%changelog
* Wed Mar 20 2009 Sathya Prakash <sathya.prakash@lsi.com>
 - Ported for RHEL4 & SLES9 (mpt2sasbtm)
* Mon Jul 21 2008 Eric Moore <Eric.Moore@lsi.com>
 - check for ramdisk image presence prior to creating original backup.
* Fri Jul 11 2008 Eric Moore <Eric.Moore@lsi.com>
 - remove dependancy of mpt2sas.ko being present during initial rpm install.
* Tue May 13 2008 Eric Moore <Eric.Moore@lsi.com>
 - Initial creation.
