%define name mpt2sas
%define version 08.00.00.00
%define release 3
Summary: LSI MPT Fusion drivers for SAS 2.0
Name: %{name}
Version: %{version}
Release: %{release}
Vendor: LSI Corporation
License: GPL
Group: System Environment/Kernel
Source0: %{name}-%{version}.tar.gz
Source1: Module.supported
URL: http://www.lsi.com
Distribution: LSI Coporation
BuildRoot: /var/tmp/%{name}-buildroot
Packager: Eric Moore <Eric.Moore@lsi.com>

%description
Drivers for (i686, x86_64, ia64, ppc64 and updates) for the
LSI Corporation MPT Fusion Architecture parts.

# prep #########################################################################
%prep
echo prep %{version}
%setup -c -b 0
cp %_sourcedir/Module.supported drivers/scsi/mpt2sas/Module.supported


# build ########################################################################
%build
echo build %{version}
for kernel in `ls -1 /lib/modules`; do
	make build KERNEL=$kernel;
done;

# install ######################################################################
%install
echo install %{version}
echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/file.list.%{name}
for kernel in `ls -1 /lib/modules/ | grep "^2.6"`; do
	MPTLINUX_IPATH=/lib/modules/${kernel}/weak-updates/mpt2sas
	mkdir -p $RPM_BUILD_ROOT/lib/modules/${kernel}/weak-updates/mpt2sas

	# create the file list used in %files to indicate which files are in package
	echo "$MPTLINUX_IPATH/mpt2sas.ko.new" >> $RPM_BUILD_DIR/file.list.%{name}

	make install PREFIX=$RPM_BUILD_ROOT KERNEL=$kernel
	mv -f $RPM_BUILD_ROOT/$MPTLINUX_IPATH/mpt2sas.ko \
		$RPM_BUILD_ROOT/$MPTLINUX_IPATH/mpt2sas.ko.new
done;

# attach sources to rpm
if [ -f /etc/redhat-release ]; then
	mkdir -p $RPM_BUILD_ROOT/usr/src/redhat/SOURCES
	cp $RPM_SOURCE_DIR/%{name}-%{version}.tar.gz $RPM_BUILD_ROOT/usr/src/redhat/SOURCES
	echo "/usr/src/redhat/SOURCES/%{name}-%{version}.tar.gz" >> $RPM_BUILD_DIR/file.list.%{name}
elif [ -f /etc/SuSE-release ]; then
	mkdir -p $RPM_BUILD_ROOT/usr/src/packages/SOURCES
	cp $RPM_SOURCE_DIR/%{name}-%{version}.tar.gz $RPM_BUILD_ROOT/usr/src/packages/SOURCES
	echo "/usr/src/packages/SOURCES/%{name}-%{version}.tar.gz" >> $RPM_BUILD_DIR/file.list.%{name}
fi;

# pre #########################################################################
%pre
echo pre %{version}
system_arch=`uname -m`
if [ -f /etc/SuSE-release ] && [ ${system_arch} == i686 ]; then
	system_arch=i586;
fi;
if [ %{_target_cpu} != ${system_arch} ]; then
	echo "ERROR: Failed installing this rpm!!!!"
	echo "This rpm is intended for %{_target_cpu} platform. It seems your system is ${system_arch}.";
	exit 1;
fi;

# post #########################################################################
%post
echo post %{version}

blacklist_file="/etc/modprobe.d/blacklist"
if [ -f /etc/SuSE-release ] && [ `grep -c "VERSION = 11" /etc/SuSE-release` -gt 0 ]; then
	if [ -f ${file} ]; then
		if [ `grep -c "blacklist enclosure" ${blacklist_file}` -eq 0 ]; then
			echo "blacklist enclosure" >> ${blacklist_file};
		fi;
		if [ `grep -c "blacklist ses" ${blacklist_file}` -eq 0 ]; then
			echo "blacklist ses" >> ${blacklist_file};
		fi;
	fi;
fi;

# add mpt2sas so its in the ramdisk conf files
if [ -f /etc/redhat-release ]; then
	if [ -f /etc/modprobe.conf ] ; then
		sed -e '/mpt2sas/d' /etc/modprobe.conf > modprobe.edit;
		echo "alias scsi_hostadapter mpt2sas" >> modprobe.edit;
		mv -f modprobe.edit /etc/modprobe.conf;
	fi;
elif [ -f /etc/SuSE-release ]; then
	if [ -f /etc/sysconfig/kernel ] ; then
		sed -e 's/mpt2sas//g' /etc/sysconfig/kernel > kernel.edit;
		sed -e 's/INITRD_MODULES="/INITRD_MODULES="mpt2sas /g' kernel.edit > kernel.edit.1;
		mv -f kernel.edit.1 /etc/sysconfig/kernel;
		rm -fr kernel.edit;
	fi;
fi

for kernel in `ls -1 /lib/modules`; do

	if [ -f /etc/redhat-release ]; then
		if [ ! -e /boot/vmlinuz-${kernel} ]; then
			continue;
		fi;
	elif [ -f /etc/SuSE-release ]; then
		if [ `uname -m` == ppc64 ]; then
			if [ ! -e /boot/vmlinux-${kernel} ]; then
				continue;
			fi;
		else
			if [ ! -e /boot/vmlinuz-${kernel} ]; then
				continue;
			fi;
		fi;
	fi;

	MPTLINUX_IPATH=/lib/modules/${kernel}/weak-updates/mpt2sas
	if [ ! -e $MPTLINUX_IPATH/mpt2sas.ko.new ]; then
		continue;
	fi;

	echo "The mpt driver for kernel ${kernel} is now version 08.00.00.00";
	cp -f $MPTLINUX_IPATH/mpt2sas.ko.new $MPTLINUX_IPATH/mpt2sas.ko

	# Remake the initrd image
	if [ -f /etc/redhat-release ]; then

		MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas
		if [ -e $MPTLINUX_IPATH/mpt2sas.ko ]; then
			mv $MPTLINUX_IPATH/mpt2sas.ko \
				$MPTLINUX_IPATH/mpt2sas.ko.orig
		fi;

		MPTLINUX_IPATH=/lib/modules/${kernel}/updates
		if [ -e $MPTLINUX_IPATH/mpt2sas.ko ]; then
			mv $MPTLINUX_IPATH/mpt2sas.ko \
				$MPTLINUX_IPATH/mpt2sas.ko.orig
		fi;

		MPTLINUX_IPATH=/lib/modules/${kernel}/extra/mpt2sas
		if [ -e $MPTLINUX_IPATH/mpt2sas.ko ]; then
			mv $MPTLINUX_IPATH/mpt2sas.ko \
				$MPTLINUX_IPATH/mpt2sas.ko.orig
		fi;

		# Red Hat path
		if [ -d /boot/efi/efi/redhat ]; then
			bootpart=/boot/efi/efi/redhat;
		elif [ -d /boot/efi ]; then
			bootpart=/boot/efi;
		else
			bootpart=/boot;
		fi
		depmod -v ${kernel} > /dev/null 2>&1;
		mkinitrd -f ${bootpart}/initrd-${kernel}.img ${kernel}
	elif [ -f /etc/SuSE-release ]; then
		# SuSE path
		depmod -v ${kernel} > /dev/null 2>&1;
		if [ `uname -m` == ppc64 ]; then
			mkinitrd -k vmlinux-${kernel} -i /boot/initrd-${kernel}
		else
			mkinitrd -k vmlinuz-${kernel} -i /boot/initrd-${kernel}
		fi;
	fi;
done;
echo -e "post Install Done."

# postun #######################################################################
%postun
echo postun %{version}
for kernel in `ls -1 /lib/modules`; do

	if [ -f /etc/redhat-release ]; then
		if [ ! -e /boot/vmlinuz-${kernel} ]; then
			continue;
		fi;
	elif [ -f /etc/SuSE-release ]; then
		if [ `uname -m` == ppc64 ]; then
			if [ ! -e /boot/vmlinux-${kernel} ]; then
				continue;
			fi;
		else
			if [ ! -e /boot/vmlinuz-${kernel} ]; then
				continue;
			fi;
		fi;
	fi;

	# restore original initrd images
	if [ -f /etc/redhat-release ]; then

		MPTLINUX_IPATH=/lib/modules/${kernel}/weak-updates/mpt2sas
		if [ ! -e $MPTLINUX_IPATH/mpt2sas.ko.new ] && \
		    [ -e $MPTLINUX_IPATH/mpt2sas.ko ]; then

			rm -rf $MPTLINUX_IPATH;

			MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas
			if [ -e $MPTLINUX_IPATH/mpt2sas.ko.orig ]; then
				mv $MPTLINUX_IPATH/mpt2sas.ko.orig \
					$MPTLINUX_IPATH/mpt2sas.ko
			fi;

			MPTLINUX_IPATH=/lib/modules/${kernel}/updates
			if [ -e $MPTLINUX_IPATH/mpt2sas.ko.orig ]; then
				mv $MPTLINUX_IPATH/mpt2sas.ko.orig \
					$MPTLINUX_IPATH/mpt2sas.ko
			fi;

			MPTLINUX_IPATH=/lib/modules/${kernel}/extra/mpt2sas
			if [ -e $MPTLINUX_IPATH/mpt2sas.ko.orig ]; then
				mv $MPTLINUX_IPATH/mpt2sas.ko.orig \
					$MPTLINUX_IPATH/mpt2sas.ko
			fi;
		fi;

		# Red Hat path
		if [ -d /boot/efi/efi/redhat ]; then
			bootpart=/boot/efi/efi/redhat;
		elif [ -d /boot/efi ]; then
			bootpart=/boot/efi;
		else
			bootpart=/boot;
		fi

		if [ ! -f /lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas/mpt2sas.ko ] && \
		   [ ! -f /lib/modules/${kernel}/udpates/mpt2sas.ko ] && \
		   [ ! -f /lib/modules/${kernel}/weak-updates/mpt2sas/mpt2sas.ko ] && \
		   [ ! -f /lib/modules/${kernel}/extra/mpt2sas/mpt2sas.ko ]; then
			sed -e '/mpt2sas/d' /etc/modprobe.conf > modprobe.edit;
			mv -f modprobe.edit /etc/modprobe.conf;
		fi;

		depmod -v ${kernel} > /dev/null 2>&1;
		mkinitrd -f ${bootpart}/initrd-${kernel}.img ${kernel}
	elif [ -f /etc/SuSE-release ]; then
		# SuSE path

		MPTLINUX_IPATH=/lib/modules/${kernel}/weak-updates/mpt2sas
		if [ ! -e $MPTLINUX_IPATH/mpt2sas.ko.new ] && \
		    [ -e $MPTLINUX_IPATH/mpt2sas.ko ]; then
			rm -rf $MPTLINUX_IPATH;
		fi;

		if [ ! -f /lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas/mpt2sas.ko ] && \
		   [ ! -f /lib/modules/${kernel}/weak-updates/mpt2sas/mpt2sas.ko ]; then
			sed -e 's/mpt2sas//g' /etc/sysconfig/kernel > kernel.edit;
			mv -f kernel.edit /etc/sysconfig/kernel;
		fi;

		depmod -v ${kernel} > /dev/null 2>&1;
		if [ `uname -m` == ppc64 ]; then
			mkinitrd -k vmlinux-${kernel} -i /boot/initrd-${kernel}
		else
			mkinitrd -k vmlinuz-${kernel} -i /boot/initrd-${kernel}
		fi;
	fi;
done;
echo -e "Uninstall Done."

# files ########################################################################
%files -f ../file.list.%{name}

# changelog  ###################################################################
%changelog
* Mon Jul 21 2008 Eric Moore <Eric.Moore@lsi.com>
 - check for ramdisk image presence prior to creating original backup.
* Fri Jul 11 2008 Eric Moore <Eric.Moore@lsi.com>
 - remove dependancy of mpt2sas.ko being present during initial rpm install.
* Tue May 13 2008 Eric Moore <Eric.Moore@lsi.com>
 - Initial creation.
