'Copyright (c) 2011, Intel Corporation
'All rights reserved.
'
'Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
'
'    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
'    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
'    * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
'
'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 

Dim objShell, objFSO, objFile
Dim colSettings
Dim strWKdir, strSettingsFile, strSupportFileXML, strBatchFile, strBatchFileName, strMyDir
Dim strImageFile, arrImagepath, strImagepath

Set colSettings = CreateObject("Scripting.Dictionary")
Set objShell = CreateObject("WScript.shell")
Set objFSO = CreateObject("Scripting.FileSystemObject")

strWKDir = objShell.ExpandEnvironmentStrings("%WKDIR%")

strMyDir = LEFT(Wscript.ScriptFullName,(LEN(Wscript.ScriptFullName)-LEN(Wscript.ScriptName)))

strSettingsFile = strMyDir & "\settings.xml"
strSupportFileXML = strMyDir & "\ISOs.xml"
strBatchFileName = strWKDir & "\OSI_settings.bat"

'If this file exists, we have a valid working directory
if not objFSO.FolderExists(strWKDir) Then
 wscript.echo "Unknown working directory: " & strWKDir
 wscript.quit(2)
end if

'If this file exists read what's there.
if objFSO.FileExists(strSettingsFile) Then
 GetXMLData(strSettingsFile)
else
 wscript.echo "Missing " & strSettingsFile
 wscript.quit(1)
end if
strImagePath = ""
if not colSettings.item("CAP") = "REBOOT" then
 arrKeys = colSettings.keys
 for x = 0 to ubound(arrKeys)
  if colSettings.item(arrKeys(x)) = "" then
   wscript.echo "Settings incomplete. Not creating file."
   wscript.quit(0)
  end if
 next
 arrImagePath = split(colSettings.item("SHARE"),"\")
 strImageFile = arrImagepath(ubound(arrImagePath))
 strShare = "\\" & arrImagePath(2) & "\" & arrImagePath(3)
 arrImagepath(ubound(arrImagePath))=""
 strImagePath = replace(join(arrImagePath,"\"),strShare,"")
end if

strBatchFile = "" & _
 "@echo off" & vbCrLf & _
 vbCrLf & _
 "set CAP=" & colSettings.item("CAP")  & vbCrLf & _
 "set SHARE=" & strShare  & vbCrLf & _
 "set PASSWORD=" & colSettings.item("PASSWORD")  & vbCrLf & _
 "set USER=" & colSettings.item("USER")  & vbCrLf & _
 "set DOMAIN=" & colSettings.item("DOMAIN")  & vbCrLf & _
 "set IMAGEPATH=" & strImagePath  & vbCrLf & _
 "set IMAGEFILE=" & strImageFile  & vbCrLf & _
 "set WARN=" & colSettings.item("WARN")  & vbCrLf & _
 "set PARTSIZE=" & colSettings.item("PARTSIZE")  & vbCrLf & _
 "set FORCEPART=" & colSettings.item("FORCEPART")  & vbCrLf & _
 vbCrLf & _
 ""

' read in the bottom of the file


' Write the file
' Initialize the File System Object
Set objFSO = CreateObject("Scripting.FileSystemObject")
' Does the file exist
if objFSO.FileExists (strBatchFileName) then
 ' Open the file
 set objFile = objFSO.OpenTextFile (strBatchFileName, 2)
else
 ' Create a new file
 set objFile = objFSO.CreateTextFile(strBatchFileName,1)
end if

objFile.Write (strBatchFile)
objFile.Close


set objFile = nothing
set objFSO = nothing
set objShell = nothing

wscript.echo "Success"

Function GetXMLData(strFileName)
 Dim strTMP
 Dim xmlDoc, x
 
 Set xmlDoc=CreateObject("Microsoft.XMLDOM")
 xmlDoc.async="false"
 xmlDoc.load(strFileName)
 For Each x in xmlDoc.documentElement.childNodes
  colSettings.Item(x.nodename) = x.text
 Next

End Function