@echo off

:: Copyright (c) 2011, Intel Corporation
:: All rights reserved.
::  
:: Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
:: 
::     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
::     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
::     * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
:: 
:: THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

if not exist %~dp0..\..\..\inc\settings.bat (
 echo Missing %~dp0..\..\..\inc\settings.bat.
 goto end
)

call %~dp0..\..\..\inc\settings.bat
:: These are passed from settings.bat
:: ARCH= x86 or x64
:: PEARCH= x86 or amd86 (for use with MS folders)
:: LANG= language. E.G. en-us. (for now, always en-us)
:: FILENAME= name of iso being created
:: ISOBLDRTMP= tmp directory where work is being done
:: WAIK= Automated install kit
:: WAIKSUP= SP1 suppliment for automated install kit
:: MEIDRVARCH= path to MEI driver
:: LANDRVARCH= path to LAN driver
:: W7SP1ISO= path to Win7 ISO (if needed)
:: WIFIDRVARCH= path to WiFi driver (if selected)
:: MNT_DIR= path to mounted winPE WIM
:: set FPS_DIR= path to store FPS. Note, they are not extracted, get what you need from %WAIKSUP%
:: set DRV_DIR= path to store extracted drivers. LAN and MEI are auto-extracted here. If you have others, extract them here.
:: set w7_DIR= path to install.wim from Win7 CD.
:: set w7_DIR= path to mounted Win7 install.wim. Get Win7 source files from here.
:: <DOSVAR> = path to any file requested by a package

if not exist %ISOBLDRTMP% (
 echo Temp directory not found.
 goto end
)
:: Make the temp directory structure
set WKDIR=%ISOBLDRTMP%OS_Image\%arch%\windows\system32
mkdir %WKDIR%
if not exist %WKDIR% (
 echo Unable to create working directory.
 goto end
)
:: Extract Imagex for desired architecture
:: Extract Neutral.cab if it's not already there
set FILE=Neutral.cab
if exist %ISOBLDRTMP%%FILE% goto neutral_cab_exists
:: Be sure the WAIK is set
if "%WAIK%"=="" (
 echo WAIK not found.
 goto end
)
:: Extract neutral.cab
%~dp0..\..\..\inc\7z.exe e "%WAIK%" %FILE% -y -o%ISOBLDRTMP%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%.
 goto end
)

:neutral_cab_exists
:: Extract imagex
set LASTFILE=%ISOBLDRTMP%%FILE%
if %ARCH%==x64 set FILE=F3_imagex
if %ARCH%==x86 set FILE=F1_imagex
if %FILE%==%LASTFILE% (
 echo Unknown system Architecture
 goto end
)
%~dp0..\..\..\inc\7z.exe e %LASTFILE% %FILE% -y -o%ISOBLDRTMP%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%.
 goto end
)
del /q /f %LASTFILE%
move %ISOBLDRTMP%%FILE% %WKDIR%\imagex.exe
if not exist %WKDIR%\imagex.exe (
 echo Unable to extract imagex.exe
 goto end
)

:: Create settings batch files for automatically starting image process
cscript /nologo %~dp0os_image.vbs
::if exist %WKDIR%\OSI_settings.bat goto copy_files

:: Extract WINPE_FPS\WINPE-SCRIPTING.CAB
if not exist %FPS_DIR% mkdir %FPS_DIR%
set FILE=%PEARCH%\WINPE_FPS\winpe-hta.cab
%~dp0..\..\..\inc\7z.exe x "%WAIKSUP%" %FILE% -y -o%FPS_DIR%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

:: Extract WINPE_FPS\WINPE-SCRIPTING.CAB Languag File
set FILE=%PEARCH%\WINPE_FPS\%LANG%\winpe-hta_%LANG%.cab
%~dp0..\..\..\inc\7z.exe x "%WAIKSUP%" %FILE% -y -o%FPS_DIR%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

:copy_files
:: Copy OS Imaging automation batch files
copy %~dp0*.ba_ %WKDIR%\*.bat
copy %~dp0*.tx_ %WKDIR%\*.txt
copy %~dp0*.vb_ %WKDIR%\*.vbs
copy %~dp0*.hta %WKDIR%\*.hta


echo Success
:end