'Copyright (c) 2011, Intel Corporation
'All rights reserved.
'
'Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
'
'    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
'    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
'    * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
'
'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


Dim objShell, objFSO, objFile
Dim colSettings
Dim strSettingsFile, strSupportFileXML, strBatchFile, strBatchFileName, strMyDir

Set colSettings = CreateObject("Scripting.Dictionary")
Set objShell = CreateObject("WScript.shell")
Set objFSO = CreateObject("Scripting.FileSystemObject")

strMyDir = LEFT(Wscript.ScriptFullName,(LEN(Wscript.ScriptFullName)-LEN(Wscript.ScriptName)))

strSettingsFile = strMyDir & "\settings.xml"
strSupportFileXML = strMyDir & "\ISOs.xml"
strBatchFileName = strMyDir & "\set_waik.bat"

'If this file exists read what's there.
if objFSO.FileExists(strSettingsFile) Then
 GetXMLData(strSettingsFile)
else
 wscript.echo "Missing " & strSettingsFile
 wscript.quit(1)
end if

' Is it's blank, set the default path
if colSettings.item("e6714ae5-292b-4ab7-8e21-f0b1095af26c") = "" then
 if objFSO.FileExists(strSupportFileXML) Then
  Set xmlDoc=CreateObject("Microsoft.XMLDOM")
  xmlDoc.async="false"
  xmlDoc.load(strSupportFileXML)
  ' Find the GUID for all required files. This is used to reference them in the settings file
  strQuery = "/SETTINGS/SUPPORTFILE [ GUID = '" & "e6714ae5-292b-4ab7-8e21-f0b1095af26c" & "' ] / ( DEFAULTFILENAME )"
  Set objNodes1 = xmlDoc.selectNodes(strQuery)
  For Each objNode1 in objNodes1
   if objFSO.FileExists(strMyDir & "..\..\..\src\" & objNode1.text) Then
    colSettings.item("e6714ae5-292b-4ab7-8e21-f0b1095af26c") = strMyDir & "..\..\..\src\" & objNode1.text
   end if
  Next
 end if
end if

strBatchFile = "" & _
 "@echo off" & vbCrLf & _
 vbCrLf & _
 "set WAIK=" & colSettings.item("e6714ae5-292b-4ab7-8e21-f0b1095af26c")  & vbCrLf & _
 ":end" & vbCrLf & _
 ""

' Write the file
' Initialize the File System Object
Set objFSO = CreateObject("Scripting.FileSystemObject")
' Does the file exist
if objFSO.FileExists (strBatchFileName) then
 ' Open the file
 set objFile = objFSO.OpenTextFile (strBatchFileName, 2)
else
 ' Create a new file
 set objFile = objFSO.CreateTextFile(strBatchFileName,1)
end if

objFile.Write (strBatchFile)
objFile.Close
 
' Clean up
set objFile = nothing
set objFSO = nothing
set objShell = nothing

wscript.echo "Success"

Function GetXMLData(strFileName)
 Dim strTMP
 Dim xmlDoc, x
 
 Set xmlDoc=CreateObject("Microsoft.XMLDOM")
 xmlDoc.async="false"
 xmlDoc.load(strFileName)
 For Each x in xmlDoc.documentElement.childNodes
  colSettings.Item(x.nodename) = x.text
 Next

End Function