'Copyright (c) 2011, Intel Corporation
'All rights reserved.
'
'Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
'
'    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
'    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
'    * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
'
'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Dim objShell, objFSO, objFile
Dim colSettings
Dim strSettingsFile, strMyDir

Set colSettings = CreateObject("Scripting.Dictionary")
Set objShell = CreateObject("WScript.shell")
Set objFSO = CreateObject("Scripting.FileSystemObject")

strMyDir = LEFT(Wscript.ScriptFullName,(LEN(Wscript.ScriptFullName)-LEN(Wscript.ScriptName)))

strISOROOT = strMyDir & "..\iso_root"
strXMLFile = strISOROOT & "\PARAM.XML"

strSettingsFile = strMyDir & "\settings.xml"
strSupportFileXML = strMyDir & "\ISOs.xml"
strBatchFileName = strWKDir & "\OSI_settings.bat"

GetXMLData(strXMLFile)

strResult = BuildISO
wscript.echo strResults

if not strResult = "ISO Created." then
 wscript.quit(1)
end if

wscript.echo "Success"

Function GetXMLData(strFileName)
 Dim strTMP
 Dim xmlDoc, x
 
 Set xmlDoc=CreateObject("Microsoft.XMLDOM")
 xmlDoc.async="false"
 xmlDoc.load(strFileName)
 For Each x in xmlDoc.documentElement.childNodes
  colSettings.Item(x.nodename) = x.text
 Next

End Function

Function BuildISO()
 dim objShell : Set objShell = Nothing
 dim objRUN : Set objRUN = Nothing
 dim objFSO : set objFSO = nothing
 dim objFile : set objFile = nothing
 dim objFolder : set objFolder = nothing
 dim strLine, intResult, strCMD
 Dim strTMP, strTMPDIR, strMenuLST
 Dim xmlDoc, x
 
 ' Initialize the shell to run a command
 Set objShell = CreateObject("WScript.shell") 

 ' Create the temp directory
 strTMPDIR = strMyDir & "..\tmp"
 
 ' Initialize the File System Object
 Set objFSO = CreateObject("Scripting.FileSystemObject")
 ' Clean up an old tmp dir
 if objFSO.FolderExists(strTMPDIR) then
  set objFolder = objFSO.GetFolder(strTMPDIR)
  objFolder.Delete
  set objFolder = nothing
 end if
 ' If we want network boot option, include everything in iso_root
 if colSettings.item("ifast") = "yes" then
  objFSO.CopyFolder strISOROOT, strTMPDIR
 ' If we don't want network boot option, include minimum for HD boot 
 else
  set objFolder = objFSO.CreateFolder(strTMPDIR)
  set objFolder = nothing
  objFSO.CopyFile strISOROOT & "\grldr", strTMPDIR & "\"
  objFSO.CopyFile strXMLFile, strTMPDIR & "\"
 end if
 
 ' If they want a custom menu.lst, copy it in.
 if colSettings.item("trigger") = "custom" then
  objFSO.CopyFile strISOROOT & "\menu.lst", strTMPDIR & "\"
 else
  strMenuLST = "" & _
  "#ability to use the G4D command line in case both fail. Good for debug." & vbCrLf & _
  "title commandline" & vbCrLf & _
  "commandline" & vbCrLf & _
  ""
  'build menu.lst
  if colSettings.item("ifast") = "yes" then
   strMenuLST = "" & _
   "#second boot 2 stage from the CD" & vbCrLf & _
   "title 2 stage" & vbCrLf & _
   "find --set-root /initrd.bin" & vbCrLf & _
   "kernel /vmlinuz ramdisk_size=512000 init=/sbin/init root=/dev/ram0" & vbCrLf & _
   "initrd /initrd.bin" & vbCrLf & _
   vbCrLf & _
   strMenuLST & _
   ""
  end if
  if colSettings.item("trigger") = "yes" then
   strTMP = "" & _
   "# first look on the local hard drives" & vbCrLf & _
   "title Recovery OS" & vbCrLf & _
   ""
   if colSettings.Item("ifast") = "yes" then
    strTMP = strTMP & _
    "fallback 1" & vbCrLf & _
    ""
   end if
   strMenuLST = "" & _
   strTMP & _
   "find --set-root --ignore-floppies /" & colSettings.item("TriggerImageFileName") & "" & vbCrLf & _
   "map /" & colSettings.item("TriggerImageFileName") & " (0xff) || map --mem /" & colSettings.item("TriggerImageFileName") & " (0xff)" & vbCrLf & _
   "map --hook" & vbCrLf & _
   "chainloader (0xff)" & vbCrLf & _
   vbCrLf & _
   strMenuLST & _
   ""
  end if
  ' Add the default settings
  strMenuLST = "" & _
  "timeout 0" & vbCrLf & _
  "default 0" & vbCrLf & _
  vbCrLf & _
  strMenuLST & _
  ""
  ' Write the new menu.lst
  ' Does menu.lst exist
  if objFSO.FileExists (strTMPDIR & "/menu.lst") Then
   ' Open the file
   set objFile = objFSO.OpenTextFile (strTMPDIR & "/menu.lst", 2)
  Else
   ' Create a new file
   set objFile = objFSO.CreateTextFile(strTMPDIR & "/menu.lst",1)
  end If
  ' Save the file
  objFile.Write (strMenuLST)
 
  objFile.Close
  Set objFile = Nothing
 end if
 
 ' File name of batch file that builds the .iso
 strCMD = strMyDir & "build.bat"
  
 ' Make sure this file exists. Otherwise, say "Not Implimented"
 ' Initialize the File System Object
 Set objFSO = CreateObject("Scripting.FileSystemObject")
 if Not objFSO.FileExists(strCMD) Then
  alert "Can't find " & strCMD & ". Unable to build the .iso file."
 Else
  ' The actual command line.
  strCMD = "cmd /c """ & strCMD & """"
    
  ' Run CMD
  intResult = objShell.Run (strCMD, 0, true)
  
  If intResult <> 0 Then
   BuildISO = "ISO Creation failed with Error Code: " & intResult
  Else
   BuildISO = "ISO Created."
  End If
  
 end If
 
 ' Clean up the temp directory
 set objFolder = objFSO.GetFolder(strTMPDIR)
 objFolder.Delete
 set objFolder = nothing
 set objFSO = nothing

End Function
