@echo off

:: Copyright (c) 2011, Intel Corporation
:: All rights reserved.
::  
:: Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
:: 
::     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
::     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
::     * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
:: 
:: THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

set COMPORT=
set MEV=

:: Load SOL driver
drvload %SYSTEMDRIVE%\windows\inf\6\mesrl.inf 2>&1 >nul

:: Find SOL port
for /f "tokens=3" %%A in ('reg query HKLM\Hardware\Devicemap\Serialcomm /s ^| find /i "REG_SZ"') do (
set COMPORT=%%A
)
:: If SOL port found, notify user of status.
if "%COMPORT%"=="" goto try_7
set MEV=6
goto found_sol

:try_7
:: Load SOL driver
drvload %SYSTEMDRIVE%\windows\inf\7\mesrl.inf 2>&1 >nul

:: Find SOL port
for /f "tokens=3" %%A in ('reg query HKLM\Hardware\Devicemap\Serialcomm /s ^| find /i "REG_SZ"') do (
set COMPORT=%%A
)
:: If SOL port found, notify user of status.
if "%COMPORT%"=="" goto try_8
set MEV=7
goto found_sol

:try_8
:: Load SOL driver
drvload %SYSTEMDRIVE%\windows\inf\8\mesrl.inf 2>&1 >nul

:: Find SOL port
for /f "tokens=3" %%A in ('reg query HKLM\Hardware\Devicemap\Serialcomm /s ^| find /i "REG_SZ"') do (
set COMPORT=%%A
)
:: If SOL port found, notify user of status.
if "%COMPORT%"=="" goto try_5
set MEV=8
goto found_sol

:try_5
:: Load SOL driver
drvload %SYSTEMDRIVE%\windows\inf\5\mesrl.inf 2>&1 >nul

:: Find SOL port
for /f "tokens=3" %%A in ('reg query HKLM\Hardware\Devicemap\Serialcomm /s ^| find /i "REG_SZ"') do (
set COMPORT=%%A
)
:: If SOL port found, notify user of status.
if "%COMPORT%"=="" goto try_4
set MEV=5
goto found_sol

:try_4
:: Load SOL driver
drvload %SYSTEMDRIVE%\windows\inf\4\mesrl.inf 2>&1 >nul

:: Find SOL port
for /f "tokens=3" %%A in ('reg query HKLM\Hardware\Devicemap\Serialcomm /s ^| find /i "REG_SZ"') do (
set COMPORT=%%A
)
:: If SOL port found, notify user of status.
if "%COMPORT%"=="" goto try_2.5
set MEV=4
goto found_sol

:try_2.5
:: Load SOL driver
drvload %SYSTEMDRIVE%\windows\inf\2.5\mesrl.inf 2>&1 >nul

:: Find SOL port
for /f "tokens=3" %%A in ('reg query HKLM\Hardware\Devicemap\Serialcomm /s ^| find /i "REG_SZ"') do (
set COMPORT=%%A
)
:: If SOL port found, notify user of status.
if "%COMPORT%"=="" goto try_3
set MEV=2.5
goto found_sol

:try_3
:: Load SOL driver
drvload %SYSTEMDRIVE%\windows\inf\3\mesrl.inf 2>&1 >nul

:: Find SOL port
for /f "tokens=3" %%A in ('reg query HKLM\Hardware\Devicemap\Serialcomm /s ^| find /i "REG_SZ"') do (
set COMPORT=%%A
)
:: If SOL port found, notify user of status.
if "%COMPORT%"=="" goto no_sol
set MEV=3
goto found_sol


:found_sol
echo Found SOL device on %COMPORT%

:: Load the putty session
regedit /s sol_session.reg

:: Apply the proper com port
reg ADD HKCU\Software\SimonTatham\PuTTY\Sessions\SOL /v SerialLine /d "%COMPORT%"

:: Create the log
echo set COMPORT=%COMPORT% > sol_log.bat
echo set MEV=%MEV% >> sol_log.bat

:: start tail and plink to manage in and out from SOL.
:: 
:: This allows batch files, etc to write to sol_in.txt to send a message and read from sol_out.txt to receive a message.
:: By default, the first command sent is a question to find out if RIL is available.
:: If direct control of the SOL port is desired, kill plink and tail proccesses.

cscript /nologo %~dp0tail.vbs %~dp0sol_in.txt | plink -batch SOL > %~dp0sol_out.txt

goto end

:no_sol
echo Unable to identify SOL device.
echo Unable to identify SOL device. > sol_log.txt
echo set COMPORT=NUL > sol_log.bat
goto end

:end