@echo off

:: Copyright (c) 2011, Intel Corporation
:: All rights reserved.
::  
:: Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
:: 
::     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
::     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
::     * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
:: 
:: THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

if not exist %~dp0settings.bat (
 echo Missing %~dp0settings.bat.
 goto end
)

:: Get the settings
call %~dp0settings.bat

:: Make the temp dir if needed
if not exist %ISOBLDRTMP% mkdir %ISOBLDRTMP%
if not exist %ISO_ROOT% mkdir %ISO_ROOT%
if not exist %TMPSRCDIR% mkdir %TMPSRCDIR%

:: Extract winpe.wim
set FILE=%PEARCH%\winpe.wim
%~dp07z.exe e "%WAIKSUP%" %FILE% -y -o%ISO_ROOT%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

:: Extract bootmgr
set FILE=%PEARCH%\bootmgr
%~dp07z.exe e "%WAIKSUP%" %FILE% -y -o%ISO_ROOT%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

if not "%ARCH%"=="x64" goto skip_files

:: Extract bootmgr.efi
set FILE=%PEARCH%\bootmgr.efi
%~dp07z.exe e "%WAIKSUP%" %FILE% -y -o%ISO_ROOT%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

:: Extract efi
set FILE=%PEARCH%\EFI\*
%~dp07z.exe x "%WAIKSUP%" %FILE% -y -o%ISOBLDRTMP% 
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)


:skip_files
:: Extract boot
set FILE=%PEARCH%\boot\*
%~dp07z.exe x "%WAIKSUP%" %FILE% -y -o%ISOBLDRTMP% 
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

:: Make and fill the sources directory
if not exist %ISO_ROOT%\SOURCES mkdir %ISO_ROOT%\SOURCES
move /y %ISO_ROOT%\winpe.wim %ISO_ROOT%\SOURCES\boot.wim
if not %ERRORLEVEL%==0 (
 echo Unable to move winpe.wim to sources directory.
 goto end
)

:: Cleanup extra junk bootfix.bin
set FILE=%ISOBLDRTMP%\%PEARCH%\boot\bootfix.bin
del /q /f %FILE% > NUL
if not %ERRORLEVEL%==0 (
 echo Unable to delete %FILE%.
 goto end
)

:: Cleanup the name mismatch
xcopy /cherky %ISOBLDRTMP%\%PEARCH%\*.* %ISO_ROOT%\*.*
if not %ERRORLEVEL%==0 (
 echo Unable to move x64 files.
 goto end
)

del /s /f /q %ISOBLDRTMP%\%PEARCH%
if not %ERRORLEVEL%==0 (
 echo Unable to delete %PEARCH% files.
 goto end
)


:: Don't need. Using oscdimg now.
:::: Copy menu.lst
::set FILE=%~dp0pe_iso_menu.lst
::copy /y %FILE% %ISO_ROOT%\menu.lst
::if not %ERRORLEVEL%==0 (
:: echo Unable to copy %FILE%.
:: goto end
::)
::
:::: Copy grldr
::set FILE=%~dp0grldr
::copy /y %FILE% %ISO_ROOT%\
::if not %ERRORLEVEL%==0 (
:: echo Unable to copy %FILE%.
:: goto end
::)
::
:::: Copy pe.tag
::set FILE=%~dp0pe.tag
::copy /y %FILE% %ISO_ROOT%\
::if not %ERRORLEVEL%==0 (
:: echo Unable to copy %FILE%.
:: goto end
::)

:: Extract oscdimg for 
:: Be sure the WAIK is set
if "%WAIK%"=="" (
 echo WAIK not found.
 goto end
)
:: Extract Neutral.cab from the MSI file
set FILE=Neutral.cab
%~dp07z.exe e "%WAIK%" %FILE% -y -o%ISOBLDRTMP%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%.
 goto end
)
:: Extract oscdimg
set LASTFILE=%ISOBLDRTMP%\%FILE%
set FILE=F1_oscdimg
%~dp07z.exe e %LASTFILE% %FILE% -y -o%ISOBLDRTMP%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%.
 goto end
)
::del /q /f %LASTFILE%
move %ISOBLDRTMP%\%FILE% %TMPSRCDIR%\oscdimg.exe
if not exist %TMPSRCDIR%\oscdimg.exe (
 echo Unable to extract oscdimg.exe
 goto end
)

::Extract Drivers
mkdir %ISOBLDRTMP%\drivers
%~dp07z.exe x "%MEIDRVARCH%" -y -o%ISOBLDRTMP%\drivers
if not %ERRORLEVEL%==0 (
 echo Unable to extract driver archive %MEIDRVARCH%.
 goto end
)
%~dp07z.exe x "%LANDRVARCH%" -y -o%ISOBLDRTMP%\drivers
if not %ERRORLEVEL%==0 (
 echo Unable to extract driver archive %LANDRVARCH%.
 goto end
)
echo Success
:end
