'Copyright (c) 2011, Intel Corporation
'All rights reserved.
'
'Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
'
'    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
'    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
'    * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
'
'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 

' Get settings
Dim objShell, objFSO, objFile, objGatherFile
Dim colSettings
Dim strSettingsFile, strSupportFileXML
Dim strCSApplist, strAppDir, strGatherFile, strGatherList


Set colSettings = CreateObject("Scripting.Dictionary")
Set objShell = CreateObject("WScript.shell")
Set objFSO = CreateObject("Scripting.FileSystemObject")

strMyDir = LEFT(Wscript.ScriptFullName,(LEN(Wscript.ScriptFullName)-LEN(Wscript.ScriptName)))
strAppDir = strMyDir & "..\Apps"

strSettingsFile = strMyDir & "\settings.xml"
strSupportFileXML = strMyDir & "\ISOs.xml"
strBatchFileName = strMyDir & "\settings.bat"

'If this file exists read what's there.
if objFSO.FileExists(strSettingsFile) Then
 GetSettings()
else
 wscript.echo "Missing " & strSettingsFile
 wscript.quit(1)
end if


' For Selected apps that request W7
strGatherList = ""
Set objFSO = CreateObject("Scripting.FileSystemObject")
for each strTMP in split(strCSAppList,",")
 if (colSettings.item(strTMP) = "yes" or colSettings.item("USECASE") = strTMP) _
  and colSettings.item("NEEDW7SP1." & colSettings.item("ARCH") & "." & strTMP) = "true" _
 then
 ' Read in \app\%appnamr%\inc\gather_manifest_%arch%.txt
  strGatherFile = strAppDir & "\" & strTMP & "\inc\gather_manifest_" & colSettings.item("ARCH") & ".txt"
  if objFSO.FileExists(strGatherFile) Then
   set objGatherFile = objFSO.OpenTextFile(strGatherFile, 1)
   strGatherList = strGatherList & vbCrLf & objGatherFile.ReadAll
   objGatherFile.Close
  end if
 end if
next

for each strTMP in split(strGatherList,vbCrLf)
 if not CopyFile(strTMP) then
  wscript.quit(1)
 end if
next

wscript.echo "Success"

' Remove duplicate files from the list
 
 
' Copy files from \tmp\w7\ to \tmp\%arch%\



wscript.quit(0)


Function GetXMLData(strFileName,strPackage)
 Dim strTMP
 Dim xmlDoc, x
 Set xmlDoc=CreateObject("Microsoft.XMLDOM")
 xmlDoc.async="false"
 on error resume next
 xmlDoc.load(strFileName)
 if not (xmlDoc.parseError.errorCode = 0) then
  strTMP = "Error in line " & xmlDoc.parseError.line & _
  " position " & xmlDoc.parseError.linePos & _
  vbCrLf & "<BR>Error Code: " & xmlDoc.parseError.errorCode & _
  vbCrLf & "<BR>Error Reason: "& xmlDoc.parseError.reason & _
  vbCrLf & "<BR>Error Line: " & xmlDoc.parseError.srcText
  strTMP=UpdatePageStatus(strTMP,0,0)
 else
  if not err.number = 0 then
   strTMP=UpdatePageStatus(err.number & " " & err.description,0,0)
   err.clear
  else
   ' backward compatibility for package.xml that doesn't have an ID field
   ' It'll get changed if it's in the package.xml
   colSettings.Item("ID." & strPackage) = strPackage
   For Each x in xmlDoc.documentElement.childNodes
    if strPackage = "" then
     colSettings.Item(x.nodename) = x.text
    else
     colSettings.Item(x.nodename & "." & strPackage) = x.text
    end if
   Next
  end if
 end if
 set xmlDoc = nothing
End Function

Function GetSettings
 ' File System Object
 Set objFSO = CreateObject("Scripting.FileSystemObject")
 ' Read in the settings file if it exists
 if objFSO.FileExists(strSettingsFile) Then
  strTMP = GetXMLData(strSettingsFile,"")
  
  ' Read each package.xml
  strCSAppList = ""
  strAppDir = strMyDir & "..\Apps"
  if objFSO.FolderExists(strAppDir) then
   set objFolder = objFSO.GetFolder(strAppDir)
   set objSubFolders = objFolder.SubFolders
   for each strFolder in objSubFolders
    'grab just the file name, no extention or path
    strDesiredXMLFile = strAppDir & "\" & strFolder.name & "\inc\package.xml"
    ' only if package.xml exists
    if objFSO.FileExists(strDesiredXMLFile) then
     strTMP = strFolder.name
     strTMP1 = GetXMLData(strDesiredXMLFile,strTMP)
     strCSAppList = strCSAppList & "," & strTMP
    end if
   next 
  end if
 end if

end function

function CopyFile(strFile)
 dim strGatherList, strFileName, arrFileList
 dim objFSO, objSourceFile, objDestinationFile
 dim objShell
 dim flgCopySuccess
 dim strDestinationFolder, strSourceFolder

 flgCopySuccess = true

 Set objFSO = CreateObject("Scripting.FileSystemObject")
 Set objShell = CreateObject("WScript.Shell")
 
 strSourceFolder = objShell.ExpandEnvironmentStrings("%ISOBLDRTMP%") & "w7\mount"
 strSourceFile = strSourceFolder & strFile
 'wscript.echo "Source: " & strSourceFolder & strFile
 
 strDestinationFolder = objShell.ExpandEnvironmentStrings("%ISOBLDRTMP%") & "mount"
 strDestinationFile = strDestinationFolder & strFile
 'wscript.echo "Destination: " & strDestinationFolder & strFile
 
 ' # is a comment
 if left(strFile,1) = "#" then
 wscript.echo "Skipping comment."
 
 ' don't error on blank lines
 elseif strFile = "" then
  wscript.echo "Skipping blank line."

 ' Only Process if the source File exists
 elseif objFSO.FileExists(strSourceFile) then
  'wscript.echo "Found " &  strSourceFile
  ' Decide if the folders need creation at the destination
  strFolderName = strDestinationFolder
  arrTMP = split(strFile,"\")
  for each strFolder in arrTMP
   if not strFolder = "" then
    strFolderName = strFolderName & "\" & strFolder
    'wscript.echo strFoldername
    ' if this is the file, copy it
    if strFolderName = strDestinationFile then
     on error resume next
     wscript.echo "Copying " & strSourceFile & "."
     objFSO.copyfile strSourceFile,strDestinationFile, True
     if not objFSO.FileExists(strDestinationFile) then
      ' cant copy the file
      wscript.echo "Unable to copy file:" & vbCrLf & strDestinationFolder & strFileName & vbCrLf & "Please try again, or copy the file manually."
      flgCopySuccess = false
     end if
     on error goto 0
    ' if the folder doesn't exist, create it
    elseif not objFSO.FolderExists(strFolderName) then
     on error resume next
      wscript.echo "Creating " & strFolderName &"."
      objFSO.CreateFolder(strFolderName)
     on error goto 0
     if not objFSO.FolderExists(strFolderName) then
      ' Can't create the folder
      wscript.echo "Unable to create " & strFolderName & "."
      flgCopySuccess = false
     end if
    end if
   end if
  next 
 else
  ' Source File not found
  wscript.echo "Source file not found: " & strSourceFile & "."
  flgCopySuccess = false
 end if
 CopyFile = flgCopySuccess
end function