'Copyright (c) 2011, Intel Corporation
'All rights reserved.
'
'Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
'
'    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
'    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
'    * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
'
'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


Dim objShell, objFSO, objFile
Dim colSettings
Dim strSettingsFile, strSupportFileXML, strERR, strArg, strTMPLogFile
Dim strAppDir, strBatchFileName, strMyDir, strTMP, strTMP1, strUC, strPKG
Dim intVerboseLog
intVerboseLog = 1

Set colSettings = CreateObject("Scripting.Dictionary")
Set objShell = CreateObject("WScript.shell")
Set objFSO = CreateObject("Scripting.FileSystemObject")

if not wscript.arguments.Count = 0 then
 strArg = wscript.arguments(0)
end if

strMyDir = LEFT(Wscript.ScriptFullName,(LEN(Wscript.ScriptFullName)-LEN(Wscript.ScriptName)))

strSettingsFile = strMyDir & "\settings.xml"
strSupportFileXML = strMyDir & "\ISOs.xml"
strBatchFileName = strMyDir & "\settings.bat"
strERR = 0

'If this file exists read what's there.
if objFSO.FileExists(strSettingsFile) Then
 strTMP = GetXMLData(strSettingsFile,"")
else
 wscript.echo "Missing " & strSettingsFile
 wscript.quit(1)
end if

'Loop through the packages
strAppDir = strMyDir & "..\Apps"
' Always load the default pacakge
strPKG = strAppDir & "\default\inc\" & strArg & ".bat" 
strTMPLogFile = strMyDir & "tmp1.log"
if objFSO.FolderExists(strAppDir) then
 set objFolder = objFSO.GetFolder(strAppDir)
 set objSubFolders = objFolder.SubFolders
 for each strFolder in objSubFolders
  strDesiredXMLFile = strAppDir & "\" & strFolder.name & "\inc\package.xml"
  ' only if package.xml exists
  if objFSO.FileExists(strDesiredXMLFile) then
   strTMP = strFolder.name
   strTMP1 = GetXMLData(strDesiredXMLFile,strTMP)
   strDesiredScriptFile = strAppDir & "\" & strTMP & "\inc\" & strArg & ".bat"
   if colSettings.item("TYPE." & strTMP) = "USECASE" then
    if colSettings.item("USECASE") = strTMP then
     if objFSO.FileExists(strDesiredScriptFile) then
      strUC = strDesiredScriptFile 
     end if
    end if
   else
    if colSettings.item(strTMP) = "yes" then
     if objFSO.FileExists(strDesiredScriptFile) then
      strPKG = strPKG & "," & strDesiredScriptFile
     end if 
    end if
   end if
  end if
 next

end if

arrScripts = split(strPKG & "," & strUC,",")
for each strRunScript in arrScripts
 if not strRunScript = "" then
  wscript.echo "Running " & strRunScript
  if objFSO.FileExists (strRunScript) Then
   ' The actual command line.
   strCMD = "cmd /c """ & strRunScript & """ > " & strTMPLogFile
   ' Run CMD
   strResult = objShell.Run(strCMD, 0, true)
   if objFSO.FileExists(strTMPLogFile) Then
    set objFile = objFSO.OpenTextFile(strTMPLogFile, 1)
    strResult = objFile.ReadAll
    objFile.Close
    set objFile = nothing
    if intVerboseLog = 1 then
     wscript.echo strResult
    end if
    objFSO.DeleteFile(strTMPLogFile)
    if LEFT(right(strResult,9),7) = "Success" then
     wscript.echo strRunScript & " Reports Success."
    else
     wscript.echo strRunScript & " Reports Failure."
     strErr = 1
     Exit For
    end if 
   else
    wscript.echo strRunScript & " Didn't Report."
    strErr = 1
    Exit For
   end If
  else
   wscript.echo strRunScript & " Doesn't Exist."
   strErr = 1
   Exit For
  end if
 end if
next 
' Clean up
set objFile = nothing
set objFSO = nothing
set objShell = nothing

if strErr = 0 then
 wscript.echo "Success"
end if

Function GetXMLData(strFileName,strPackage)
 Dim strTMP
 Dim xmlDoc, x
 Set xmlDoc=CreateObject("Microsoft.XMLDOM")
 xmlDoc.async="false"
 on error resume next
 xmlDoc.load(strFileName)
 if not (xmlDoc.parseError.errorCode = 0) then
  strTMP = "Error in line " & xmlDoc.parseError.line & _
  " position " & xmlDoc.parseError.linePos & _
  vbCrLf & "<BR>Error Code: " & xmlDoc.parseError.errorCode & _
  vbCrLf & "<BR>Error Reason: "& xmlDoc.parseError.reason & _
  vbCrLf & "<BR>Error Line: " & xmlDoc.parseError.srcText
  strTMP=UpdatePageStatus(strTMP,0,0)
 else
  if not err.number = 0 then
   strTMP=UpdatePageStatus(err.number & " " & err.description,0,0)
   err.clear
  else
   ' backward compatibility for package.xml that doesn't have an ID field
   ' It'll get changed if it's in the package.xml
   colSettings.Item("ID." & strPackage) = strPackage
   For Each x in xmlDoc.documentElement.childNodes
    if strPackage = "" then
     colSettings.Item(x.nodename) = x.text
    else
     colSettings.Item(x.nodename & "." & strPackage) = x.text
    end if
   Next
  end if
 end if
 set xmlDoc = nothing
End Function