'Copyright (c) 2011, Intel Corporation
'All rights reserved.
'
'Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
'
'    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
'    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
'    * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
'
'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 

Dim objShell, objFSO, objFile
Dim colSettings
Dim strSettingsFile, strSupportFileXML, strBatchFile, strBatchFileName, strMyDir, strBAT, strDriverFileXML
Dim strCSApplist

Set colSettings = CreateObject("Scripting.Dictionary")
Set objShell = CreateObject("WScript.shell")
Set objFSO = CreateObject("Scripting.FileSystemObject")

' Initialize the File System Object
Set objFSO = CreateObject("Scripting.FileSystemObject")


strMyDir = objFSO.GetParentFolderName(WScript.ScriptFullName)
strMyParentDir = objFSO.GetParentFolderName(strMyDir)

strSettingsFile = strMyDir & "\settings.xml"
strSupportFileXML = strMyDir & "\ISOs.xml"
strDriverFileXML = strMyDir & "\drivers.xml"
strBatchFileName = strMyDir & "\settings.bat"

'If this file exists read what's there.
if objFSO.FileExists(strSettingsFile) Then
 GetSettings()
else
 wscript.echo "Missing " & strSettingsFile
 wscript.quit(1)
end if

' Verify the required files exist
if not ValidateSupportedFiles() then
 wscript.echo "Support File missing."
 wscript.quit(2)
end if

' make a batch file with the setting as Dos Variables. 
' strBAT was filled in by ValidateSupportedFiles()
if colSettings.item("ARCH") = "x64" then
 strPEARCH = "amd64"
else
 strPEARCH = colSettings.item("ARCH")
end if

' randomize
strTMPROOT = strMyDir & "\tmp" 
Randomize
strTMPDIR = strTMPROOT & "\" & int(10*rnd) & int(10*rnd) & int(10*rnd)

strBatchFile = "" & _
 "@echo off" & vbCrLf & _
 vbCrLf & _
 "set ARCH=" & colSettings.item("ARCH")  & vbCrLf & _
 "set PEARCH=" & strPEARCH  & vbCrLf & _
 "set LANG=" & colSettings.item("LANG")  & vbCrLf & _
 "set APP=" & colSettings.item("APP")  & vbCrLf & _
 "set FILENAME=" & colSettings.item("FILENAME")  & vbCrLf & _
 "set ISOBLDRTMPRT=" & strTMPROOT & "\" & vbCrLf & _
 "set ISOBLDRTMP=" & strTMPDIR & "\"  & vbCrLf & _
 "set MNT_DIR=" & strTMPDIR & "\mount\"  & vbCrLf & _
 "set FPS_DIR=" & strTMPDIR & "\WINPE_FPS\"  & vbCrLf & _
 "set DRV_DIR=" & strTMPDIR & "\drivers\"  & vbCrLf & _
 "set w7_DIR=" & strTMPDIR & "\w7\"  & vbCrLf & _
 "set w7MNT_DIR=" & strTMPDIR & "\w7\mount\"  & vbCrLf & _
 "set TMPSRCDIR=" & strTMPDIR & "\inc\"  & vbCrLf & _
 "set ISO_ROOT=" & strTMPDIR & "\ISO_ROOT\"  & vbCrLf & _
 strBAT & _
 ":end" & vbCrLf & _
 ""


'strBatchFile = "" & _
' "set WAIK=" & colSettings.item("e6714ae5-292b-4ab7-8e21-f0b1095af26c")  & vbCrLf & _
' "set WAIKSUP=" & colSettings.item("c4e22312-d316-46e7-bd26-8ea9ca2039d2")  & vbCrLf & _
' "set MEIDRVARCH=" & colSettings.item("b4a79a89-eec0-4fd2-84b0-e9d00e55ad4e")  & vbCrLf & _
' "set LANDRVARCH=" & colSettings.item("b4a79a89-fec0-4fd2-84b0-e9d00e55ad4e")  & vbCrLf & _
' ":end" & vbCrLf & _
' ""

' Write the file
' Does the file exist
if objFSO.FileExists (strBatchFileName) then
 ' Open the file
 set objFile = objFSO.OpenTextFile (strBatchFileName, 2)
else
 ' Create a new file
 set objFile = objFSO.CreateTextFile(strBatchFileName,1)
end if

objFile.Write (strBatchFile)
objFile.Close
 
' Clean up
set objFile = nothing
set objFSO = nothing
set objShell = nothing

wscript.echo "Success"


Function GetXMLData(strFileName,strPackage)
 Dim strTMP
 Dim xmlDoc, x
 Set xmlDoc=CreateObject("Microsoft.XMLDOM")
 xmlDoc.async="false"
 on error resume next
 xmlDoc.load(strFileName)
 if not (xmlDoc.parseError.errorCode = 0) then
  strTMP = "Error in line " & xmlDoc.parseError.line & _
  " position " & xmlDoc.parseError.linePos & _
  vbCrLf & "<BR>Error Code: " & xmlDoc.parseError.errorCode & _
  vbCrLf & "<BR>Error Reason: "& xmlDoc.parseError.reason & _
  vbCrLf & "<BR>Error Line: " & xmlDoc.parseError.srcText
  strTMP=UpdatePageStatus(strTMP,0,0)
 else
  if not err.number = 0 then
   strTMP=UpdatePageStatus(err.number & " " & err.description,0,0)
   err.clear
  else
   ' backward compatibility for package.xml that doesn't have an ID field
   ' It'll get changed if it's in the package.xml
   colSettings.Item("ID." & strPackage) = strPackage
   For Each x in xmlDoc.documentElement.childNodes
    if strPackage = "" then
     colSettings.Item(x.nodename) = x.text
    else
     colSettings.Item(x.nodename & "." & strPackage) = x.text
    end if
   Next
  end if
 end if
 set xmlDoc = nothing
End Function

Function GetSettings
 ' File System Object
 Set objFSO = CreateObject("Scripting.FileSystemObject")
 ' Read in the settings file if it exists
 if objFSO.FileExists(strSettingsFile) Then
  strTMP = GetXMLData(strSettingsFile,"")
  
  ' Read each package.xml
  strCSAppList = ""
  strAppDir = strMyParentDir & "\Apps"
  if objFSO.FolderExists(strAppDir) then
   set objFolder = objFSO.GetFolder(strAppDir)
   set objSubFolders = objFolder.SubFolders
   for each strFolder in objSubFolders
    'grab just the file name, no extention or path
    strDesiredXMLFile = strAppDir & "\" & strFolder.name & "\inc\package.xml"
    ' only if package.xml exists
    if objFSO.FileExists(strDesiredXMLFile) then
     strTMP = strFolder.name
     strTMP1 = GetXMLData(strDesiredXMLFile,strTMP)
     strCSAppList = strCSAppList & "," & strTMP
    end if
   next 
  end if
 end if

end function

function ValidateSupportedFiles()
 ' For refernece:
 ' e6714ae5-292b-4ab7-8e21-f0b1095af26c = WAIK for Win7
 ' c4e22312-d316-46e7-bd26-8ea9ca2039d2 = WAIK Suppliment for Win7 SP1
 ' Selected File name is "ColSettings.Item(<GUID>)"
 ' If it's passed the checksum, ColSettings.Item(<GUID>.exists) will be true
 ' If ColSettings.Item(<GUID>.exists) doesn't exist, the file hasn't been checked yet.
 ' arrFiles hold all the GUIDs
 Dim objFSO, xmlDoc, objNode, objNode1, objNodes, objNodes1, objNodes2, objNode2
 Dim strQuery, strCSISOs
 Dim intAllFound, flgNeedW7sp1
 flgNeedW7sp1 = false
 intAllFound = true
 Set objFSO = CreateObject("Scripting.FileSystemObject")
 ' Build the list of Comma Separated files that hold the list of support files
 strCSISOs = strSupportFileXML & "," & strDriverFileXML
 for each strTMP in split(strCSAppList,",")
  if colSettings.item(strTMP) = "yes" or colSettings.item("USECASE") = strTMP then
   if objFSO.FileExists(strMyParentDir & "\Apps\" & strTMP & "\inc\ISOs.xml" ) then
    strCSISOs = strCSISOs & "," & strMyParentDir & "\Apps\" & strTMP & "\inc\ISOs.xml"
    ' Check to see if the package needs W7sp1
   end if
   if colSettings.item("NEEDW7SP1." & colSettings.item("ARCH") & "." & strTMP) = "true" then
    'wscript.echo "true"
    flgNeedW7sp1 = true
   end if
  end if
 next
 strBAT = ""
 for each strFile in split(strCSISOs,",")
  'Validate that we have the required support files
  'strSupportFileXML holds the list of support files and their checksums
   'wscript.echo strFile 
   if objFSO.FileExists(strFile) Then
    Set xmlDoc=CreateObject("Microsoft.XMLDOM")
    xmlDoc.async="false"
    xmlDoc.load(strFile)
    ' Find the GUID for all required files. This is used to reference them in the settings file
    strQuery = "/SETTINGS/SUPPORTFILE/GUID"
    Set objNodes = xmlDoc.selectNodes(strQuery)
    For Each objNode in objNodes   
     if (objNode.text = "c4a89a89-fec0-7fd2-84c0-f9d00e55ad4e" and flgNeedw7sp1 and colSettings.item("ARCH") = "x86") or (objNode.text = "d4a89a89-fec0-7fd2-84c0-f9d00e55ad4e" and flgNeedw7sp1 and colSettings.item("ARCH") = "x64") or (objNode.text <> "c4a89a89-fec0-7fd2-84c0-f9d00e55ad4e" and objNode.text <> "d4a89a89-fec0-7fd2-84c0-f9d00e55ad4e") then
      ' Now get the default name for each file.
      strQuery = "/SETTINGS/SUPPORTFILE [ GUID = '" & objNode.text & "' ] / ( DEFAULTNAME )"
      Set objNodes1 = xmlDoc.selectNodes(strQuery)
      For Each objNode1 in objNodes1
       ' Check that a valid file is selected
       if ColSettings.Item(objNode.text) = "" or (not(ColSettings.exists(objNode.text))) then
        ColSettings.Item(objNode.text) = strMyDir & "\..\src\" & objNode1.text
       end if
       if objFSO.FileExists(ColSettings.Item(objNode.text)) Then
        ' ColSettings.Item(objNode.text & ".exists") = Compare_hash(ColSettings.Item(objNode.text),objNode1.text)
        ' No longer verifying the checksums. It takes too long.
        ' may add it back later. For now, the build process will stop if this is the wrong file.
        ' 
        ' Build part of the setting batch file for all required files
        ' Here so this can be copy /paste between makesetting.vbs and iso_builder.hta
        strQuery = "/SETTINGS/SUPPORTFILE [ GUID = '" & objNode.text & "' ] / ( DOSVAR )"
        ColSettings.Item(objNode.text & ".exists") = true
        Set objNodes2 = xmlDoc.selectNodes(strQuery)
        For Each objNode2 in objNodes2
         strBAT = strBAT & _
          "set " & objNode2.text & "=" & ColSettings.Item(objNode.text) & vbCrLf
        Next
       else
        ColSettings.Item(objNode.text & ".exists") = false
        intAllFound = false
       end if
      Next
     end if   
    Next
   end if
  next
 ValidateSupportedFiles = intAllFound
end function