@echo off

:: Copyright (c) 2011, Intel Corporation
:: All rights reserved.
::  
:: Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
:: 
::     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
::     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
::     * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
:: 
:: THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

if not exist %~dp0settings.bat (
 echo Missing %~dp0settings.bat.
 goto end
)

:: Get the settings
call %~dp0settings.bat

:: Make the temp dir if needed
if not exist %ISOBLDRTMP% mkdir %ISOBLDRTMP%
if not exist %w7_DIR% mkdir %w7_DIR%

:: Extract install.wim
set FILE=sources\install.wim
echo %~dp07z.exe e "%W7SP1ISO%" %FILE% -y -o%w7_DIR%
%~dp07z.exe e "%W7SP1ISO%" %FILE% -y -o%w7_DIR%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

:: Mount install.wim
set WIM=%w7_DIR%\install.wim
if not exist %WIM% (
 Echo %WIM% is missing. Unable to continue.
 goto end
)

if not exist %w7MNT_DIR% mkdir %w7MNT_DIR%

Dism /mount-WIM /wimfile:%WIM% /index:1 /mountdir:%w7MNT_DIR%
if not %ERRORLEVEL%==0 (
 echo Unable to mount %WIM%.
 goto end
)

echo Success
:end
