::'Copyright (c) 2011, Intel Corporation
::'All rights reserved.
::'
::'Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
::'
::'    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
::'    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
::'    * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
::'
::'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


@echo off

:: Verify Input
if "%1"=="" goto err
if not exist "%1" goto err
:: Verify a .iso file. There's gotta be a better way.
echo %1 | find /i ".iso" > NUL 2>&1
if not %ERRORLEVEL%==0 goto err
echo Working on %1.
echo.

:: Make the temp dir if needed
:tmp_create
SET TMP_DIR=%TMP%\%~n0%RANDOM%
If exist "%TMP_DIR%" goto :tmp_create
MKDIR "%TMP_DIR%" >NUL 2>&1


:: Extract the .iso
set CMD="%~dp0/inc/7z.exe" x "%1" -y -r -o"%TMP_DIR%"
echo Extracting "%1" to "%TMP_DIR%" with command:
echo %CMD%
echo.
%CMD% > NUL 2>&1
if not %ERRORLEVEL%==0 (
 echo Failed to extract %1.
 echo.
 pause
 goto end
)

:: Only continue if bootfix.bin exists
if not exist "%TMP_DIR%\BOOT\bootfix.bin" (
 echo "%TMP_DIR%\BOOT\bootfix.bin" file not found.
 echo bootfix.bin is the file that causes the Press Any Key message.
 echo There is nothing to do on this image.
 echo.
 pause
 goto end
)


:: Remove the extra
echo Removing bootfix.bin.
echo.
rd /q /s "%TMP_DIR%\[BOOT]">NUL 2>&1
del /q /f "%TMP_DIR%\BOOT\bootfix.bin">NUL 2>&1

:: Add GRLDR
copy /y "%~dp0inc\grldr" "%TMP_DIR%">NUL 2>&1
copy /y "%~dp0inc\PE.TAG" "%TMP_DIR%">NUL 2>&1
copy /y "%~dp0inc\pe_iso_menu.lst" "%TMP_DIR%\menu.lst">NUL 2>&1


:: make a new ISO
echo Making the new ISO Image: "%1.no_pak.iso"
set CMD="%~dp0inc\mkisofs" -R -b grldr -no-emul-boot -boot-load-size 4 -o "%1.no_pak.iso" "%TMP_DIR%"
echo with command:
echo %CMD%
echo.
"%~dp0inc\mkisofs" -R -b grldr -no-emul-boot -boot-load-size 4 -o "%1.no_pak.iso" "%TMP_DIR%">NUL 2>&1
if not %ERRORLEVEL%==0 (
 echo Failed to build the ISO image.
 echo .
 pause
 goto end
)

goto end


:err
echo Drag and drop a WinPE ISO file onto me. I'll remove the "Press Any Key to Continue" message.
pause
goto :eof

:end
if exist "%TMP_DIR%" rd /q /s "%TMP_DIR%"
goto :eof