/*********************************************************************/
/*                     Intel Confidential                            */
/*********************************************************************/

/**********************************************************************
**                                                                   **
**                I N T E L   P R O P R I E T A R Y                  **
**                                                                   **
**   COPYRIGHT (c)  2001 - 2011  BY  INTEL  CORPORATION.       ALL   **
**   RIGHTS RESERVED.   NO PART OF THIS PROGRAM OR PUBLICATION MAY   **
**   BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A   **
**   RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER   **
**   LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,   **
**   MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT   **
**   THE PRIOR WRITTEN PERMISSION OF :                               **
**                                                                   **
**                      INTEL  CORPORATION                           **
**                                                                   **
**                2200 MISSION COLLEGE BOULEVARD                     **
**                                                                   **
**             SANTA  CLARA,  CALIFORNIA  95052-8119                 **
**                                                                   **
**********************************************************************/
/**********************************************************************
*                                                                     *
* INTEL CORPORATION PROPRIETARY INFORMATION                           *
* This software is supplied under the terms of a license agreement    *
* with Intel Corporation and may not be copied nor disclosed          *
* except in accordance with the terms of that agreement.              *
*                                                                     *
* Module Name:                                                        *
*   linuxnaldriver.h                                                  *
*                                                                     *
* Abstract:                                                           *
*   This is the main header file for the Nal Linux driver modules.    *
*                                                                     *
***********************************************************************
* VSS Revision Control Information:
* ---------------------------------
*   $Workfile: linuxnaldriver.h $
*   $Date: 2011/10/03 10:09:49 $
*   $Archive: /QV2.0/nal/inc/linux/linuxnaldriver.h $
*   $Revision: 1.18 $
**********************************************************************/

#ifndef __LINUXNALDRIVER_H__
#define __LINUXNALDRIVER_H__

#define DRIVER_NAME "Nal Linux Driver"

#include <naltypes.h>
#include <nalcodes.h>
#include <hwbus_t.h>
#include <linux/fs.h>
#include <osdevice_i.h>
#include <os_i.h>
#include <linuxnalioctl.h>


#define NAL_DRIVER_MAX_ADAPTERS 256
#define NAL_LINUX_DRIVER_NAME   "nal"  /* Also defined in linuxdevice.h for user mode. */

/* NAL linux driver version defines */
#define DRIVER_MAJOR_VERSION   1
#define DRIVER_MINOR_VERSION   2
#define DRIVER_BUILD_NUMBER    0
#define DRIVER_FIX_NUMBER      0

#ifndef MINOR_VERSION
#define MINOR_VERSION          DRIVER_MINOR_VERSION
#endif

/* Version macros */
#if MINOR_VERSION < 10
#define _MAKE_VER_STRING(maj, min, build, fix)    #maj ".0" #min "." #build "." #fix
#else
#define _MAKE_VER_STRING(maj, min, build, fix)    #maj "." #min "." #build "." #fix
#endif
#define MAKE_VER_STRING(maj, min, submin, bld)    _MAKE_VER_STRING(maj, min, submin, bld)


/* Define our NAL driver version */
#define DRIVER_FILEVERSION DRIVER_MAJOR_VERSION,DRIVER_MINOR_VERSION,DRIVER_BUILD_NUMBER,DRIVER_FIX_NUMBER
/* duplicate of the macro LINUX_DRIVER_VERSION
#define DRIVER_FILEVERSION_STR  MAKE_VER_STRING(DRIVER_MAJOR_VERSION, DRIVER_MINOR_VERSION, DRIVER_BUILD_NUMBER, DRIVER_FIX_NUMBER)
 */
#define DRIVER_FILEVERSION_STR  LINUX_DRIVER_VERSION

/* NAL driver version info strings */
#define DRIVER_FILEDESCRIPTION    "Intel(R) Network Adapter Diagnostic Driver "
#define DRIVER_COMPANYNAME        "Intel Corporation "
#define DRIVER_COPYRIGHT_YEARS    "2002-2011 "
#define DRIVER_LEGALCOPYRIGHT     "Copyright (C) " DRIVER_COPYRIGHT_YEARS DRIVER_COMPANYNAME "All Rights Reserved."

#define DRIVER_DESCRIPTION DRIVER_FILEDESCRIPTION DRIVER_FILEVERSION_STR

typedef struct _NAL_ADAPTER_IN_USE_TABLE
{
    NAL_DEVICE_LOCATION DeviceLocation;
    BOOLEAN             InUse;
} NAL_ADAPTER_IN_USE_TABLE;


/* Rounds up memory for sizes of powers of 2 for an aligned allocation */
#define NAL_LINUX_MEMORY_ROUNDUP(i, size) ((i) = (((i) + (size) - 1) & ~((size) - 1)))

/**************************************************************
 * Function Prototypes.
 **************************************************************/

/* Prototypes */
int
NalDeviceControl(
    struct inode*   Inode,
    struct file*    File,
    unsigned int    Cmd,
    unsigned long   Arg
    );

long
NalDeviceControlUnlockedIoctl(
    struct file*    File,
    unsigned int    Cmd,
    unsigned long   Arg
    );

int
NalOpen(
    struct inode* Inode,
    struct file*  File
    );

int
NalRelease(
    struct inode*   Inode,
    struct file*    File
    );


NAL_STATUS
_NalInitializeInterrupts(
    IN      NAL_LINUX_ISR_DEVICE*  NalIsrDevice
    );

NAL_STATUS
_NalUninitializeInterrupts(
    IN      NAL_LINUX_ISR_DEVICE*  NalIsrDevice
    );

BOOLEAN
_NalHasInterruptOccurred(
    IN      NAL_LINUX_ISR_DEVICE*  NalIsrDevice
    );

VOID
_NalDriverDecrementReferenceCount(
    VOID
    );

VOID
_NalDriverIncrementReferenceCount(
    VOID
    );

UINT32
_NalDriverGetReferenceCount(
    VOID
    );

VOID
_NalDriverGetVersion(
    OUT CHAR* Version
    );

#endif

