@echo off
rem *******************************************************************************
rem Make sure we are in the right directory
rem *******************************************************************************
if NOT exist .\PUSHCOPY.BAT GOTO WRONGDIR


rem *******************************************************************************
rem %1 = Destination Path
rem %2 = OS
rem *******************************************************************************

if /I "%2"=="XP"  goto WINXP
if /I "%2"=="XPX64"  goto WINXPX64
if /I "%2"=="WS03"  goto WS03
if /I "%2"=="VISTA32" goto VISTA32
if /I "%2"=="VISTAX64" goto VISTAX64
if /I "%2"=="WS0832" goto VISTA32
if /I "%2"=="WS08X64" goto VISTAX64
if /I "%2"=="WIN732" goto WIN732
if /I "%2"=="WIN7X64" goto WIN7X64
if /I "%2"=="WS08R2X64" goto WIN7X64

goto Usage

rem *******************************************************************************
rem 	WINXP file copies
rem *******************************************************************************
:WINXP
echo *** WinXP file copy

rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Win32\NDIS5x
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32\NDIS5x

REM **********************************************************************
REM  COPY Base driver files for Windows XP
REM **********************************************************************

rem 10/100 specific files to the root OEM directory and to the specific 10/1000/OS directory (needed for setupBD)
copy ..\..\..\PRO100\Win32\NDIS5x\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\Win32\NDIS5x

rem Gigabit specific files
copy ..\..\..\PRO1000\Win32\NDIS5x\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32\NDIS5x

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Win32

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

rem *******************************************************************************
rem Copy the sample UNATTEND.TXT, Install.bat and help file
rem *******************************************************************************
copy Win32\Unattend.txt %1\$oem$\$1\drivers\net\INTEL
copy Win32\push32.txt %1\$oem$\$1\drivers\net\INTEL
copy Win32\Install.bat %1\$oem$\$1\WMIScr

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32

REM *******************************************************************************
REM Copy the Intel I/O Acceleration Technology drivers
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\IOATDMA\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\NDIS5x\ioatco.dll %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\NDIS5x\ioatdma.sys %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\NDIS5x\ioatdma.inf %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\NDIS5x\ioatdma.cat %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS5x

Goto end

rem *******************************************************************************
rem 	WINXP x64 file copies
rem *******************************************************************************
:WINXPX64
echo *** WinXP x64 file copy

rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Winx64\NDIS5x
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Winx64\NDIS5x

REM **********************************************************************
REM  COPY Base driver files for Windows XP
REM **********************************************************************

rem 10/100 specific files to the root OEM directory and to the specific 10/1000/OS directory (needed for setupBD)
copy ..\..\..\PRO100\Winx64\NDIS5x\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\Winx64\NDIS5x

rem Gigabit specific files
copy ..\..\..\PRO1000\Winx64\NDIS5x\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Winx64\NDIS5x

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Winx64\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Winx64\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Winx64\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Winx64

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

rem *******************************************************************************
rem Copy the sample UNATTEND.TXT, Install.bat and help file
rem *******************************************************************************
copy Winx64\unattend.sif %1\$oem$\$1\drivers\net\INTEL
copy Winx64\pushx64.txt %1\$oem$\$1\drivers\net\INTEL
copy Winx64\Install.bat %1\$oem$\$1\WMIScr

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Winx64 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Winx64
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Winx64\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Winx64

REM *******************************************************************************
REM Copy the Intel I/O Acceleration Technology drivers
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\IOATDMA\Winx64 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Winx64\NDIS5x\ioatco.dll %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Winx64\NDIS5x\ioatdma.sys %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Winx64\NDIS5x\ioatdma.inf %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Winx64\NDIS5x\ioatdma.cat %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS5x

Goto end

rem *******************************************************************************
rem 	WINDOWS SERVER 2003 file copies
rem *******************************************************************************
:WS03
echo *** Windows Server 2003 file copy

rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Win32\NDIS5x
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32\NDIS5x

REM **********************************************************************
REM  COPY Base driver files for Windows Server 2003
REM **********************************************************************

rem 10/100 specific files
copy ..\..\..\PRO100\Win32\NDIS5x\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\Win32\NDIS5x

rem Gigabit specific files
copy ..\..\..\PRO1000\Win32\NDIS5x\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32\NDIS5x

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Win32

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

rem *******************************************************************************
rem Copy the sample UNATTEND.TXT, Install.bat and help file
rem *******************************************************************************
copy Win32\Unattend.txt %1\$oem$\$1\drivers\net\INTEL
copy Win32\push32.txt %1\$oem$\$1\drivers\net\INTEL
copy Win32\Install.bat %1\$oem$\$1\WMIScr

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32

REM *******************************************************************************
REM Copy the Intel I/O Acceleration Technology drivers
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\IOATDMA\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\NDIS5x\ioatco.dll %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\NDIS5x\ioatdma.sys %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\NDIS5x\ioatdma.inf %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS5x
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\NDIS5x\ioatdma.cat %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS5x

Goto end

rem *******************************************************************************
rem 	WINDOWS Vista/2K8 32 file copies
rem *******************************************************************************
:VISTA32
echo *** Windows Vista, Windows Server 2008 32 file copy
rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Win32\NDIS5x
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32\NDIS61

REM **********************************************************************
REM  COPY Base driver files for Windows Vista
REM **********************************************************************

rem 10/100 specific files
copy ..\..\..\PRO100\Win32\NDIS5x\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\Win32\NDIS5x

rem Gigabit specific files
copy ..\..\..\PRO1000\Win32\NDIS61\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32\NDIS61

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Win32

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32

REM *******************************************************************************
REM Copy the Intel I/O Acceleration Technology drivers
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\IOATDMA\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS61
copy /Y ..\..\..\PLATFORM\IOATDMA\Win32\NDIS61\*.DLL %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS61
copy /Y ..\..\..\PLATFORM\IOATDMA\Win32\NDIS61\*60*.* %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS61
copy /Y ..\..\..\PLATFORM\IOATDMA\Win32\NDIS61\qd3nodrv.* %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32\NDIS61

rem *******************************************************************************
rem Copy the sample Install.bat and help file
rem *******************************************************************************
copy Win32\Install.bat %1\$oem$\$1\WMIScr
copy Win32\push32.txt %1\$oem$\$1\drivers\net\INTEL

rem *******************************************************************************
rem Copy the Vista-specific or Windows Server 2008-specific files
rem *******************************************************************************
if /I "%2"=="WS0832" goto WS0832
goto end

:WS0832
goto end

rem *******************************************************************************
rem 	WINDOWS Vista/2K8 32e file copies
rem *******************************************************************************
:VISTAX64
echo *** Windows Vista, Windows Server 2008 32e file copy
rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Winx64\NDIS5x
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Winx64\NDIS61

REM **********************************************************************
REM  COPY Base driver files for Windows Vista
REM **********************************************************************

rem 10/100 specific files
copy ..\..\..\PRO100\Winx64\NDIS5x\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\Winx64\NDIS5x

rem Gigabit specific files
copy ..\..\..\PRO1000\Winx64\NDIS61\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Winx64\NDIS61

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Winx64\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Winx64\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Winx64\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Winx64

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Winx64 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Winx64
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Winx64\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Winx64

REM *******************************************************************************
REM Copy the Intel I/O Acceleration Technology drivers
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\IOATDMA\Winx64 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS61
copy /Y ..\..\..\PLATFORM\IOATDMA\Winx64\NDIS61\*.DLL %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS61
copy /Y ..\..\..\PLATFORM\IOATDMA\Winx64\NDIS61\*60*.* %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS61
copy /Y ..\..\..\PLATFORM\IOATDMA\Winx64\NDIS61\qd3nodrv.* %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS61

rem *******************************************************************************
rem Copy the sample Install.bat and help file
rem *******************************************************************************
copy Winx64\Install.bat %1\$oem$\$1\WMIScr
copy Winx64\puhsx64.txt %1\$oem$\$1\drivers\net\INTEL

rem *******************************************************************************
rem Copy the Vista-specific or Windows Server 2008-specific files
rem *******************************************************************************
if /I "%2"=="WS08X64" goto WS08X64
goto end

:WS08X64
goto end

rem *******************************************************************************
rem 	WINDOWS 7/2K8 R2 32 file copies
rem *******************************************************************************
:WIN732
echo *** Windows 7, Windows Server 2008 R2 32 file copy
rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32\NDIS62

REM **********************************************************************
REM  COPY Base driver files for Windows 7
REM **********************************************************************

rem Gigabit specific files
copy ..\..\..\PRO1000\Win32\NDIS62\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32\NDIS62

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Win32

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32

rem *******************************************************************************
rem Copy the sample Install.bat and help file
rem *******************************************************************************
copy Win32\Install.bat %1\$oem$\$1\WMIScr
copy Win32\push32.txt %1\$oem$\$1\drivers\net\INTEL

goto end

rem *******************************************************************************
rem 	WINDOWS 7/2K8 R2 32e file copies
rem *******************************************************************************
:WIN7X64
echo *** Windows 7, Windows Server 2008 R2 32e file copy
rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Winx64\NDIS62

REM **********************************************************************
REM  COPY Base driver files for Windows 7
REM **********************************************************************

rem Gigabit specific files
copy ..\..\..\PRO1000\Winx64\NDIS62\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Winx64\NDIS62

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Winx64\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Winx64\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Winx64\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Winx64\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Winx64

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Winx64 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Winx64
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Winx64\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Winx64

REM *******************************************************************************
REM Copy the Intel I/O Acceleration Technology drivers
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\IOATDMA\Winx64 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS62
copy /Y ..\..\..\PLATFORM\IOATDMA\Winx64\NDIS62\*.DLL %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS62
copy /Y ..\..\..\PLATFORM\IOATDMA\Winx64\NDIS62\*62*.* %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS62
copy /Y ..\..\..\PLATFORM\IOATDMA\Winx64\NDIS62\qd3nodrv.* %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64\NDIS62

rem *******************************************************************************
rem Copy the sample Install.bat and help file
rem *******************************************************************************
copy Winx64\Install.bat %1\$oem$\$1\WMIScr
copy Winx64\pushx64.txt %1\$oem$\$1\drivers\net\INTEL

rem *******************************************************************************
rem Copy the Win7-specific or Windows Server 2008 R2-specific files
rem *******************************************************************************
if /I "%2"=="WS08R2X64" goto WS08R2X64
goto end

:WS08R2X64
goto end

rem *******************************************************************************
rem 	Error Cases
rem *******************************************************************************

:WRONGDIR
echo.
echo.
echo PUSHCOPY must be run from the \APPS\SETUP\PUSH directory on the CD or 
echo CD image to work properly.  
echo.
echo  Please change directories to the \APPS\SETUP\PUSH directory before running PUSHCOPY.
echo.
echo.


:Usage
echo.
echo Invalid Command Line Argument
echo.
echo Usage Rules:
echo pushcopy [Destination Path] [OS]
echo where [destination] is the drive letter and path (such as Z:)
echo       Do not add a trailing backslash (\) to the destination path. 
echo [OS]    	= OS family
echo XP      	= Microsoft Windows XP*
echo XPX64     	= Microsoft Windows XP* X64
echo WS03    	= Microsoft Windows Server 2003*
echo VISTA32		= Microsoft Windows Vista* 32 bit
echo VISTAX64	= Microsoft Windows Vista* x64
echo WS0832		= Microsoft Windows Server 2008* 32 bit
echo WS08X64		= Microsoft Windows Server 2008* x64
echo WIN732		= Microsoft Windows 7* 32 bit
echo WIN7X64		= Microsoft Windows 7* x64
echo WS08R2X64	= Microsoft Windows Server 2008 R2* x64

echo.

:end
