@echo off

:: Copyright (c) 2011, Intel Corporation
:: All rights reserved.
::  
:: Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
:: 
::     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
::     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
::     * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
:: 
:: THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 

if not exist %~dp0settings.bat (
 echo Missing %~dp0settings.bat.
 goto end
)

call %~dp0settings.bat

:: Check for the tmp directory
SET TMP_DIR=%~dp0..\tmp\
SET MNT_DIR=%~dp0..\tmp\mount\
if not exist %MNT_DIR% (
 echo Image not mounted
 goto end
)

:: load the WinPE registry
reg load HKLM\PE-SYSTEM "%MNT_DIR%Windows\System32\config\SYSTEM"
if not %ERRORLEVEL%==0 (
 echo Unable to mount WinPE SYSTEM Reg Keys.
 goto cleanup
)

reg load HKLM\PE-SOFTWARE "%MNT_DIR%Windows\System32\config\SOFTWARE"
if not %ERRORLEVEL%==0 (
 echo Unable to mount WinPE SOFTWARE Reg Keys.
 goto cleanup
)

reg load HKLM\PE-DEFAULT "%MNT_DIR%Windows\System32\config\DEFAULT"
if not %ERRORLEVEL%==0 (
 echo Unable to mount WinPE DEFAULT Reg Keys.
 goto cleanup
)

:: Take Ownership and grant access
"%~dp0SetACL.exe" -on "HKEY_LOCAL_MACHINE\PE-SYSTEM" -ot reg -rec yes -actn setowner -ownr "n:S-1-1-0;s:y"
if not %ERRORLEVEL%==0 (
 echo Unable to take ownership of WinPE SYSTEM Reg Keys.
 goto cleanup
)

"%~dp0SetACL.exe" -on "HKEY_LOCAL_MACHINE\PE-SYSTEM" -ot reg -rec yes -actn ace -ace "n:S-1-1-0;p:full;s:y"
if not %ERRORLEVEL%==0 (
 echo Unable to grant full access to WinPE SOFTWARE Reg Keys.
 goto cleanup
)


"%~dp0SetACL.exe" -on "HKEY_LOCAL_MACHINE\PE-SOFTWARE" -ot reg -rec yes -actn setowner -ownr "n:S-1-1-0;s:y"
if not %ERRORLEVEL%==0 (
 echo Unable to take ownership of WinPE SOFTWARE Reg Keys.
 goto cleanup
)

"%~dp0SetACL.exe" -on "HKEY_LOCAL_MACHINE\PE-SOFTWARE" -ot reg -rec yes -actn ace -ace "n:S-1-1-0;p:full;s:y"
if not %ERRORLEVEL%==0 (
 echo Unable to grant full access to WinPE SOFTWARE Reg Keys.
 goto cleanup
)
goto success

:cleanup
:: If something went wrong, unload the WinPE registry
reg unload HKLM\PE-SYSTEM
reg unload HKLM\PE-SOFTWARE
reg unload HKLM\PE-DEFAULT
goto end

:success
echo Success
:end
