@echo off

:: Copyright (c) 2011, Intel Corporation
:: All rights reserved.
::  
:: Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
:: 
::     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
::     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
::     * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
:: 
:: THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

if not exist %~dp0settings.bat (
 echo Missing %~dp0settings.bat.
 goto end
)

:: Get the settings
call %~dp0settings.bat

:: Make the temp dir if needed
SET TMP_DIR=%~dp0..\tmp
if not exist %TMP_DIR% mkdir %TMP_DIR%
if not exist %TMP_DIR%\%ARCH% mkdir %TMP_DIR%\%ARCH%

:: Extract winpe.wim
set FILE=%ARCH%\winpe.wim
%~dp07z.exe e "%WAIKSUP%" %FILE% -y -o%TMP_DIR%\%ARCH%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

:: Extract bootmgr
set FILE=%ARCH%\bootmgr
%~dp07z.exe e "%WAIKSUP%" %FILE% -y -o%TMP_DIR%\%ARCH%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

:: Extract boot
set FILE=%ARCH%\boot\*
%~dp07z.exe x "%WAIKSUP%" %FILE% -y -o%TMP_DIR% 
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

:: Make and fill the sources directory
if not exist %TMP_DIR%\%ARCH%\SOURCES mkdir %TMP_DIR%\%ARCH%\SOURCES
move /y %TMP_DIR%\%ARCH%\winpe.wim %TMP_DIR%\%ARCH%\SOURCES\boot.wim
if not %ERRORLEVEL%==0 (
 echo Unable to move winpe.wim to sources directory.
 goto end
)

:: Cleanup extra junk bootfix.bin
set FILE=%TMP_DIR%\%ARCH%\boot\bootfix.bin
del /q /f %FILE% > NUL
if not %ERRORLEVEL%==0 (
 echo Unable to delete %FILE%.
 goto end
)

:: EFISYS.BIN, EFI_NOPROMPT.BIN, and ETFSBOOT.COM needed?

:: Copy menu.lst
set FILE=%~dp0pe_iso_menu.lst
copy /y %FILE% %TMP_DIR%\%ARCH%\menu.lst
if not %ERRORLEVEL%==0 (
 echo Unable to copy %FILE%.
 goto end
)

:: Copy grldr
set FILE=%~dp0grldr
copy /y %FILE% %TMP_DIR%\%ARCH%\
if not %ERRORLEVEL%==0 (
 echo Unable to copy %FILE%.
 goto end
)

:: Copy pe.tag
set FILE=%~dp0pe.tag
copy /y %FILE% %TMP_DIR%\%ARCH%\
if not %ERRORLEVEL%==0 (
 echo Unable to copy %FILE%.
 goto end
)

::Extract Drivers
mkdir %TMP_DIR%\drivers
%~dp07z.exe x "%MEIDRVARCH%" -y -o%TMP_DIR%\drivers
if not %ERRORLEVEL%==0 (
 echo Unable to extract driver archive %DRVARCH%.
 goto end
)
%~dp07z.exe x "%LANDRVARCH%" -y -o%TMP_DIR%\drivers
if not %ERRORLEVEL%==0 (
 echo Unable to extract driver archive %DRVARCH%.
 goto end
)
echo Success
:end
