@echo off
rem ### Copyright (10/21/2009) (3/20/2011) Intel Corporation All Rights Reserved.        ##
rem ###                                                                                   ##
rem ### The source code, information and material ("Material") contained herein is        ##
rem ### owned by Intel Corporation or its suppliers or licensors, and title to such       ##
rem ### Material remains with Intel Corporation or its suppliers or licensors. The        ##
rem ### Material contains proprietary information of Intel or its suppliers and           ##
rem ### licensors. The Material is protected by worldwide copyright laws and treaty       ##
rem ### provisions. No part of the Material may be used, copied, reproduced, modified,    ##
rem ### published, uploaded, posted, transmitted, distributed or disclosed in any way     ##
rem ### without Intel's prior express written permission. No license under any patent,    ##
rem ### copyright or other intellectual property rights in the Material is granted to     ##
rem ### or conferred upon you, either expressly, by implication, inducement, estoppel     ##
rem ### or otherwise. Any license under such intellectual property rights must be         ##
rem ### express and approved by Intel in writing.                                         ##

rem ### Unless otherwise agreed by Intel in writing, you may not remove or alter          ##
rem ### this notice or any other notice embedded in Materials by Intel or Intels         ##
rem ### suppliers or licensors in any way.                                               ##


:: Expert Center posts about WinRM + AMT in a batchfile
:: http://communities.intel.com/community/openportit/vproexpert/blog/2009/12/10/using-amt-remotley-from-a-command-line-with-winrm
:: http://communities.intel.com/community/openportit/vproexpert/blog/2010/05/06/winrm-command-line-for-kerberos-and-tls

:: Get the settings
call settings.bat

:: Build Local vars based on the settings
set URI=%IP%:16992/wsman
if %TLS%==1 set URI=https://%IP%:16993/wsman

set AUTH=Digest
if %KERB%==1 set AUTH=Kerberos

set CRED=-u:%USER% -p:%PASS% -a:%AUTH%
if %CURRENT%==1 set CRED=-a:%AUTH%
if %KERB%==1 set CRED=%CRED% -SPNPort

if not %DBG%==1  goto set_rfb
echo Global Vars:
echo USER = %USER%
echo PASS = %PASS%
echo KERB = %KERB%
echo TLS = %TLS%
echo CURRENT = %CURRENT%
echo IP = %IP%
echo RFBPASS = %RFBPASS%
echo ENABLEONLY = %ENABLEONLY%
eccho DBG = %DBG%
echo.
echo Local Vars:
echo URI = %URI%
echo AUTH = %AUTH%
echo CRED = %CRED%
if %DBG%==1 echo.

:set_rfb
:: Enable port5900 & RFB if requested
if %ENABLEONLY%==1 goto enable_kvm

if %DBG%==1 echo Setting RFB Password
set CMD=call winrm put http://intel.com/wbem/wscim/1/ips-schema/1/IPS_KVMRedirectionSettingData @{Is5900PortEnabled="true";RFBPassword="%RFBPASS%"} -remote:%URI% %CRED% -encoding:utf-8
if %DBG%==1 echo Command being run:
if %DBG%==1 echo %CMD%
echo.
%CMD% > tmp.log 2>&1
type tmp.log
del tmp.log
if %DBG%==1 echo.

:enable_kvm
if %DBG%==1 echo Enabling KVM feature
:: Enable KVM Feature
set CMD=call winrm invoke RequestStateChange http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_KVMRedirectionSAP @{RequestedState="2"} -remote:%URI% %CRED% -encoding:utf-8
if %DBG%==1 echo Command being run:
if %DBG%==1 echo %CMD%
echo.
%CMD% > tmp.log 2>&1
type tmp.log
del tmp.log
if %DBG%==1 echo.


