'Copyright (c) 2011, Intel Corporation
'All rights reserved.
'
'Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
'
'    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
'    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
'    * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
'
'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'
' *** Warning ***
'This example was written to be as simple as possible and is for the purpose of illustration only. 
'It has not been written for scalability or vetted for security. 
'For example, passwords are stored in clear text. 
'As such, it not recommended for use in a production environment.
'Use at your own risk. You have been warned.
' *** Warning ***

Option Explicit
'On Error Resume Next
' WSMan vars
Dim objWsman : Set objWsman = nothing
Dim objSession : Set objSession = nothing
Dim objConnectionOptions : set objConnectionOptions = nothing
Dim flgWSFlags, strWSURI

Dim colAMTData
Set colAMTData = CreateObject("Scripting.Dictionary")
Dim colNewAMTData
Set colNewAMTData = CreateObject("Scripting.Dictionary")
Dim colSettings
Set colSettings = CreateObject("Scripting.Dictionary")
colNewAMTData.Add "IP", WScript.Arguments.Item(0)
colNewAMTData.Add "ALERT_TYPE", WScript.Arguments.Item(1)
colNewAMTData.Add "UUID", WScript.Arguments.Item(2)
dim strUUIDr
dim strTMP
Dim strFile
Dim strXML
Dim File
Dim objFSO : Set objFSO = nothing
Dim objFile : Set objFile = nothing
Dim objFileProp: Set objFileProp = nothing
Dim intLogLevel
Dim intErrorCode
Dim flgLogLevel
Dim count
Dim objFileList, objFolder
dim arrKeys
dim strDate, strTime, intAge
Dim arrErrors(6)
dim strSettingsfile, arrSettingsPath

arrErrors(0) = "Success."
arrErrors(1) = "Error: Command Line parameters not specified."
arrErrors(2) = "Error: Could not save the data."
arrErrors(3) = "Error: Could not get AMT's data."
arrErrors(4) = "Error: Use or Kerberos in non-TLS mode is not supported"

' ##################################
' ### User Editable Variables    ###
' ##################################

' Use the config file. If 1, the config file over rides what is set below.
' If it's not found or is missing settings, what is below is used as a backup.
colSettings.Item("flgUseCFG") = 1

' Use sTLS or not. 0 = no TLS. Note: mTLS is not supported
colSettings.Item("flgUseTLS") = 0

' Use Kerberos or not. 0 = no Kerberos (use Digest instead). 
colSettings.Item("flgUseKerb") = 0

' User with proper AMT permissions. For Kerberos use domain\user.
colSettings.Item("strUser") = "admin"
colSettings.Item("strPass") = "P@ssw0rd"

' Path to save XML output
colSettings.Item("strDataFolder") = "C:\public\Find IP\IP\help_que\"

' Number of minutes to keep records without Ticket IDs.
colSettings.Item("intLife") = 5

' How much detail do you want on the output. Higher = more detail. 4 is max.
flgLogLevel = 4

' ##################################
' ### Verify Input Paramters     ###
' ##################################
intErrorCode = 1
' make sure it's not blank

if colNewAMTData.Item("IP") = "" then
 strTMP = Log(2,arrErrors(intErrorCode),intErrorCode)
end if

if colNewAMTData.Item("ALERT_TYPE") = "" then
 strTMP = Log(2,arrErrors(intErrorCode),intErrorCode)
end if

if colNewAMTData.Item("UUID") = "" then
 strTMP = Log(2,arrErrors(intErrorCode),intErrorCode)
end if

' ##################################
' ### Read Config File           ###
' ##################################
' only if the flag is set
if colSettings.Item("flgUseCFG") then
 strTMP = Log(4,"Using Config file.",0)
 ' Figure out the path to the settings file
 Dim objShell : set objShell = nothing
 Set objShell = WScript.CreateObject("WScript.Shell")
 arrSettingsPath = split(objShell.CurrentDirectory,"\")
 ' Up one from the current directory
 arrSettingsPath(ubound(arrSettingsPath)) = ""
 strSettingsFile = join(arrSettingsPath,"\") & "inc\config.xml"
 
 ' Make sure this file exists. Otherwise, don't bother.
 ' Initialize the File System Object
 Set objFSO = CreateObject("Scripting.FileSystemObject")
 if Not objFSO.FileExists(strSettingsFile) Then
  strTMP = Log(4,strSettingsFile & " not found.",0)
 Else
  strTMP = Log(4,"Found " & strSettingsFile & ".",0)
  strTMP = Log(4,"Reading Settings.",0)
  ' Parse it as an XMLfile
  GetXMLData(strSettingsFile)
 end if
 strTMP = Log(4,"Done with Config File." & vbCrLf,0)
  
  
end if

' ##################################
' ### End Read Config File       ###
' ##################################

' ##################################
' ### Get AMT Data               ###
' ##################################
intErrorCode = 3

''' Get the UUID '''
colNewAMTData.Item("UUID") = left(colNewAMTData.Item("UUID"),32)
colNewAMTData.Add "UUIDr", ReverseUUID(colNewAMTData.Item("UUID"))

' Get the FQDN
' First try from AMT. Note, this only works if using Digest credentials
if not colSettings.Item("flgUseKerb") = 1 then
 colNewAMTData.Item("FQDN") = Get_FQDN_By_AMT(colNewAMTData.Item("IP"))
 wscript.echo "Get_FQDN_By_AMT = " & colNewAMTData.Item("FQDN")
end if

' If it's still blank try the TLS cert. Note, this only works for systems using TLS
if colNewAMTData.Item("FQDN") = "" then
 if colSettings.Item("flgUseTLS") = 1 then
  colNewAMTData.Item("FQDN") = Get_FQDN_By_CERT(colNewAMTData.Item("IP"))
  wscript.echo "Get_FQDN_By_CERT = " & colNewAMTData.Item("FQDN")
 end if
end if

' Note, given the above two options, systems using Kerberos but no TLS have no way to get the FQDN from AMT itself using only the IP address.

' If it's still blank and we have an inventory DB option, it would go here.
'if colNewAMTData.Item("FQDN") = "" then
' colNewAMTData.Item("FQDN") = Get_FQDN_By_Inventory_DB
'end if

' If it's still blank the last chance is DNS. However, DNS may be wrong.
if colNewAMTData.Item("FQDN") = "" then
  colNewAMTData.Item("FQDN") = Get_FQDN_By_DNS(colNewAMTData.Item("IP"))
  wscript.echo "Get_FQDN_By_DNS = " & colNewAMTData.Item("FQDN")
end if

' If desired by the user, set the local hosts file - don't want a DNS issue to stop us
' Also only do it if Kerberos is used. Otherwise, we're not going to connect via FQDN, so there's no point.
if colSettings.Item("flgUpdateHosts") = 1 and colSettings.Item("flgUseKerb") = 1 and (not(colNewAMTData.Item("FQDN") = "")) then
 SetHostFile(1)
 wscript.echo "Set Hosts File"
end if

' Get key AMT hardware inventory pieces
 Dim arrTMP 
 ' If using Kerberos, let's make sure we have the FQDN and that DNS returns accurate data. If these fail, there's no point in trying to talk to AMT.
 if colSettings.Item("flgUseKerb") = 1 then
  ' do we have an FQDN
  if colNewAMTData.Item("FQDN") <> "" then
   ' does a ping return the same value?
   dim IPtmp
   IPtmp = Get_IP_By_Ping(colNewAMTData.Item("FQDN"))
   wscript.echo "Get_IP_By_Ping = " & IPtmp
   if IPtmp = colNewAMTData.Item("IP") then
    ' If all that's true, let's first ask AMT for it's FQDN to be sure we're talking to the right system
    strTMP = ""
    ' this might fail so let's try
    on error resume next
    strTMP = Get_FQDN_By_AMT(colNewAMTData.Item("FQDN"))
    on error goto 0
    if lcase(strTMP) = lcase(colNewAMTData.Item("FQDN")) then
      ' Now we can confidently get AMT Data
     arrTMP = Get_AMTDATA_By_AMT(colNewAMTData.Item("FQDN"))
    else
      ' Firmware FQDN doesn't match so we're not really sure the FQDN is right. Let's not save this info
      ' better clear this before clearing FQDN
      SetHostFile(0)
      colNewAMTData.Item("FQDN") = ""
    end if
   else
    ' Can't ping by FQDN so we're not really sure the FQDN is right. Let's not save this info
    ' better clear this before clearing FQDN
    SetHostFile(0)
    colNewAMTData.Item("FQDN") = ""
   end if   
  end if
 else
  ' This is mute for Digest. We'll just use the known good IP.
  arrTMP = Get_AMTDATA_By_AMT(colNewAMTData.Item("IP"))
 end if
 ' In case arrTMP was not populated (EG no FQDN but we're using Kerberos), this will keep the script from barfing
 On Error Resume Next
 colNewAMTData.Item("MANUFACTURER") = arrTMP(0)
 colNewAMTData.Item("MODEL") = arrTMP(1)
 colNewAMTData.Item("SERIAL_NUMBER") = arrTMP(2)
 colNewAMTData.Item("AMT_VERSION") = arrTMP(3)
 colNewAMTData.Item("AMT_CONTACTED_TIMESTAMP") = arrTMP(4)
 colNewAMTData.Item("TYPE") = arrTMP(5)
 ' Now, errors are OK (I guess)
 On Error GoTo 0
 

' read 3PDS for any special data
' TBD

' Clear the local hosts file
' Need some error handling so this is cleared if there is a crash above
if colSettings.Item("flgUpdateHosts") = 1 and colSettings.Item("flgUseKerb") = 1 then
 SetHostFile(0)
end if

' Report out what we found
strTMP = Log(3,"UUID                   : " & colNewAMTData.Item("UUID"),0)
strTMP = Log(3,"UUIDr                  : " & colNewAMTData.Item("UUIDr"),0)
strTMP = Log(3,"IP                     : " & colNewAMTData.Item("IP"),0)
strTMP = Log(3,"Alert Type             : " & colNewAMTData.Item("ALERT_TYPE"),0)
strTMP = Log(3,"FQDN                   : " & colNewAMTData.Item("FQDN"),0)
strTMP = Log(3,"MANUFACTURER           : " & colNewAMTData.Item("MANUFACTURER"),0)
strTMP = Log(3,"MODEL                  : " & colNewAMTData.Item("MODEL"),0)
strTMP = Log(3,"SERIAL_NUMBER          : " & colNewAMTData.Item("SERIAL_NUMBER"),0)
strTMP = Log(3,"AMT_VERSION            : " & colNewAMTData.Item("AMT_VERSION"),0)
strTMP = Log(3,"AMT_CONTACTED_TIMESTAMP: " & colNewAMTData.Item("AMT_CONTACTED_TIMESTAMP"),0)
strTMP = Log(3,"TYPE                   : " & colNewAMTData.Item("TYPE"),0)

'save these incase we need them later
strDate = Date
strTime = Time
colNewAMTData.Add "ALERT_TIMESTAMP", strDate & " " & strTime

' #####################################
' ### Create or Update the data file###
' #####################################
intErrorCode = 2

' Initialize the File System Object
Set objFSO = CreateObject("Scripting.FileSystemObject")
 
' Does a file exist for this UUID
Set objFolder = objFSO.GetFolder(colSettings.Item("strDataFolder"))
Set objFileList = objFolder.Files 
count = 0
For Each File In objFileList
  GetAMTData(File.Name)
  if colNewAMTData.Item("UUID") = colAMTData.Item("UUID") then
   strFile = colSettings.Item("strDataFolder") & File.Name
   Exit For
  end if
  ' If this record doesn't have a ticket ID, then it check to see if it has expired
  if colAMTData.Item("TICKET_ID") = "" then
   Set objFileProp = objFSO.GetFile(colSettings.Item("strDataFolder") & File.Name)
   intAge = DateDiff("n",objFileProp.DateLastModified,colNewAMTData.Item("ALERT_TIMESTAMP"))
   ' if it's expired, delete it
   if intAge > colSettings.Item("intLife") then
    objFSO.DeleteFile (colSettings.Item("strDataFolder") & File.Name)
   end if
  end if
  count = count + 1
next

' If no match this is the new file name
if strFile = "" then
  strFile = colSettings.Item("strDataFolder") & Year(strDate) & Month(strDate) & Day(strDate) & Hour(strTime) & Minute(strTime) & Second(strTime) & ".xml"
  colAMTData.RemoveAll
end if

' Update the data based on the received alert
arrKeys = colNewAMTData.Keys
for count = 0 to colNewAMTData.Count -1
     colAMTData.Item(arrKeys(count)) = colNewAMTData.Item(arrKeys(count)) 
next 

' Does a file exist for this AMT
if objFSO.FileExists (strFile) then
  ' Open the file
 set objFile = objFSO.OpenTextFile (strFile, 2)
else
 ' Create a new file
 set objFile = objFSO.CreateTextFile(strFile,1)
end if

' Make an XML file in Help Que
strXML = _
 "<?xml version=""1.0""?>" & vbCrLf & _
 "<AMT_DATA>" & vbCrLf & _
 ""
arrKeys = colAMTData.Keys
for count = 0 to colAMTData.Count -1
     strXML = strXML & "<" & arrKeys(count) & ">" & colAMTData.Item(arrKeys(count)) & "</" & arrKeys(count) & ">" & vbCrLf
next 
strXML = strXML & _
 "</AMT_DATA>" & vbCrLf & _
 ""

strTMP = Log(3,strXML,0)

' Save the file
Err.clear
objFile.Write (strXML)
If Err.Number <> 0 Then
 strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
end if

' ##################################
' ### Done                       ###
' ##################################
intErrorCode = 0
strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)

Function Log (intLogLevel,strOut,intErr)
 if intLogLevel <= flgLogLevel then
  WScript.Echo (strOut)
 end if
 if intErr <> 0 then
  if flgLogLevel >= 4 then
   WScript.Echo (Err.Number & ":" & Err.Source & ": " & Err.Description & ".")
  end if
  cleanup(intErr)
  WScript.Quit(intErr)
 end if
 Log = ""

End Function

Sub Cleanup(intErr)
 'Universal script cleanup on exit goes here.
 if not (objFile Is Nothing) then 
  objFile.Close
  Set objFile = nothing
 end if
 if not (objFSO Is Nothing) then
  set objFSO = nothing
 end if
end Sub

Function ReverseUUID(strUUID)
 Dim arr3(4)
  
 arr3(0) = left(strUUID,8)
 arr3(1) = mid(strUUID,(9),4)
 arr3(2) = mid(strUUID,(13),4)
 arr3(3) = mid(strUUID,(17),4)
 arr3(4) = mid(strUUID,(21),12)
 

 strTMP = ""
					
 strTMP = right(arr3(0),2)
 strTMP = strTMP & mid(arr3(0),5,2)
 strTMP = strTMP & mid(arr3(0),3,2)
 strTMP = strTMP & left(arr3(0),2)

 arr3(0) = strTMP

 strTMP = ""
					
 strTMP = right(arr3(1),2)
 strTMP = strTMP & left(arr3(1),2)

 arr3(1) = strTMP

 strTMP = ""
					
 strTMP = right(arr3(2),2)
 strTMP = strTMP & left(arr3(2),2)

 arr3(2) = strTMP

 ReverseUUID = Join(arr3,"")

end Function

Function GetAMTData(strFileName)
 
 Dim strTMP
 Dim xmlDoc, x
 colAMTData.RemoveAll
 ' Just in case there's a non-XML file in the directory
 On Error resume next
 
 Set xmlDoc=CreateObject("Microsoft.XMLDOM")
 xmlDoc.async="false"
 xmlDoc.load(colSettings.Item("strDataFolder") & strFileName)
 For Each x in xmlDoc.documentElement.childNodes
  colAMTData.Add x.nodename, x.text
 Next
 
 If Err.Number <> 0 Then
  err.clear
  if not colAMTData.Item("UUID").Exists then
   colAMTData.Item("UUID") = 0
  end if
 end if
 
 on error goto 0

End Function

Function Get_IP_By_DNS(strFQDN)
 dim objShell : Set objShell = nothing
 dim objEXE : Set objEXE = nothing
 dim objStdOut : Set objStdOut = nothing
 dim strCMD
 dim strLine, strLastLine
 dim arrLine, arrLastLine
 dim strIP

 strCMD = "nslookup " & strFQDN
 
 ' Initialize the shell to run a command
 Set objShell = CreateObject("WScript.shell") 
 
 ' Run Batch
 Set objEXE = objShell.Exec (strCMD)
 
 ' Grab the output
 Set objStdOut = objEXE.StdOut
 
 ' Loop through the output
 Do Until objStdOut.AtEndOfStream
 
  ' Write the output
  strLastLine = strLine
  strLine = objStdOut.ReadLine
   
  arrLastLine = split(strLastLine,":")
  if UBound(arrLastLine) = 1 then
   arrLastLine(1) = Trim(arrLastLine(1))
    if arrLastLine(1) = strFQDN then
    arrLine = split(strLine,":")
    if UBound(arrLine) = 1 then
     strIP = Trim(arrLine(1))
    end if
   end if
  end if

 Loop
 Get_IP_By_DNS = strIP
end Function

Function Get_IP_By_Ping(strFQDN)
 dim objShell : Set objShell = nothing
 dim objEXE : Set objEXE = nothing
 dim objStdOut : Set objStdOut = nothing
 dim strCMD
 dim strLine, strLastLine
 dim strIP

 strCMD = "ping -n 1 " & strFQDN
 
 ' Initialize the shell to run a command
 Set objShell = CreateObject("WScript.shell") 
 
 ' Run Batch
 Set objEXE = objShell.Exec (strCMD)
 
 ' Grab the output
 Set objStdOut = objEXE.StdOut
 
 ' Loop through the output
 'Do Until objStdOut.AtEndOfStream
 
  ' parse the output
  ' IP is between []
  'strLastLine = strLine
  strLine = objStdOut.ReadAll
   
  strIP = Mid(strLine,(InStr(1,strLine,"[")+1),(InStr(1,strLine,"]")-1) - (InStr(1,strLine,"[")))

 'Loop
 Get_IP_By_Ping = strIP
end Function


Function Get_FQDN_By_CERT(strIP)
 dim objShell : Set objShell = nothing
 dim objEXE : Set objEXE = nothing
 dim objStdErr : Set objStdErr = nothing
 dim objFSO : Set objFSO = nothing
 dim strCMD, strTMP
 dim intStart, intEnd
 dim strFQDN
 dim arrCMDLine, strMyPath
 
 ' Figure out the path to me
 arrCMDLine = Split(wscript.ScriptFullName,"\")
 arrCMDLine(UBound(arrCMDLine)) = ""
 strMyPath = Join(arrCMDLine,"\")
 
 dim strPathToCURL
 strPathToCURL = strMyPath & "\inc\util\curl.exe"
 
 dim strPathToRootCA
 strPathToRootCA = strMyPath & "\inc\util\cacert.cer"

 ' Use CURL to get the FQDN on the cert
 strCMD = """" & strPathToCURL & """ --cacert """ & strPathToRootCA & """" & " https://" & strIP & ":16993/logon.htm"
 
 ' Initialize the shell to run a command
 Set objShell = CreateObject("WScript.shell")
 
 ' Make sure curl and cacert.cer exist. Otherwise, this won't work.
  ' Initialize the File System Object
 Set objFSO = CreateObject("Scripting.FileSystemObject")
 if Not objFSO.FileExists(strPathToCURL) Then
  strFQDN = ""
 Else
  if Not objFSO.FileExists(strPathToRootCA) Then
   strFQDN = ""
  Else
   ' Run command
   Set objEXE = objShell.Exec (strCMD)
   
   ' We know this will fail due to a cert error.
   ' Grab the Standard Error output. It will contain the expected FQDN
   Set objStdErr = objEXE.StdErr
   
   ' Loop through the Error output since the error includes the cert subject
   Do Until objStdErr.AtEndOfStream
   
    ' Store the output
    strTMP = objStdErr.ReadLine
    ' Error 51 is the cert error we're looking for.
    if ((InStr(strTMP,"(51)")) and (InStr(strTMP,"certificate subject name"))) then
     intStart = InStr(strTMP,"'") + 1
     intEnd = InStr(intStart,strTMP,"'")
     strFQDN = mid(strTMP,intStart,intEnd - intStart)
    end if
   
   Loop
  end if
 end if
 ' Return the FQDN 
 Get_FQDN_By_CERT = strFQDN

end Function



Function Get_FQDN_By_AMT(strIP)
 'Dim objWsman : Set objWsman = nothing
 'Dim objSession : Set objSession = nothing
 Dim objLocator : Set objLocator = nothing
 Dim objResultSet : Set objResultSet = nothing
 Dim objConnectionOptions : Set objConnectionOptions = nothing
 Dim objxmlDoc : Set objxmlDoc = nothing
 Dim colAMTData : Set colAMTData = nothing
 dim flgWSFlags
 dim strResource, x, arrTMP
 dim strFQDN
 
  ' Setup WSMan
 CreateWSManSession(strIP)
 
 ' WSMan Resource
 strResource = "http://intel.com/wbem/wscim/1/amt-schema/1/AMT_GeneralSettings"
 
 ' Enumerate the resource
 set objResultSet = objSession.Enumerate(strResource)
 
 ' Deal with the XML output
 Set objxmlDoc = CreateObject("Microsoft.XMLDOM")
 objxmlDoc.async="false"
 
 ' It's easier to do this with a HASH array
 Set colAMTData = CreateObject("Scripting.Dictionary")
 
 ' Loop through the results of the wsman querry
 While Not objResultSet.AtEndOfStream
  ' clear the hash
  colAMTData.RemoveAll
  ' load the result as an XML object
  objxmlDoc.loadXML(objResultSet.ReadItem)
  ' loop through each node and assign it to the hash
  For Each x in objxmlDoc.documentElement.childNodes
   ' get rid of the : in the node name. It bugs me.
   arrTMP = split (x.nodename,":")
   ' Make sure that arrTMP(1) exists
   if Ubound(arrTMP) > 0 then
    colAMTData.Add arrTMP(1), x.text
   end if
  Next
  ' CHeck the we got a HostName and DomainName. If we did, use them to build the FQDN
  if colAMTData.Item("HostName") <> "" and colAMTData.Item("DomainName") <> "" then
   strFQDN = colAMTData.Item("HostName") & "." & colAMTData.Item("DomainName")
  end if
 Wend
 
 ' Return the FQDN 
 Get_FQDN_By_AMT = strFQDN

end Function

Function Get_FQDN_By_DNS(strIP)
 dim objShell : Set objShell = nothing
 dim objEXE : Set objEXE = nothing
 dim objStdOut : Set objStdOut = nothing
 dim strCMD
 dim strLine, strLastLine
 dim arrLine, arrLastLine
 dim strFQDN

 strCMD = "nslookup " & strIP
 
 ' Initialize the shell to run a command
 Set objShell = CreateObject("WScript.shell") 
 
 ' Run Batch
 Set objEXE = objShell.Exec (strCMD)
 
 ' Grab the output
 Set objStdOut = objEXE.StdOut
 
 ' Loop through the output
 Do Until objStdOut.AtEndOfStream
 
  ' Write the output
  strLastLine = strLine
  strLine = objStdOut.ReadLine
 
  arrLine = split(strLine,":")
  if UBound(arrLine) = 1 then
   arrLine(1) = Trim(arrLine(1))
   if arrLine(1) = strIP then
    arrLastLine = split(strLastLine,":")
    if UBound(arrLastLine) = 1 then
     strFQDN = Trim(arrLastLine(1))
    end if
   end if
  end if

 Loop
 Get_FQDN_By_DNS = strFQDN
end Function



Function GET_AMTDATA_BY_AMT(strFQDN)
 Dim objLocator : Set objLocator = nothing
 Dim objResultSet : Set objResultSet = nothing
 Dim objConnectionOptions : Set objConnectionOptions = nothing
 Dim objxmlDoc : Set objxmlDoc = nothing
 Dim colAMTData : Set colAMTData = nothing
 Dim colTMPData : Set colTMPData = nothing
 dim flgWSFlags
 dim strResource, x, arrTMP, strResult, c
 dim arrResource(3)
 dim arrAMTDATA(6)
 dim arrType(33)
 arrType(32) = "Desktop"
 arrType(33) = "Laptop"
 
 ' Setup WSMan
 CreateWSManSession(strFQDN)

 ' AMT Data Storage
 Set colAMTData = CreateObject("Scripting.Dictionary")
 
 ' WSMan Resources
 arrResource(0) = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_Chassis"
 arrResource(1) = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_Card"
 arrResource(2) = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ComputerSystem"
 c = 0
 while (c < ubound(arrResource))
  strResource = arrResource(c)
  
  ' Enumerate the resource
  set objResultSet = objSession.Enumerate(strResource)
  
  ' Deal with the XML output
  Set objxmlDoc = CreateObject("Microsoft.XMLDOM") 
  objxmlDoc.async="false"
 
  ' It's easier to do this with a HASH array
  Set colTMPData = CreateObject("Scripting.Dictionary")
  
  ' Loop through the results of the wsman querry
  While Not objResultSet.AtEndOfStream
   ' clear the hash, note we only get the last record
   colTMPData.RemoveAll
  
   ' load the result as an XML object
   strResult = objResultSet.ReadItem
   'wscript.echo strResult
   objxmlDoc.loadXML(strResult)
   ' loop through each node and assign it to the hash
  
   For Each x in objxmlDoc.documentElement.childNodes
    ' get rid of the : in the node name. It bugs me.
    arrTMP = split (x.nodename,":")
    ' Make sure that arrTMP(1) exists
    if Ubound(arrTMP) > 0 then
     colTMPData.Item(arrTMP(1)) = x.text
    end if
   Next
   if colTMPData.item("Manufacturer") <> "" and not colAMTData.exists("Manufacturer") then
    colAMTData.Add "Manufacturer", colTMPData.Item("Manufacturer")
   end if
   if colTMPData.item("Model") <> "" and not colAMTData.exists("Model") then
    colAMTData.Add "Model", colTMPData.Item("Model")
   end if
   if colTMPData.item("SerialNumber") <> "" and not colAMTData.exists("SerialNumber") then
    colAMTData.Add "SerialNumber", colTMPData.Item("SerialNumber")
   end if
   if colTMPData.item("Dedicated") <> "" and not colAMTData.exists("Type") and colTMPData.item("Name") = "ManagedSystem" then
    colAMTData.Add "Type", colTMPData.Item("Dedicated")
   end if
  Wend
  c = c + 1
 Wend
 
 ' Get the AMT Version
 arrResource(0) = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_SoftwareIdentity"
 Set objLocator = objWSMan.CreateResourceLocator(arrResource(0))
 objLocator.AddSelector "InstanceID", "AMT FW Core Version"
 strResult = objSession.Get(objLocator)
    objxmlDoc.loadXML(strResult)
   ' loop through each node and assign it to the hash
  
   For Each x in objxmlDoc.documentElement.childNodes
    ' get rid of the : in the node name. It bugs me.
    arrTMP = split (x.nodename,":")
    ' Make sure that arrTMP(1) exists
    if Ubound(arrTMP) > 0 then
     if arrTMP(1) = "VersionString" then
      colAMTData.Item("AMT_VERSION") = x.text
     end if
    end if
   Next
 
 arrAMTDATA(0) = colAMTData.Item("Manufacturer")
 arrAMTDATA(1) = colAMTData.Item("Model")
 arrAMTDATA(2) = colAMTData.Item("SerialNumber")
 arrAMTDATA(3) = colAMTData.Item("AMT_VERSION")
 arrAMTDATA(4) = Date & " " & Time
 arrAMTDATA(5) = arrType(colAMTData.Item("Type"))
 
 ' Return AMT Data
 GET_AMTDATA_BY_AMT = arrAMTDATA

end Function

sub CreateWSManSession(strFQDN)
 ' Check to see if it's already open
 if objSession is nothing then
  intErrorCode = 5
  strTMP = Log(2,"Connecting to AMT.",0)
  strTMP = Log(3,"Create WinRM Object.",0)
  Err.Clear
  Set objWsman = CreateObject("WSMan.Automation")
  If Err.Number <> 0 Then
   strTMP = Log(1,"Error: Unable to use WinRM. Is it installed and Configured?",intErrorCode)
  End If
  Err.Clear
  Set objConnectionOptions = objWsman.CreateConnectionOptions
  If Err.Number <> 0 Then
   strTMP = Log(1,"Error: Unable to set WinRM username and password connection options.",intErrorCode)
  End If
  objConnectionOptions.Username = colSettings.Item("strUser")
  objConnectionOptions.Password = colSettings.Item("strPass")
  flgWSFlags = objWSMan.SessionFlagUTF8 Or objWSMan.SessionFlagCredUserNamePassword
 
  ' Set the WSMan URI based on the TLS flag.
  if colSettings.Item("flgUseTLS") <> 0 then
   strWSURI = "https://" & strFQDN & ":16993/wsman"
   ' Also, ignore the CN matching and cert validation. We're going for success over security for now.
   flgWSFlags = flgWSFlags Or objWSMan.SessionFlagSkipCACheck Or objWSMan.SessionFlagSkipCNCheck
  else
   strWSURI = "http://" & strFQDN & ":16992/wsman"
  end if
 
  ' Set the WSMan flags for Keberos or Digest
  if colSettings.Item("flgUseKerb") <> 0 then
   flgWSFlags = flgWSFlags Or objWsman.SessionFlagUseKerberos Or objWSMAn.SessionFlagEnableSPNServerPort
  else
   flgWSFlags = flgWSFlags Or objWsman.SessionFlagUseDigest
  end if

 strTMP = Log(3,"WinRM Object Created.",0)

 ' Setup WSMan Session
 strTMP = Log(3,"Create WSMan Session.",0)
 Err.Clear
 Set objSession = objWsman.CreateSession(strWSURI, flgWSFlags, objConnectionOptions)
 If Err.Number <> 0 Then
  strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
 End If
  strTMP = Log(3,"WSMan Session Created.",0)
  
 else
  strTMP = Log(3,"WSMan Session Already Created, Skipping.",0)
 end if 
end sub

sub SetHostFile(flgAdd)
 dim strHost
 dim arrHostLine, arrComment, arrHostEntry
 dim count, count1
 
 Dim objFSO, objFileIn, objFileOut, objFileLock
 Dim strHostFile
 
 ' Path to the hosts file
 strHostFile = "C:\Windows\System32\drivers\etc\hosts"
 
 ' Initialize the File System Object
 Set objFSO = CreateObject("Scripting.FileSystemObject")

' Does this file exist
' Open the file
 on error resume next
 for count = 1 to 5
  set objFileLock = objFSO.OpenTextFile (strHostFile, 8, true)
  If Err.Number = 70 Then 
   wscript.sleep 500
  elseif Err.Number <> 0 then
   count = 5
  else
   count = 5
  end if
  err.clear
 next
 on error goto 0
 if not objFileLock is nothing then
  ' We keep it open so no one else can modify until we are done.
 
  ' Read it do we can process what's there
  set objFileIn = objFSO.OpenTextFile (strHostFile, 1)
  ' Set a default value incase the file is blank
   strHost = "# Set by Service Desk tool" & vbCrLf
  ' Read the file
  ' just in case the file is empty
  on error resume next
  strHost = objFileIn.ReadAll
  on error goto 0
  objFileIn.Close
  set objFileIn = nothing
   
  arrHostLine = split(strHost,vbCrLf)
  strHost = ""
  for count = 0 to ubound(arrHostLIne) -1
   ' add vbCrLf back in here so we can fully remove a line.
   arrHostLine(count) = arrHostLine(count) & vbCrLf
   ' look for lines we added
   arrComment = split(arrHostLine(count),"#")
   if ubound(arrComment) > 0 then
    ' Ours say #added by Service Desk
    if arrComment(1) = "added by Service Desk" &vbCrLf then
     arrHostEntry = split(arrComment(0),vbTab) 
     if ubound(arrHostEntry) > 1 then
      if lcase(arrHostEntry(1)) = lcase(colAMTData.Item("FQDN")) then
       ' found it. Now, let's delete it.
       ' Later we'll add it again if needed
       arrHostLine(count) = ""
      end if
     end if
    end if
   end if
  Next
  strHost = join(arrHostLine, "")
  ' add new host entry if needed
  if flgAdd = 1 then
   strHost = strHost & colNewAMTData.Item("IP") & vbTab & colNewAMTData.Item("FQDN") & vbTab & "#added by Service Desk" & vbCrLf
  end if
  
  ' write out the hosts file
    ' Save the file
  objFileLock.Close
  set objFileOut = objFSO.OpenTextFile (strHostFile, 2, true)
  objFileOut.Write (strHost)
  
  objFileOut.Close
  Set objFileOut = Nothing
  Set objFileLock = nothing
 end if
 Set objFSO = nothing

end sub

Function GetXMLData(strFileName)
 Dim strTMP
 Dim xmlDoc, x
 
 Set xmlDoc=CreateObject("Microsoft.XMLDOM")
 xmlDoc.async="false"
 xmlDoc.load(strFileName)
 For Each x in xmlDoc.documentElement.childNodes
  colSettings.Item(x.nodename) = x.text
 Next

End Function