'Copyright (c) 2011, Intel Corporation
'All rights reserved.
'
'Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
'
'    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
'    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
'    * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
'
'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'
' *** Warning ***
'This example was written to be as simple as possible and is for the purpose of illustration only. 
'It has not been written for scalability or vetted for security. 
'For example, passwords are stored in clear text. 
'As such, it not recommended for use in a production environment.
'Use at your own risk. You have been warned.
' *** Warning ***

'Option Explicit
'On Error Resume Next

Dim colSettings
Set colSettings = CreateObject("Scripting.Dictionary")
Dim objWsman : Set objWsman = nothing
Dim objSession : Set objSession = nothing
Dim objLocator : Set objLocator = nothing
Dim objResultSet : Set objResultSet = nothing
Dim objConnectionOptions : set objConnectionOptions = nothing
Dim objFSO : Set objFSO = nothing
Dim strSettingsFile, arrSettingsFile
Dim arrErrors(7)
Dim flgWSFlags
Dim strFQDN
Dim strResource
Dim strError
Dim strInput
Dim strResult
Dim strUserInt
Dim flgLogLevel
Dim strSNMPCommunity
Dim strInstanceID
Dim strTMP, strTMP1, strTMP2, intCount
Dim strWSURI
Dim flgDelMe
Dim intErrorCode
reDim arrDelMe(0)

arrErrors(0) = "Success."
arrErrors(1) = "Error: Can't connect to AMT."
arrErrors(2) = "Error: This AMT doesn't support FCFH."
arrErrors(3) = "Error: Failed setting Event Filter."
arrErrors(4) = "Error: Failed subscribing to event."
arrErrors(5) = "Error: Failed Setting FCFH Flags."
arrErrors(6) = "Error: FQDN, Username, and/or Password Not Specified."
arrErrors(7) = "Error: Failed creating digest user FCFH."

' ##################################
' ### Start User Editable Fields ###
' ##################################

' Use the config file. If 1, the config file over rides what is set below.
' If it's not found or is missing settings, what is below is used as a backup.
colSettings.Item("flgUseCFG") = 1

' Use sTLS or not. 0 = no TLS. Note: mTLS is not supported
colSettings.Item("flgUseTLS") = 0

' Use Kerberos or not. 0 = no Kerberos (use Digest instead). 
'colSettings.Item("flgUseKerb") = 0

' Digest User with proper FCFH permissions in AMT.
'colSettings.Item("strUser") = "FCFH"
'colSettings.Item("strPass") = "P@ssw0rd"

' user with AMT admin permissions. For Kerberos use domain\user.
'strUser = "admin"
'strPass = "P@ssw0rd

' IP address of SNMP Trap Listener
colSettings.Item("strListenerIP") = "192.168.0.2"

' What User Initiated Interface do you want?
'32768 Disable the BIOS and the Operating System interfaces
'32769 Enable the BIOS interface only
'32770 Enable the Operating System Interface only
'32771 Enable the BIOS and the Operating System interfaces
strUserInt = 32771

' Set the verbosity of script output
flgLogLevel = 4

' SNMP Community String on which to send SNMP Traps
strSNMPCommunity = "vpro"

' ##################################
' ### End User Editable Fields   ###
' ##################################

' ##################################
' ### Verify Input Paramters     ###
' ##################################
intErrorCode = 6
strTMP = Log(2,"Checking Input Parameters",0)

if WScript.Arguments.count > 0 then
 strFQDN = WScript.Arguments.Item(0)
end if
if WScript.Arguments.count > 1 then
 strUser = WScript.Arguments.Item(1)
end if
if WScript.Arguments.count > 2 then
 strPass = WScript.Arguments.Item(2)
end if

' make sure FQDN is not blank
if strFQDN = "" then
 strTMP = Log(3,"Expects 3 input parameters; IP || FQDN, admin username, admin password",0)
 strTMP = Log(3,"FQDN Blank.",0)
 strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
else
 strTMP = Log(2,"FQDN = " & strFQDN,0)
end if

' make sure user is not blank
if strUser = "" then
 strTMP = Log(3,"Expects 3 input parameters; IP || FQDN, admin username, admin password",0)
 strTMP = Log(3,"Username Blank.",0)
 strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
else
 'strTMP = Log(2,"Username = " & strUser,0)
end if

' make sure pass is not blank
if strPass = "" then
 strTMP = Log(3,"Expects 3 input parameters; IP || FQDN, admin username, admin password",0)
 strTMP = Log(3,"Password Blank.",0)
 strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
else
 'strTMP = Log(2,"Password = " & strPass,0)
end if

' Decide if this is a Kerberos user.
' Assume user name with a \ is kerberos
if instr(strUser,"\") = 0 then
 flgUseKerb = 0
else
 flgUseKerb = 1
end if


strTMP = Log(2,"Done checking Input Parameters" & vbCrLf,0)

' ##################################
' ### End Verify Input Paramters ###
' ##################################

' ##################################
' ### Read Config File           ###
' ##################################
' only if the flag is set
if colSettings.Item("flgUseCFG") then
 strTMP = Log(4,"Using Config file.",0)
 ' Figure out the path to the settings file
 Dim objShell : set objShell = nothing
 Set objShell = WScript.CreateObject("WScript.Shell")
 arrSettingsPath = split(objShell.CurrentDirectory,"\")
 ' Up one from the current directory
 arrSettingsPath(ubound(arrSettingsPath)) = ""
 strSettingsFile = join(arrSettingsPath,"\") & "inc\config.xml"
 
 ' Make sure this file exists. Otherwise, don't bother.
 ' Initialize the File System Object
 Set objFSO = CreateObject("Scripting.FileSystemObject")
 if Not objFSO.FileExists(strSettingsFile) Then
  strTMP = Log(4,strSettingsFile & " not found.",0)
 Else
  strTMP = Log(4,"Found " & strSettingsFile & ".",0)
  strTMP = Log(4,"Reading Settings.",0)
  ' Parse it as an XMLfile
  GetXMLData(strSettingsFile)
 end if
 strTMP = Log(4,"Done with Config File." & vbCrLf,0)
  
  
end if

' ##################################
' ### End Read Config File       ###
' ##################################

' ##################################
' ### Connect and verify AMT     ###
' ##################################
intErrorCode = 1
strTMP = Log(2,"Connecting to AMT.",0)

' Setup WSMan
strTMP = Log(3,"Create WinRM Object.",0)
Err.Clear
Set objWsman = CreateObject("WSMan.Automation")
If Err.Number <> 0 Then
 strTMP = Log(1,"Error: Unable to use WinRM. Is it installed and Configured?",intErrorCode)
End If
Err.Clear
Set objConnectionOptions = objWsman.CreateConnectionOptions
If Err.Number <> 0 Then
 strTMP = Log(1,"Error: Unable to set WinRM username and password connection options.",intErrorCode)
End If
objConnectionOptions.Username = strUser
objConnectionOptions.Password = strPass
flgWSFlags = objWSMan.SessionFlagUTF8 Or objWSMan.SessionFlagCredUserNamePassword

' Set the WSMan URI based on the TLS flag.
if colSettings.Item("flgUseTLS") <> 0 then
 strWSURI = "https://" & strFQDN & ":16993/wsman"
 ' Also, ignore the CN matching and cert validation. We're going for success over security for now.
 flgWSFlags = flgWSFlags Or objWSMan.SessionFlagSkipCACheck Or objWSMan.SessionFlagSkipCNCheck
else
 strWSURI = "http://" & strFQDN & ":16992/wsman"
end if

' Set the WSMan flags for Keberos or Digest
if flgUseKerb <> 0 then
 flgWSFlags = flgWSFlags Or objWsman.SessionFlagUseKerberos Or objWSMAn.SessionFlagEnableSPNServerPort
else
 flgWSFlags = flgWSFlags Or objWsman.SessionFlagUseDigest
end if

strTMP = Log(3,"WinRM Object Created.",0)

' Setup WSMan Session
strTMP = Log(3,"Create WSMan Session.",0)
Err.Clear
Set objSession = objWsman.CreateSession(strWSURI, flgWSFlags, objConnectionOptions)
If Err.Number <> 0 Then
 strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
End If
strTMP = Log(3,"WSMan Session Created.",0)

' Get AMT General Info to prove we can connect and that this is AMT
strTMP = Log(3,"Create Resource Locator to AMT Firmware version.",0)
strResource = MakeURI("CIM_SoftwareIdentity")
Err.Clear
Set objLocator = objWSMan.CreateResourceLocator(strResource)
objLocator.AddSelector "InstanceID", "AMT FW Core Version"
If Err.Number <> 0 Then
 strTMP = Log(1,arrErrors(intErrorCode),0)
 strTMP = Log(3,"Error: Failed to setup a locator to " & strResource & " InstanceID = AMT FW Core Version.",intErrorCode)
End If
strTMP = Log(3,"Resource Locator Created.",0)

strTMP = Log(3,"Conenct and read the resource.",0)
Err.Clear
strError = ""
strResult = objSession.Get(objLocator)
strError = objSession.Error
' Make sure we can talk to AMT.
If not strError = "" then
 strTMP = Log(1,arrErrors(intErrorCode),0)
 strTMP = Log(3,"Error: " & strError & ".",intErrorCode)
end if
If Err.Number <> 0 Then
 strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
end if
strTMP = Log(3,DisplayOutput(strResult),0)
' Figure out AMT version so we can make decisions based on version differences
dim strFWVer
strFWVer = Mid(strResult,(InStr(1,strResult,"VersionString")+14),((InStr((InStr(1,strResult,"VersionString")+14),strResult,"VersionString")-4))-(InStr(1,strResult,"VersionString")+14))
strTMP = Log(3,"Calculated Firmware Version = " & strFWVer,0)
strTMP = Log(3,("Resource Read."),0)

strTMP = Log(2,("Connected to AMT." & vbCrLf),0)

' ##################################
' ### End Connect and verify AMT ###
' ##################################

' ##################################
' ### Check AMT for FCFH Support ###
' ##################################

intErrorCode = 2
strTMP = Log(2,"Check that AMT Supports Fast Call for Help.",0)

strResource = MakeURI("AMT_UserInitiatedConnectionService")
Err.Clear
strError = ""
Set objResultSet = objSession.Enumerate(strResource)
strError = objSession.Error
If not strError = "" then
 strTMP = Log(1,arrErrors(intErrorCode),0)
 strTMP = Log(3,"Error: " & strError & ".",intErrorCode)
end if
If Err.Number <> 0 Then
 strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
end if

While Not objResultSet.AtEndOfStream
    strTMP = Log(3,DisplayOutput(objResultSet.ReadItem),0)
Wend

strTMP = Log(2,"AMT Supports Fast Call for Help." & vbCRLF,0)
' ##################################
' ### End Check AMT for FCFH     ###
' ##################################

' ##################################
' ### Create Digest User FCFH    ###
' ##################################
'
' Rather than using Admin credentials in the alert collector, 
' the user FCFH is used. FCFH only has General Info and 
' Asset realms. This way, if the password is comprimised, 
' the only threat is that someone has access to information in AMT.
'
' This is done in C# with the HLAPI. This is because, creating a 
' digest user requires performing MD5 on the new password. 
' vbscript does not include a method for MD5. However, methods
' could be added, in which case, vbscript is capable of creating
' the user account.
'
intErrorCode = 7
strTMP = Log(2,"Create FCFH user.",0)

' path to .exe that creates the user.
strRunscript = left(wscript.ScriptFullName,(len(wscript.ScriptFullname) - len(wscript.ScriptName))) & "util\Make_FCFH_User.exe"

' Don't run if the file is missing
if objFSO.FileExists (strRunScript) Then

 ' The actual command line.
 strCMD = "cmd /c """ & strRunScript & " " & strFQDN & " " & strUser & " " & strPass & " " & colSettings.Item("strPass") & " " & colSettings.Item("flgUseTLS")
 ' Run CMD
 strTMP = Log(3,strRunScript & " running to create the FCFH user.",0)
 strResult = objShell.Run(strCMD, 0, true)
 if strResult <> 0 then
   ' If it's missing, error
  strTMP = Log(1,arrErrors(intErrorCode),0)
  strTMP = Log(3,strRunScript & " returned error code " & strResult & ".",intErrorCode)
 else
  ' add captured output from .exe
  strTMP = Log(3,(strRunScript & " completed successfully."),0)
 end if
 else
 ' If it's missing, error
  strTMP = Log(1,arrErrors(intErrorCode),0)
  strTMP = Log(3,"File " & strRunScript & " is missing.",intErrorCode)
end If

strTMP = Log(2,"FCFH User Created." & vbCrLf,0)
' ##################################
' ### FCFH Flags Set             ###
' ##################################

' ##################################
' ### Set Event Filter           ###
' ##################################
intErrorCode = 3
strTMP = Log(2,"Set Event Filter.",0)
' URI
strResource = MakeURI("AMT_PETFilterSetting")

' Delete all Default Filters and my filter if they exist. Use PolicyID to identify them. BKM - never use Policy ID 0 - 15.
Err.Clear
strError = ""
Set objResultSet = objSession.Enumerate(strResource)
strError = objSession.Error
If not strError = "" or Err.Number <> 0 then
 strTMP = Log(3,"Session: " & strError & ".",0)
end if

While Not objResultSet.AtEndOfStream
 strTMP1 = DisplayOutput(objResultSet.ReadItem)
 strTMP = Log(3,strTMP1,0)
 strTMP = split(strTMP1,vbCrLf)
 flgDelMe = 0
 for each strTMP1 in strTMP
  strTMP2 = split(trim(strTMP1)," = ")
  if ubound(strTMP2) = 1 then
   if strTMP2(0) = "PolicyID" and (strTMP2(1) = "0" or strTMP2(1) = "2" or strTMP2(1) = "3" or strTMP2(1) = "4" or strTMP2(1) = "5" or strTMP2(1) = "6" or strTMP2(1) = "7" or strTMP2(1) = "8" or strTMP2(1) = "9" or strTMP2(1) = "10" or strTMP2(1) = "0" or strTMP2(1) = "11" or strTMP2(1) = "12" or strTMP2(1) = "13" or strTMP2(1) = "14" or strTMP2(1) = "15" or strTMP2(1) = "1" or strTMP2(1) = "101") then
    flgDelMe = 1
   end if
   if strTMP2(0) = "InstanceID" then
    strInstanceID = strTMP2(1)
   end if
  end if
 next
 if flgDelMe <> 0 then
  arrDelMe(ubound(arrDelMe)) = strInstanceID
  redim preserve arrDelMe(ubound(arrDelMe) + 1)
 end if
Wend

intCount = 0
while intCount <= (ubound(arrDelMe) -1)

 strTMP = Log(3,"Create Resource Locator to " & arrDelMe(intCount),0)
 Err.Clear
 Set objLocator = objWSMan.CreateResourceLocator(strResource)
 objLocator.AddSelector "InstanceID", arrDelMe(intCount)
 If Err.Number <> 0 Then
  strTMP = Log(3,"Error: Failed to setup a locator.",0)
 End If
 strTMP = Log(3,"Resource Locator Created.",0)

 strTMP = Log(3,"Conenct and delete the resource.",0)
 Err.Clear
 strError = ""
 strResult = objSession.Delete(objLocator)
 strError = objSession.Error
 If not strError = "" then
  strTMP = Log(3,"Error: " & strError & ".",0)
 end if
 If Err.Number <> 0 Then
 end if
 strTMP = Log(3,DisplayOutput(strResult),0)
 strTMP = Log(3,("Resource Deleted."),0)

 intCount = intCount + 1
Wend

strTMP = Log(3,"Create the resource.",0)
' Define Filter Input
strInput = _
"<f:AMT_PETFilterSetting xmlns:f=""" & strResource & """>" &_
"<f:DeviceAddress>255</f:DeviceAddress>" &_
"<f:ElementName>Intel(r) AMT PET Filter</f:ElementName>" &_
"<f:EnableFilter>true</f:EnableFilter>" &_
"<f:Entity>38</f:Entity>" &_
"<f:EntityInstance>0</f:EntityInstance>" &_
"<f:EventOffset>0</f:EventOffset>" &_
"<f:EventSensorType>193</f:EventSensorType>" &_
"<f:EventSeverity>2</f:EventSeverity>" &_
"<f:EventSourceType>88</f:EventSourceType>" &_
"<f:EventType>113</f:EventType>" &_
"<f:InstanceID>foo</f:InstanceID>" &_
"<f:LogOnEvent>true</f:LogOnEvent>" &_
"<f:OEMFilter>false</f:OEMFilter>" &_
"<f:PolicyID>101</f:PolicyID>" &_
"<f:SendAlert>true</f:SendAlert>" &_
"<f:SensorNumber>255</f:SensorNumber>" &_
"</f:AMT_PETFilterSetting>"
Err.Clear
strError = ""
strResult = objSession.Create(strResource,strInput)
strError = objSession.Error
If not strError = "" then
 strTMP = Log(1,arrErrors(intErrorCode),0)
 strTMP = Log(3,"Error: " & strError & ".",intErrorCode)
 flgPut = 0
end if
If Err.Number <> 0 Then
 strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
end if
strTMP = Log(3,DisplayOutput(strResult),0)
strTMP = Log(3,("Resource Created."),0)

strTMP = Log(3,"Create the ALL resource for the event log.",0)
' Define Filter Input
strInput = _
"<f:AMT_PETFilterSetting xmlns:f=""" & strResource & """>" &_
"<f:DeviceAddress>255</f:DeviceAddress>" &_
"<f:ElementName>Intel(r) AMT PET Filter</f:ElementName>" &_
"<f:EnableFilter>true</f:EnableFilter>" &_
"<f:Entity>0</f:Entity>" &_
"<f:EntityInstance>0</f:EntityInstance>" &_
"<f:EventOffset>15</f:EventOffset>" &_
"<f:EventSensorType>255</f:EventSensorType>" &_
"<f:EventSeverity>0</f:EventSeverity>" &_
"<f:EventSourceType>255</f:EventSourceType>" &_
"<f:EventType>255</f:EventType>" &_
"<f:InstanceID>foo</f:InstanceID>" &_
"<f:LogOnEvent>true</f:LogOnEvent>" &_
"<f:OEMFilter>false</f:OEMFilter>" &_
"<f:PolicyID>0</f:PolicyID>" &_
"<f:SendAlert>true</f:SendAlert>" &_
"<f:SensorNumber>255</f:SensorNumber>" &_
"</f:AMT_PETFilterSetting>"
Err.Clear
strError = ""
strResult = objSession.Create(strResource,strInput)
strError = objSession.Error
If not strError = "" then
 strTMP = Log(1,arrErrors(intErrorCode),0)
 strTMP = Log(3,"Error: " & strError & ".",intErrorCode)
 flgPut = 0
end if
If Err.Number <> 0 Then
 strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
end if
strTMP = Log(3,DisplayOutput(strResult),0)
strTMP = Log(3,("Resource Created."),0)

strTMP = Log(2,"Event Filter Set." & vbCrLf,0)
' ##################################
' ### Event Filter Set           ###
' ##################################

' ##################################
' ### Subscribe to Event         ###
' ##################################

intErrorCode = 4
strTMP = Log(2,"Subscribe to Event.",0)

' URI
strResource = MakeURI("AMT_SNMPEventSubscriber")

reDim arrDelMe(0)

' Delete my filter if it exists. Use PolicyID to identify them. Mine is 101.
Err.Clear
strError = ""
' If the system has never had a filter this object won't exist yet and the call will fail
' So, we'll just keep running. It's a little like try catch
On Error Resume Next
Set objResultSet = objSession.Enumerate(strResource)
strError = objSession.Error
If not strError = "" or Err.Number <> 0 then
 strTMP = Log(3,"Session: " & strError & ".",0)
end if
On Error Goto 0

While Not objResultSet.AtEndOfStream
 strTMP1 = DisplayOutput(objResultSet.ReadItem)
 strTMP = Log(3,strTMP1,0)
 strTMP = split(strTMP1,vbCrLf)
 flgDelMe = 0
 for each strTMP1 in strTMP
  strTMP2 = split(trim(strTMP1)," = ")
  if ubound(strTMP2) = 1 then
   if strTMP2(0) = "PolicyID" and (strTMP2(1) = "101") then
    flgDelMe = 1
   end if
   if strTMP2(0) = "Name" then
    strInstanceID = strTMP2(1)
   end if
  end if
 next
 if flgDelMe <> 0 then
  arrDelMe(ubound(arrDelMe)) = strInstanceID
  redim preserve arrDelMe(ubound(arrDelMe) + 1)
 end if
Wend

intCount = 0
while intCount <= (ubound(arrDelMe) -1)

 strTMP = Log(3,"Create Resource Locator to " & arrDelMe(intCount),0)
 Err.Clear
 Set objLocator = objWSMan.CreateResourceLocator(strResource)
 objLocator.AddSelector "Name", arrDelMe(intCount)
 If Err.Number <> 0 Then
  strTMP = Log(3,"Error: Failed to setup a locator.",0)
 End If
 strTMP = Log(3,"Resource Locator Created.",0)

 strTMP = Log(3,"Conenct and delete the resource.",0)
 Err.Clear
 strError = ""
 strResult = objSession.Delete(objLocator)
 strError = objSession.Error
 If not strError = "" then
  strTMP = Log(3,"Error: " & strError & ".",0)
 end if
 If Err.Number <> 0 Then
 end if
 strTMP = Log(3,DisplayOutput(strResult),0)
 strTMP = Log(3,("Resource Deleted."),0)

 intCount = intCount + 1
Wend
strTMP = Log(3,"Create the resource.",0)
strInput = _
"<f:AMT_SNMPEventSubscriber xmlns:f=""" & strResource & """>" &_
"<f:SystemCreationClassName>foo</f:SystemCreationClassName>" &_
"<f:SystemName>foo</f:SystemName>" &_
"<f:CreationClassName>foo</f:CreationClassName>" &_
"<f:Name>foo</f:Name>" &_
"<f:AccessInfo>" & colSettings.Item("strListenerIP") & "</f:AccessInfo>" &_
"<f:PolicyID>101</f:PolicyID>" &_
"<f:CommunityString>" & strSNMPCommunity & "</f:CommunityString>" &_
"</f:AMT_SNMPEventSubscriber>" 
Err.Clear
strError = ""
strResult = objSession.Create(strResource,strInput)
strError = objSession.Error
If not strError = "" then
 strTMP = Log(1,arrErrors(intErrorCode),0)
 strTMP = Log(3,"Error: " & strError & ".",intErrorCode)
 flgPut = 0
end if
If Err.Number <> 0 Then
 strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
end if
strTMP = Log(3,DisplayOutput(strResult),0)
strTMP = Log(3,("Resource Created."),0)

strTMP = Log(2,"Event Subscribed." & vbCrLf,0)
' ##################################
' ### Event Subscribed           ###
' ##################################

' ##################################
' ### Set FCFH Flags             ###
' ##################################
intErrorCode = 5
strTMP = Log(2,"Set FCFH Flags.",0)

' URI
strResource = MakeURI("AMT_UserInitiatedConnectionService")

strInput = _
"<f:RequestStateChange_INPUT xmlns:f=""" & strResource & """>" &_
"<f:RequestedState>" & strUserInt & "</f:RequestedState>" &_
 "</f:RequestStateChange_INPUT>" 
strTMP = Log(3,("Setting FCFH Flags."),0)
strError = ""
Err.clear
strResult = objSession.Invoke("RequestStateChange", strResource, strInput)
If not strError = "" then
 strTMP = Log(1,arrErrors(intErrorCode),0)
 strTMP = Log(3,"Error: " & strError & ".",intErrorCode)
 flgPut = 0
end if
If Err.Number <> 0 Then
 strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)
end if
strTMP = Log(3,DisplayOutput(strResult),0)
strTMP = Log(3,("Flags set."),0)


strTMP = Log(2,"FCFH Flags Set." & vbCrLf,0)
' ##################################
' ### FCFH Flags Set             ###
' ##################################

' ##################################
' ### Done                       ###
' ##################################
intErrorCode = 0
strTMP = Log(1,arrErrors(intErrorCode),intErrorCode)

' ##################################
' ### Functions & Subs           ###
' ##################################

Function DisplayOutput(strWinRMXml)
 Dim xmlFile : set xmlFile = nothing
 Dim xslFile : set xslFile = nothing

 Set xmlFile = CreateObject("MSXml.DOMDocument")	
 Set xslFile = CreateObject("MSXml.DOMDocument")
 xmlFile.LoadXml(strWinRMXml)
 xslFile.Load("WsmTxt.xsl")
 DisplayOutput = xmlFile.TransformNode(xslFile)	
End Function	


Function MakeURI(strName)
  Dim strNS : strNS =""
	If InStr(strName,"CIM_") = 1 Then
	 strNS="http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/"
	ElseIf InStr(strName,"AMT_") = 1 Then
	 strNS = "http://intel.com/wbem/wscim/1/amt-schema/1/"
	ElseIf InStr(strName,"IPS_") = 1 Then
	 strNS = "http://intel.com/wbem/wscim/1/ips-schema/1/"
	ElseIf InStr(strName,"Win32_") = 1 Then   
	 strNS="http://schemas.microsoft.com/wbem/wsman/1/wmi/root/cimv2/"
	Else
	 ' Error Checking - valid URI?
	End If
	MakeURI = strns & strName
end Function

Function Log (intLogLevel,strOut,intErr)
 if intLogLevel <= flgLogLevel then
  WScript.Echo (strOut)
 end if
 if intErr <> 0 then
  if flgLogLevel >= 4 then
   WScript.Echo (Err.Number & ":" & Err.Source & ": " & Err.Description & ".")
  end if
  cleanup(intErr)
  WScript.Quit(intErr)
 end if
 Log = ""

End Function

Sub Cleanup(intErr)
 'Universal script cleanup on exit goes here.
 if not (objWsman Is Nothing) then 
  Set objWsman = nothing
 end if
 if not (objSession Is Nothing) then 
  Set objSession = nothing
 end if
 if not (objLocator Is Nothing) then 
  Set objLocator = nothing
 end if
end Sub

Function GetXMLData(strFileName)
 Dim strTMP
 Dim xmlDoc, x
 
 Set xmlDoc=CreateObject("Microsoft.XMLDOM")
 xmlDoc.async="false"
 xmlDoc.load(strFileName)
 For Each x in xmlDoc.documentElement.childNodes
  colSettings.Item(x.nodename) = x.text
 Next

End Function