﻿//Copyright (c) 2011, Intel Corporation
//All rights reserved.
//
//Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
//
//    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
//    * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
//
//THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// *** Warning ***
//This example was written to be as simple as possible and is for the purpose of illustration only. 
//It has not been written for scalability or vetted for security. 
//For example, passwords are stored in clear text. 
//As such, it not recommended for use in a production environment.
//Use at your own risk. You have been warned.
// *** Warning ***

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Intel.Manageability;
using Intel.Manageability.ACL;
using Intel.Manageability.Exceptions;
using System.Security;

namespace Make_FCFH_User
{
    class Program
    {
        static int Main(string[] args)
        {
            // Validate input
            // username to use, password to use, password to set
            string IP;
            string user;
            string pass;
            string userName;
            string password;
            string inTLS;
            bool TLS;
            try
            {
                IP = args[0];
                user = args[1];
                pass = args[2];
                userName = "FCFH";
                password = args[3];

            }
            catch
            {
                Console.WriteLine("Four parameters are required, the 5th is optional.");
                Console.WriteLine("IP or FQDN of AMT.");
                Console.WriteLine("User Name to log in with.");
                Console.WriteLine("Password to log in with.");
                Console.WriteLine("Password to set on the FCFH user account.");
                Console.WriteLine("1 for TLS.");
                Console.WriteLine("Examples:");
                Console.WriteLine("Make_FCFH_User.exe 192.168.1.101 admin P@ssw0rd P@ssw0rd");
                Console.WriteLine("Make_FCFH_User.exe DQ67EP.vprodemo.com vprodemo\\itproadmin P@ssw0rd P@ssw0rd 1");
                return 1;
            }
            try
            {
                inTLS = args[4];
            }
            catch
            {
                inTLS = "0";
            }
            if (inTLS == "1")
            {
                TLS = true;
            }
            else
            {
                TLS = false;
            }
            IAMTInstance amt;
            try
            {
                ConnectionInfo.AuthMethod contype;

                if (user.Contains("\\"))
                {
                    contype = ConnectionInfo.AuthMethod.Kerberos;
                }
                else
                {
                    contype = ConnectionInfo.AuthMethod.Digest;
                }
                ConnectionInfo ci = new ConnectionInfo(IP, user, pass, TLS,
                                                       string.Empty, contype,
                                                       null, null);
                amt = AMTInstanceFactory.Create(ci);

            }
            catch (ManageabilityException e)
            {
                Console.WriteLine(e.Message);
                
                //Console.WriteLine("Press Enter to Continue.");
                //Console.ReadLine();

                return 2;
            }

            //------------------------
            // Create DigestEntry
            //------------------------

            List<Realm> realms = new List<Realm>();
            realms.Add(Realm.GeneralInfo);
            realms.Add(Realm.HardwareAsset);

            // Create SecuteString by password. 
            SecureString secureString = new SecureString();

            foreach (char c in password)
                secureString.AppendChar(c);

            DigestEntry digestEntry = new DigestEntry(userName, secureString, realms, AccessPermission.Network);

            try
            {
                amt.Config.ACL.CreateOrUpdateDigestUser(digestEntry);
                Console.WriteLine("Create digest user completed successfully.");
            }
            catch (ACLManageabilityException e)
            {
                Console.WriteLine("{0} failed with error: {1} ACLFailor: {2}\n", e.Source, e.Message, e.Failure);
                return 3;
            }
            catch (ManageabilityException e)
            {
                Console.WriteLine("{0} failed with error: {1}\n", e.Source, e.Message);
                return 3;
            }          


            //Console.WriteLine("Press Enter to Continue.");
            //Console.ReadLine();
            return 0;

        }
    }
}
