#!c:\perl\bin\perl.exe 

####################################################################################################################
# Rev 2.0
####################################################################################################################
# Rev History
# Rev 0.0 - Inital release
# Rev 1.0 - Speed added spaces to the manufacturing data. Fixed the space problem by looking for "| " instead of "|"
#           Also, fixed the "" issue.  "" confused the split and the quantity was wrong in the array
# Rev 2.0 - Speed changed the BOM report to not have | delimiters and now it is , again.
#           Added a switch to the command line -m which turns off the manufacture part number compare.
#################################################################################################################### 

# What this script does...
# This script parses out the manufacture and part number out of the Cadence BOM
# and compares it against the SPEED BOM.  The SPEED BOM is created by using SPEED -
# 1) Go to the main PBA number you need to compare
# 2) Use the BOM report function.
# 3) Click on BOM Text and Manufactures.
# 4) Save as a excel file.
# 5) Go to Excel and save as...  Text file with comma delimited

# How to Use Script
# type -> perl BOM_chk.pl BOM_Update.txt SPEED_BOM.csv > report.txt
# or
# type -> perl BOM_chk.pl -m BOM_Update.txt SPEED_BOM.csv > report.txt
# The BOM_Update.txt file gets created when you run the BOM script "empty_update.pl"
# The SPEED_BOM.csv is what ever you named the file you saved from SPEED.

# The file names can not have spaces in there names.  Put an _ in place of the space.

$noman = 0;

if ($ARGV[0] =~ /\-m/)
{
   $noman = 1;
   $Cad_BOM = $ARGV[1];
   $SPEED_BOM = $ARGV[2];
}
else
{
   $Cad_BOM = $ARGV[0];
   $SPEED_BOM = $ARGV[1];
}
printf "\n\n**********************************************\n";
printf "**  The Cadence BOM = $Cad_BOM     \n";
printf "**  The SPEED BOM = $SPEED_BOM     \n";
printf "**********************************************\n";

open(IN_CAD, "<$Cad_BOM") or die $!;
open(IN_SPEED, "<$SPEED_BOM") or die $!;
#printf "\n";
#printf "#############################################################\n";
#printf "## Grabbing the IPN, Manufacture's name and part number\n";
#printf "## from the Cadence BOM\n";
#printf "#############################################################\n";
$i = 0;
while (<IN_CAD>)
{
   @line = split(/\,/,$_);
   if (@line[0] eq " ")
   {
       if (@line[2] ne 0)
       {
          if (@line[1] =~ /\d+/)
          {
#             printf "$i => @line[1]  @line[2]\n";
             @Part_no_cad[$i] = @line[1];
             @Cad_qty[$i] = @line[2];
             $i = $i+1;
          }
       }else
       {
          next;
       }
   }
   $k = 0;
   foreach $Fno (@line)
   {
       if ($k < 5){$k= $k+1; next;}
       if ($Fno =~ /^\"/)
       {
           @Cad_Manuf_pn[$i] = @line[$k-1];
           @Cad_Manuf[$i] = @line[$k-2];
           $found = 1;
           last;
       }  else
       {
           $found = 0;
       }
       $k= $k+1;
   }
   if ($found == 0)
   {
       @Cad_Manuf_pn[$i] = @line[$k-3];
       @Cad_Manuf[$i] = @line[$k-4];
   }    
}

#printf "\n\n";
#printf "#############################################################\n";
#printf "## Grabbing the IPN, Manufacture's name and part number\n";
#printf "## from the SPEED BOM\n";
#printf "#############################################################\n";

$j = 0;
$i = 0;
while (<IN_SPEED>)
{
   s/""//;
   @line = split(/\"/,$_);
#  No need to split the line again.  The line have to be split by "," now
#   @mline = split(/\| /,$_);
   @pn = split(/\,/,@line[0]);
   @qty = split(/\,/,@line[2]);  # The manufacture part number is in the qty array now.
   if (@pn[0] =~ /\s/ || @pn[0] =~ "Pro" || @pn[0] =~ "ECO")
   {
      next;
   }elsif(@pn[0] =~ /\d/)
   {
      $j = 0;
#      printf "$i => @pn[4] @qty[1]\n";
      @Part_no_Speed[$i] = @pn[4];
      @Speed_qty[$i] = @qty[1];

#   The manufacture part number is in the @line[2] which was split into the @qty array
#   @mline is not used anymore.
#      $Speed_Manuf_pn{$i,$j} = @mline[3];
#      $Speed_Manuf{$i,$j} = @mline[2];
#      $Speed_Manuf_status{$i,$j} = @mline[4];
      
# The manufacturing informaton is on the same line as the part number in this area
      $Speed_Manuf_pn{$i,$j} = @qty[9];
      $Speed_Manuf{$i,$j} = @qty[8];
      $Speed_Manuf_status{$i,$j} = @qty[10];
      $i = $i+1;
   }elsif($_ =~ ",,,,,,")
   {
      $j = $j+1;
      $k = $i-1;
#   The manufacture part number is in the @line[2] which was split into the @qty array
#   @mline is not used anymore.
#      $Speed_Manuf_pn{$k,$j} = @mline[3];
#      $Speed_Manuf{$k,$j} = @mline[2];
#      $Speed_Manuf_status{$k,$j} = @mline[4];

# The manufacturing information is on a line of it's own is this area.
      $Speed_Manuf_pn{$k,$j} = @pn[15];
      $Speed_Manuf{$k,$j} = @pn[14];
      $Speed_Manuf_status{$k,$j} = @pn[16];
      next;
   }
}


close(IN_CAD) or die $!;
close(IN_SPEED) or die $!;

printf "\n\n";
printf "#############################################################\n";
printf "## Looking for more then one line item with the same IPN.\n";
printf "## This may not be desired when you load the BOM into SPEED.\n";
printf "#############################################################\n";
$i = 0;
foreach $Cad_part (@Part_no_cad)
{
   $j = 1;
   $i = $i + 1;
   $found = 0;
   for($k = $i; $k < $#Part_no_cad; $k++)
   {
#       printf "$k checking $Cad_part against @Part_no_cad[$k]\n";
       if($Cad_part eq @Part_no_cad[$k])
       {
          $j = $j +1;
          $found = 1;
       }
    }
    if ($found == 1)
    {
       printf " $j entries for $Cad_part  ARE YOU SURE THIS IS WHAT YOU WANTED?\n";
    }
}

printf "\n\n";
printf "#############################################################\n";
printf "## Comparing the Cadence BOM to the SPEED BOM \n";
printf "## Quantities, IPN's and Manufacture information\n";
printf "## Also checking if there are more line items on one \n";
printf "## BOM over the other.\n";
if($noman == 1)
{
   printf "## Not checking manufacturing part information -m switch was set \n";
}
printf "#############################################################\n";
if ($#Part_no_speed le $#Part_no_Cad)
{
    $j = $#Part_no_cad;
    $i = $#Part_no_Speed;
    $k = $j - $i;
    printf "There are $k more Cadence line items then SPEED\n\n\n";
$k = 0;
$j = 0;
$i = 0;
$found = 1;
    foreach $Cad_part (@Part_no_cad)
    {
       $k = 0;
       $j = 0;
       $Qty_match = 0;
       $found_noqty = 99;
       $i=$i+1;
       foreach $Speed_part (@Part_no_Speed)
       {
          if ($Cad_part eq $Speed_part)
          {
              $found = 1;
              if (@Cad_qty[$i-1] eq @Speed_qty[$k])
              {
                 $Qty_match = 1;
#                 printf " Quantity match for $j $Cad_part $Speed_part @Cad_qty[$i-1] = @Speed_qty[$k]\n";
              }else
              {
                 $Qty_match = 0;
                 $last_speed_qty = @Speed_qty[$k];
                 $last_cad_qty = @Cad_qty[$i-1];
#                 printf " Qty mismatch $j $Cad_part $Speed_part @Cad_qty[$i-1] != @Speed_qty[$k]\n";
              }
              if ($noman == 0)
              {
                 if (@Cad_Manuf_pn[$i] eq $Speed_Manuf_pn{$k,$j})
                 {
#                   printf " Manufacture part number match on $j $Cad_part $Speed_part @Cad_Manuf_pn[$i] = $Speed_Manuf_pn{$k,$j} \n"; 
                 }else
                 {
                    for ($j = 0;$j <= 15; $j++)
                    {
                       if (@Cad_Manuf_pn[$i] eq $Speed_Manuf_pn{$k,$j})
                       {
#                           printf " Manufacture part number match on $j $Cad_part $Speed_part @Cad_Manuf_pn[$i] = $Speed_Manuf_pn{$k,$j} \n";
                           last();
                        }else
                        {
#                            printf " Manufacture part number Does NOT match on $j $Cad_part $Speed_part **@Cad_Manuf_pn[$i]** =**$Speed_Manuf_pn{$k,$j}**  \n";
                            if ($j == 15)
                            {
                               printf "Manufacture Part# Not Found: $Cad_part @Cad_Manuf[$i] @Cad_Manuf_pn[$i]\n"; 
                            }
                         }
                     }                 
                 }
              }
              if ($Qty_match == 1)
              {
                 $j = 0;
                 $k = 0;
                 $found_noqty = 1;
                 last();
              }else
              {
                 $found_noqty = 0;
              }
          }else
          {
              $found = 0;
         #     printf " Not Equal";
          }
          $k = $k + 1;
       }  
       if ($found_noqty == 99){printf " $Cad_part Did not find a SPEED part number that matched.\n";}
       if ($found_noqty == 0){printf "Qty mismatch $Cad_part $last_cad_qty != $last_speed_qty\n";}
    }

} else
{
    $i = $#Part_no_Speed - $#Part_no_Cad;
    printf "There are $k more SPEED line items then Cadence\n";
}

printf "\n\n";
printf "#############################################################\n";
printf "## Checking for extra SPEED IPN's \n";
printf "#############################################################\n";
 

foreach $Speed_part (@Part_no_Speed)
{
   $match = 0;
   foreach $Cad_part (@Part_no_cad)
   {
      if ($Cad_part eq $Speed_part)
      {
          $match = 1;
          last();
      }else
      {
          next();
      }
   }
   if ($match == 0){printf "$Speed_part is not on Cadence BOM\n"; }
}