@echo off

:: Copyright (c) 2011, Intel Corporation
:: All rights reserved.
::  
:: Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
:: 
::     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
::     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
::     * Neither the name of Intel Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
:: 
:: THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

if not exist %~dp0..\..\..\inc\settings.bat (
 echo Missing %~dp0..\..\..\inc\settings.bat.
 goto end
)

call %~dp0..\..\..\inc\settings.bat

:: Check for temp dir
SET TMP_DIR=%~dp0..\..\..\tmp\
if not exist %TMP_DIR% (
 echo Temp directory not found.
 goto end
)
:: Make the temp directory structure
set WKDIR=%TMP_DIR%OS_Image\%arch%\windows\system32
mkdir %WKDIR%
if not exist %WKDIR% (
 echo Unable to create working directory.
 goto end
)

:: Extract Imagex for desired architecture
:: get path to WAIK ISO
cscript /nologo %~dp0set_waik.vbs
call %~dp0set_waik.bat
if "%WAIK%"=="" (
 echo WAIK not found.
 goto end
)
:: Extract Neutral.cab from the MSI file
set FILE=Neutral.cab
%~dp0..\..\..\inc\7z.exe e "%WAIK%" %FILE% -y -o%TMP_DIR%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%.
 goto end
)
:: Extract imagex
set LASTFILE=%TMP_DIR%%FILE%
if %ARCH%==amd64 set FILE=F3_imagex
if %ARCH%==x86 set FILE=F1_imagex
if %FILE%==%LASTFILE% (
 echo Unknown system Architecture
 goto end
)
%~dp0..\..\..\inc\7z.exe e %LASTFILE% %FILE% -y -o%TMP_DIR%
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%.
 goto end
)
del /q /f %LASTFILE%
move %TMP_DIR%%FILE% %WKDIR%\imagex.exe
if not exist %WKDIR%\imagex.exe (
 echo Unable to extract imagex.exe
 goto end
)

:: Create settings batch files for automatically starting image process
cscript /nologo %~dp0os_image.vbs
::if exist %WKDIR%\OSI_settings.bat goto copy_files

:: Extract WINPE_FPS\WINPE-SCRIPTING.CAB
if not exist %TMP_DIR%\WINPE_FPS mkdir %TMP_DIR%\WINPE_FPS
set FILE=%ARCH%\WINPE_FPS\winpe-hta.cab
%~dp0..\..\..\inc\7z.exe x "%WAIKSUP%" %FILE% -y -o%TMP_DIR%\WINPE_FPS
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

:: Extract WINPE_FPS\WINPE-SCRIPTING.CAB Languag File
set FILE=%ARCH%\WINPE_FPS\%LANG%\winpe-hta_%LANG%.cab
%~dp0..\..\..\inc\7z.exe x "%WAIKSUP%" %FILE% -y -o%TMP_DIR%\WINPE_FPS
if not %ERRORLEVEL%==0 (
 echo Failed to extract %FILE%
 goto end
)

:copy_files
:: Copy OS Imaging automation batch files
copy %~dp0*.ba_ %WKDIR%\*.bat
copy %~dp0*.tx_ %WKDIR%\*.txt
copy %~dp0*.vb_ %WKDIR%\*.vbs


echo Success
:end