#!/bin/sh -x
#
# Re-init.sh
#
####
#### Pre-requirement : Unplug all disks then boot up system.
####                   After system boot into ram mode then all disks plugin.
####                   all disks should be recognize by system.
####                   ==> check /proc/scsi/scsi to make sure all disk is ready
####
####     If b524 package put into directory /tmp/newpkg, 
####                         it will upgrade firmware at the same time.
####
## update 2007/02/07 10:24

#
CHECKSUM_V10_20060207="a06385b04ca65d6516ac2acd1693660d"
CHECKSUM_V11_b214="f4eebdd4859f1f30b6ae1e6eebdb9731"
CHECKSUM_V12_b522="5af092cb04a5bfb803486acd4935071c"

CHECKSUM_V13_b524="2dab845eaf9c45c03973f1cb023a8584"
CHECKSUM_V13_b524_ZIMAGE="10baed978b1afa1689e6a32af154bd6e"
CHECKSUM_V13_b524_RAMDISK="bf49e0931ccb205f45ed6fa0430958b3"

if [ -f /etc/.is.sh ]
then
    . /etc/.is.sh
else
    echo Installation is not complete. Environment profile is missing in /etc.
    echo
    exit 1
fi

Backup_files()
{
    ### start up raid md0
    mkdir -p /sysroot
    /fs/fsraid.sh start /dev/md0
    mount /dev/md0 /sysroot
    grep "/dev/md0 " /proc/mounts
    if [ "$?" != "0" ]
    then
        echo "can't backup config files since there is no md0"
        sleep 2
    fi

    ### start up raid md1 for hostname
    /fs/fsraid.sh start /dev/md1
    grep "md1" /proc/mdstat
    if [ "$?" != "0" ]
    then
        echo "NAS system not ready since there is no md1"
        echo "Abort!!!"
        umount /dev/md0
        exit 1
    fi

    ### backup files
    mkdir -p /tmp/backup_$$/etc
    for i in passwd group
    do
        if [ -f /sysroot/etc/$i ]
        then
            cp /sysroot/etc/$i /tmp/backup_$$/etc/$i
        fi
    done

    ### backup ipstor configure files
    # gethostname 
    HOSTNAME=`dd if=/dev/md1 bs=1k count=4 | strings | grep DynamicDiskSegment | awk -F\" '{ print $8 }' | head -1`
    if [ ! -z ${HOSTNAME} ]
    then
        ### backup important files
        for i in etc/unas.conf etc/${HOSTNAME}/nas.conf etc/${HOSTNAME}/nasuser.conf
        do
            if [ -f /sysroot/usr/local/ipstor/${i} ]
            then
                Filename=`basename ${i}`
                cp /sysroot/usr/local/ipstor/${i} /tmp/backup_$$/${Filename}
            fi
        done

        if [ -d /sysroot/usr/local/ipstor/etc -a -d /sysroot/usr/local/ipstor/etc/${HOSTNAME} ]
        then
            cd /sysroot/usr/local/ipstor
            tar zcvf /tmp/backup_$$/ipstor_etc.tgz etc
            cd -
        fi
    else  
        # no hostname found
        echo "HOSTNAME is empty!!"
        echo "Abort!!"
        exit 1
    fi

    # stop md1
    /fs/fsraid.sh stop /dev/md1

    UPGRADE_FIRMWARE=0
    MD5_OK=0 
    if [ -f /tmp/newpkg/fs-bc-1.3-b524.pkg ]
    then
        CHECKSUM1=`md5sum /tmp/newpkg/fs-bc-1.3-b524.pkg | awk '{print $1}'`
        if [ "${CHECKSUM1}" = "${CHECKSUM_V13_b524}" ]
        then
            mv /tmp/newpkg/fs-bc-1.3-b524.pkg /tmp/backup_$$/fs.pkg
            UPGRADE_FIRMWARE=1
            MD5_OK=1
        else
            echo "Bad package!! NO firmware upgraded."
            sleep 2
        fi
    fi
    if [ $UPGRADE_FIRMWARE = "0" ]
    then
        ### check for version
        grep "1.0-" /etc/version
        if [ "$?" = "0" ]
        then
            # v1.0
            if [ -f /sysroot/images/fs.pkg ]
            then
                cp /sysroot/images/fs.pkg /tmp/backup_$$/fs.pkg
            else
                echo "version v1.0 but no package available."
                echo "Abort!!!"
                exit 1
            fi
        else
            # v1.1 , v1.2 or later
            cp /sysroot/images/fs.pkg /tmp/backup_$$/fs.pkg
            /fs/writeflash -e /tmp/backup_$$/fs.pkg
        fi
        CHECKSUM1=`md5sum /tmp/backup_$$/fs.pkg | awk '{print $1}'`
        for i in ${CHECKSUM_V10_20060207} ${CHECKSUM_V11_b214} ${CHECKSUM_V12_b522}
        do
            if [ "${i}" = "${CHECKSUM1}" ]
            then
                MD5_OK=1
                break
            fi
        done
    fi

    if [ "${MD5_OK}" != "1" ]
    then
        echo "MD5 check fail."
        echo "Abort!!"
        exit 1
    fi

}

Init_rootfs()
{
    grep md0 /proc/mdstat
    if [ "$?" != "0" ]
    then
        /fs/fsraid.sh start /dev/md0
        grep md0 /proc/mdstat
        if [ "$?" != "0" ]
        then
            echo "md0 does not exist"
            echo "Abort!!"
            exit 1
        fi
    fi

    grep "/dev/md0 " /proc/mounts
    if [ "$?" = "0" ]
    then
        umount /dev/md0
    fi
    
    mke2fs -j /dev/md0
}

Recover()
{
    # extract package to /sysroot
    mount /dev/md0 /sysroot
    grep "/dev/md0 " /proc/mounts
    if [ "$?" != "0" ]
    then
        echo "can't recover files since there is no md0 mounted"
        echo "Abort!!!"
        exit 1
    fi
    HEADER_SIZE_KB=`dd if=/tmp/backup_$$/fs.pkg bs=1 count=8 skip=64`
    cd /sysroot; dd if=/tmp/backup_$$/fs.pkg bs=1k skip=${HEADER_SIZE_KB} | gzip -dc | tar xvf -

    # start md1
    /fs/fsraid.sh start /dev/md1 

    # gethostname 
    HOSTNAME=`dd if=/dev/md1 bs=1k count=4 | strings | grep DynamicDiskSegment | awk -F\" '{ print $8 }' | head -1`
    if [ -z $HOSTNAME ]
    then
        echo "HOSTNAME is empty!!"
        echo "Abort!!"
        exit 1
    fi
    hostname ${HOSTNAME}

    # link to disk files
    mv /etc /etc.org; ln -s /sysroot/etc /etc
    mv /bin /bin.org; /sysroot/bin/ln -s /sysroot/bin /bin
    mv /lib/modules /lib/modules.org; ln -s /sysroot/lib/modules /lib/modules
    mv /usr /usr.org; ln -s /sysroot/usr /usr
    . /etc/.is.sh
    mkdir -p /nas

    # recover /etc
    for i in passwd group
    do
        cp -f /sysroot/usr/local/ipstor/etc/${i}.default /sysroot/etc/${i} 
    done

    # recover /usr/local/ipstor/etc directory
    ################################################################
        # unas.conf
        sed -e "s/HOSTNAME=\"Storage\"/HOSTNAME=\"${HOSTNAME}\"/" \
            < /sysroot/usr/local/ipstor/etc/unas.conf.default \
            > /sysroot/usr/local/ipstor/etc/unas.conf

        ### startup ipstor and re-generate config file
        ipstor start kfsnbase
        unas.sh startstorage
        ipstorsetup -f
        cd /sysroot/usr/local/ipstor/etc

        # rename diskname to disksafe 
        ds_rename_pdev `hostname`/ipstor.conf

        # license
        mkdir `hostname`/license
        cp -f  .license/*  `hostname`/license
        for i in `hostname`/license/*
        do
            echo "`date +%s`\$" > $i
            echo "Product Code 0" >> $i
            echo "Serial Number 0" >> $i
            echo "OS Index 0" >> $i
        done

        # enable NAS function
        # ipstor.conf
        sed -e 's/<NASOption value=\"false\" primary=\"true\">/<NASOption value=\"true\" primary=\"true\">/' \
            -e 's/serverIP=\"\"/serverIP=\"127.0.0.1\"/' \
            -e 's/<XBootOption enabled=\"false\"/<XBootOption enabled=\"true\"/' \
            <  `hostname`/ipstor.conf \
            > `hostname`/ipstor.conf.nas 
        mv -f `hostname`/ipstor.conf.nas  `hostname`/ipstor.conf

        # nas.conf
        sed -e "s/%HOSTNAME%/$HOSTNAME/g" \
            -e "s/%COMMENT%/$COMMENT/g" \
            -e "s/%WORKGROUP%/$WORKGROUP/g" \
            < $ISHOME/etc/nas.conf.default \
            > $ISHOME/etc/$HOSTNAME/nas.conf

        cp -f $ISHOME/etc/nasuser.conf.default $ISHOME/etc/$HOSTNAME/nasuser.conf
        cp -f $ISHOME/etc/usermap.default $ISHOME/etc/$HOSTNAME/usermap
        cp -f $ISHOME/etc/smbpasswd.default $ISHOME/etc/$HOSTNAME/smbpasswd

        # enable iscsi
        /sysroot/usr/local/ipstor/bin/enableiscsi `hostname`/ipstor.conf

        # nas update for fs
        nasconfupdt update
        sed -e 's/security=\"SHARE\"/security=\"USER\"/' < `hostname`/nas.conf  > `hostname`/nas.conf.user
        mv -f  `hostname`/nas.conf.user  `hostname`/nas.conf
        cd -
    ################################################################

    mkdir -p /sysroot/usr/local/ipstor/var/tmp
#    mkdir -p /var/lib/nfs
#    mkdir -p /var/lock/subsys
    mkdir -p /nas
}

# main function

    # first backup all files
    Backup_files

    # reconstruct root filesystem
    Init_rootfs

    # recovery
    Recover

    # startup
    ipstor start kfsnbase
    ipstor start
    set_disk_info -f

    # check for vid2
    RESULT_OK=0
    ls /proc/ipstor
    if [ -f "/proc/ipstor/2" ]
    then
        grep NASDisk-00002 /proc/mounts
        if [ "$?" = "0" ]
        then
            if [ -d /nas/NASDisk-00002/public ]
            then

                # create directory for backup data
                timestamp="`date +%s`"
                TMP_DIR="/nas/NASDisk-00002/public/bcbox.recover.${timestamp}"
                while [ -d ${TMP_DIR} -o -f ${TMP_DIR} ]
                do
                    timestamp=$[ ${timestamp} + 1 ]
                    TMP_DIR="/nas/NASDisk-00002/public/bcbox.recover.${timestamp}"
                done

                mkdir -p ${TMP_DIR}
                for i in `ls /nas/NASDisk-00002`
                do
                    if [ "${i}" != "homes" -a "${i}" != "spool" ]
                    then
                        echo "${i}" >> ${TMP_DIR}/sharelist
                    fi
                done

                if [ -d /nas/NASDisk-00002/homes ]
                then
                    for i in `ls /nas/NASDisk-00002/homes`
                    do
                        echo "${i}" >> ${TMP_DIR}/userlist
                    done
                fi

                for i in unas.conf nas.conf nasuser.conf
                do
                    if [ -f /tmp/backup_$$/${i} ]
                    then
                        cp /tmp/backup_$$/${i} ${TMP_DIR}
                    fi
                done

                if [ -x /tmp/nas_info ]
                then
                    /tmp/nas_info /tmp/backup_$$/nas.conf /tmp/backup_$$/nasuser.conf > ${TMP_DIR}/nas_user_share_list 2>&1
                    echo "return $?" >> ${TMP_DIR}/nas_user_share_list
                fi

            else
                echo "NOTICE: NO sharelist file created!!"
            fi

            RESULT_OK=1
        else
            echo "NOTICE: NO NASDisk mounted!!"
        fi
    fi

    # clean up
    if [ ${UPGRADE_FIRMWARE} = "1" ]
    then
        mkdir /pkgnew
        mv /sysroot/images/ramdisk.gz /pkgnew
        mv /sysroot/images/zImage /pkgnew
        cp /tmp/backup_$$/fs.pkg /sysroot/images
        mv /tmp/backup_$$/fs.pkg /tmp/newpkg
    else
        rm -f /sysroot/images/*
        mv /tmp/backup_$$/fs.pkg /sysroot/images
    fi
    rm -f /sysroot/upgrade.sh
    mv /tmp/backup_$$ /sysroot/images

    sync;sync;sync
  
    #if [ -d ${TMP_DIR} ]
    #then
    #    echo "backup files list...."
    ls -alR /nas
    sleep 5
    #fi 

    echo "Wait for 5 seconds to stop all process"
    sleep 5

    unas.sh stop
    unas.sh stopstorage

    # link back to original position
    cd /tmp
    rm /etc; mv /etc.org /etc
    rm /bin; /bin.org/mv /bin.org /bin
    rm /lib/modules; mv /lib/modules.org /lib/modules
    rm /usr; mv /usr.org /usr

    killall -9 smRoutineScript mdadm sleep
    umount /sysroot
    for i in md1 md0
    do
        /fs/fsraid.sh stop /dev/${i}
    done

    # update flash
    if [ $UPGRADE_FIRMWARE = "1" ]
    then
        CHECKSUM1=`md5sum /pkgnew/zImage | awk '{print $1}'`
        CHECKSUM2=`md5sum /pkgnew/ramdisk.gz | awk '{print $1}'`
        CHECKSUM3=`md5sum /tmp/newpkg/fs.pkg | awk '{print $1}'`
        if [ "${CHECKSUM1}" = "${CHECKSUM_V13_b524_ZIMAGE}" -a "${CHECKSUM2}" = "${CHECKSUM_V13_b524_RAMDISK}" -a "${CHECKSUM3}" = "${CHECKSUM_V13_b524}" ]
        then
            echo "Update zImage ......"
            /fs/writeflash -z /pkgnew/zImage
            echo "Update ramdisk.gz ......"
            /fs/writeflash -r /pkgnew/ramdisk.gz
            echo "Update fs.pkg ......"
            /fs/writeflash -p /tmp/newpkg/fs.pkg
        else
            echo "checksum fail!! give up flash update"
        fi
    fi

    sync;sync;sync

    echo "RESULT is ${RESULT_OK}"
    echo "Done"
 
