echo -off
# + ============================================================== +
#  Copyright (c) 2012, Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  startup.nsh

#  Abstract:  Script file for invoking iflash.

# + ============================================================== +
#    Program all blocks of BIOS from capsule file 
# + ============================================================== +

@echo -off
mode 80 25
;foundimage section is simply to locate the correct drive
cls
if exist .\ipmi.efi then
 goto FOUNDIMAGE
endif
if exist fs0:\ipmi.efi then
 fs0:
 echo Found Update Packages on fs0:
 goto FOUNDIMAGE
endif
if exist fs1:\ipmi.efi then
 fs1:
 echo Found Update Packages on fs1:
 goto FOUNDIMAGE
endif
if exist fs2:\ipmi.efi then
 fs2:
 echo Found Update Packages on fs2:
 goto FOUNDIMAGE
endif
 echo "Unable to find Update Packages".  
 echo "Please mount the drive with the update package".
 echo ""
 goto END
:FOUNDIMAGE
echo ==========================================================================
echo "This utility will allow you to update the BMC, BIOS, ME firmware, "
echo "and FRUSDR in the Intel(R)Server Boards S2600JF series
echo "and Intel(R)Server System H2000JF Family"
echo ""
echo "If you want to do all these functions, press Enter. If not, hit 'q'."
echo ""
echo "if you want to update single components like BMC/BIOS separately,"
echo "please execute the specified scripts separately,"
echo "and follow below update process to ensure trouble free update"
echo "from BIOS R043.1, BMC 10.3:"
echo "  1): BMC firmware update to 1.16R4010;"
echo "  2): BIOS update to R01.06.0001;"
echo "  3): Manageability Engine (ME) Firmware update to 02.01.05.107;"
echo "  4): FRUSDR update to R1.09"
echo ""
echo "Do NOT reboot during this process until you see Updates completed."

echo ==========================================================================
pause

echo ""
echo Integrated BMC and Intel Remote Management Module 4 firmware update R1.00
echo ""
# Update everything including the boot block
FWPIAUPD -u -bin -ni -b -o -pia -nopc -if=usb BMC_i_0116r4010.bin
echo ""
echo "BMC R1.16r4010 Update completed"

echo ""
echo Flashing BIOS and ME...
 iflash32 /u /ni R01.06.0001.cap
echo ""
echo "BIOS R01.06.0001 update completed..."
echo ""
 iflash32 /u /ni MEComplete_02.01.05.107_HFW.cap
echo ""
echo "ME R02.01.05.107 update completed..."


echo ""
echo "Update FRUSDR using FRUSDR utility"
frusdr -cfg MASTER.cfg
echo ""
echo "FRUSDR R1.09 Update completed..."
echo ""
echo ""
echo "Updates completed. Please reboot using the front panel button."
:END

