@ECHO off
cls

REM Notes:
REM When detecting Errorlevel codes in DOS, the user must perform the checks
REM in reverse numerical order.  This is due to the fact that the statement:
REM                     "IF ERRORLEVEL 6 GOTO label"
REM will test true on all error levels equal to OR greater than 6.  Therefore
REM you must check the highest expected return code and work down in
REM decending order!
REM Also note the label'd sections.  At the end of each section there is
REM a jump to the 'END' label.  This forces the code to skip all the
REM undesired sections and jump to the final output.

REM DOS Label  EL       P/F     Description
REM ---------  ---      ---     ---------------------------
REM NODETECT    0       Pass    ADD not detected
REM DETECT      1       Pass    ADD detected
REM PARAMETER   2       Fail    Bad parameter passed
REM PLATFORM    3       Fail    Platform not supported
REM VBIOS       4       Fail    VBIOS call not supported
REM UNKNOWN     5       Fail    Unknown
REM USERBREAK   6       N/A     User break
REM NOTESTS     7       N/A     No tests were run

REM Call detadd and pass up to 9 parameters for testing
REM Additional parameters should be located in the DETADD.INI file!

call detadd %1 %2 %3 %4 %5 %6 %7 %8 %9

REM Check for the return code and jump to the desired function
IF ERRORLEVEL 7 GOTO NOTESTS
IF ERRORLEVEL 6 GOTO USERBREAK
IF ERRORLEVEL 5 GOTO UNKNOWN
IF ERRORLEVEL 4 GOTO VBIOS
IF ERRORLEVEL 3 GOTO PLATFORM
IF ERRORLEVEL 2 GOTO PARAMETER
IF ERRORLEVEL 1 GOTO DETECT
IF ERRORLEVEL 0 GOTO NODETECT

:NOTESTS
set msg=No tests run
set el=7
set pf=N/A
goto END

:USERBREAK
set msg=P/F: N/A, User break
set el=6
set pf=N/A
goto END

:UNKNOWN
set msg=Unknown error
set el=5
set pf=FAIL
goto END

:VBIOS
set msg=Unsupported VBIOS call
set el=4
set pf=FAIL
goto END

:PLATFORM
set msg=Platform not supported
set el=3
set pf=FAIL
goto END

:PARAMETER
set msg=Bad parameter passed
set el=2
set pf=FAIL
goto END

:DETECT
set msg=ADD Card detected
set el=1
set pf=PASS
goto END

:NODETECT
set msg=ADD Card NOT detected
set el=0
set pf=PASS
goto END

:END
echo -----------------------------------------
echo 'DETADD.EXE' output shown above this line!
echo.
echo 'DA.BAT' output shown below this line!
echo -----------------------------------------
echo Pass/Fail:     %pf%
echo Description:   %msg%
echo Error Level:   %el%
echo.
echo.
