@ECHO OFF
REM *********************************************************************
REM
REM $Workfile: DIAG.BAT $
REM
REM Purpose:
REM     To execute Intel(r) Graphics Controller Diagnostic Utility
REM
REM Environment:
REM     MSDOS 6.22 or later,
REM     DOS4GW protected mode DOS extender 1.97 or later.
REM
REM Warnings and Restrictions:
REM     Copyright (c) 2009 Intel Corporation, all rights reserved.
REM
REM     INTEL MAKES NO WARRANTY OF ANY KIND REGARDING THE CODE.  THIS CODE
REM     IS LICENSED ON AN "AS IS" BASIS AND INTEL WILL NOT PROVIDE ANY
REM     SUPPORT, ASSISTANCE, INSTALLATION, TRAINING OR OTHER SERVICES.
REM     INTEL DOES NOT PROVIDE ANY UPDATES ENHANCEMENTS OR EXTENSIONS.
REM     INTEL SPECIFICALLY DISCLAIMS ANY WARRANTY OF MERCHANTABILITY,
REM     NONINFRINGEMENT, FITNESS FOR ANY PARTICULAR PURPOSE, OR ANY OTHER
REM     WARRANTY.  INTEL DISCLAIMS ALL LIABILITY, INCLUDING LIABILITY FOR
REM     INFRINGMENT OF ANY RIGHTS, RELATING TO USE OF THE CODE.  NO
REM     LICENSE, EXPRESS OR IMPLIED, BY ESTOPPEL OR OTHERWISE, TO ANY
REM     INTELLECTUAL PROPERTY RIGHTS IS GRANTED HEREIN.
REM
REM *********************************************************************/
REM	Command Line Limits:
REM	--------------------
REM	DOS4GW supercedes the DOS command line limit of 128 chars with a
REM	limit of 103 characters.  Command line parameters will be 
REM	truncated to 103 chars by DOS4GW.  If more than 106 chars are
REM	specified DOS4GW will fail with the message:
REM
REM		Stub exec failed:
REM		X:\xxx\dos4gw.exe
REM		Argument list too big
REM
REM     Loop Parameter:
REM     ---------------
REM     If you would like the code to loop until FAILURE or USER ABORT
REM     add a 'loop' parameter to the command line.  The command must be
REM     in lower case to function properly.  The 'loop' parameter may
REM     appear anywhere on the command line.
REM
REM *********************************************************************/

SET PTFS=ILK,PNV,45,33,965,945,915,865,855,845,830,815,810 
REM replace PNV from line above and use corresponding number
SET EX=
SET CMDS=
SET LP=

REM                     Construct EXE name for this platform.
FOR %%I IN (%PTFS%) DO IF EXIST I%%IDIAG.EXE SET EX=I%%IDIAG
IF NOT "%EX%"=="" GOTO START
ECHO.
ECHO Error!  8xx/9xx executable not found.
ECHO.
GOTO END

REM                     Process the loop parameter in this batch file.

:START
IF "%1"=="" GOTO RUN
REM                     If 'loop' param, set flag and remove.
REM
IF "%1"=="loop" SET LP=Y
IF "%1"=="loop" SHIFT
IF "%1"=="loop" GOTO START
REM                     Section overcomes DOS's nine parameter limit.
REM                     Collect all the non loop command line args.
REM
IF NOT "%1"=="" SET CMDS=%CMDS% %1
SHIFT
GOTO START

REM                     Call the exe with all the parameters.
:RUN
%EX%%CMDS%
ECHO .
IF ERRORLEVEL 2 GOTO FAIL
IF ERRORLEVEL 1 GOTO ABORT
IF "%LP%"=="Y" GOTO RUN
IF ERRORLEVEL 0 GOTO PASS
ECHO INVALID RETURN CODE
GOTO END
:PASS
ECHO PPPP     A     SSS    SSS
ECHO P   P   A A   S   S  S   S
ECHO P   P  A   A  S      S
ECHO PPPP   AAAAA   SSS    SSS
ECHO P      A   A      S      S
ECHO P      A   A  S   S  S   S
ECHO P      A   A   SSS    SSS
GOTO END
:FAIL
ECHO FFFFF    A     III   L
ECHO F       A A     I    L
ECHO F      A   A    I    L
ECHO FFFF   AAAAA    I    L
ECHO F      A   A    I    L
ECHO F      A   A    I    L
ECHO F      A   A   III   LLLLL
GOTO END
:ABORT
ECHO IIIII  N   N   CCC    OOO   M   M  PPPP   L      EEEEE  TTTTT  EEEEE
ECHO   I    NN  N  C   C  O   O  MM MM  P   P  L      E        T    E
ECHO   I    N N N  C      O   O  M M M  P   P  L      E        T    E
ECHO   I    N N N  C      O   O  M   M  PPPP   L      EEE      T    EEE
ECHO   I    N  NN  C      O   O  M   M  P      L      E        T    E
ECHO   I    N   N  C   C  O   O  M   M  P      L      E        T    E
ECHO IIIII  N   N   CCC    OOO   M   M  P      LLLLL  EEEEE    T    EEEEE
GOTO END
:END
ECHO .
REM Clean up environment
FOR %%I IN (EX,CMDS,PTFS,LP,LPF) DO SET %%I=

