/**
* @file Ioh_1588_ioctl.h
*
* @author Wipro Technologies 
* @date 27 Jul 2009
*
* @brief IOCTLs supported by the IEEE1588 driver
*
* This file contains the various driver loading related
*files
*
* 
 * @par
 * IOH_Windows Driver Release version 1.0 
 * 
 * -- Copyright Notice --
 * 
 * @par
 * Copyright (c) 2009-2012, LAPIS semiconductor .
 * All rights reserved.
 * 
 * @par
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the LAPIS semiconductor  nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * 
 * @par
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * 
 * @par
 * -- End of Copyright Notice --
*/
#ifndef __IOH_1588_IOCTL_H__
#define __IOH_1588_IOCTL_H__

/*
Define the IOCTL codes we will use.  The IOCTL code contains a command
identifier, plus other information about the device, the type of access
with which the file must have been opened, and the type of buffering.
The IOCTL function codes from 0x800 to 0xFFF are for customer use.*/

/*! @ingroup InterfaceLayer
  @def DEV_TYPE
  @brief Outlines the Device Type
  */
#define IOH_1588_DEVICE_TYPE 40002

/*! @ingroup InterfaceLayer
  @def IOH_1588_IOCTL
  @brief Macro to define the IOCTLs
  */
#define IOH_1588_IOCTL(_index_) \
    CTL_CODE ( IOH_1588_DEVICE_TYPE, _index_, METHOD_BUFFERED, FILE_ANY_ACCESS)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PORT_CONFIG_SET
 * @brief Set the IEEE 1588 Ethernet port to Mater/Slave/All mode
 */
#define IOCTL_1588_PORT_CONFIG_SET      IOH_1588_IOCTL(0x801)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PORT_CONFIG_GET
 * @brief Get the IEEE 1588 Ethernet port Configuration mode
 */
#define IOCTL_1588_PORT_CONFIG_GET      IOH_1588_IOCTL(0x802)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_RX_POLL
 * @brief Poll for receive timestamp captured on the IEEE 1588 ethernet channel
 */
#define IOCTL_1588_RX_POLL              IOH_1588_IOCTL(0x803)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_TX_POLL
 * @brief Poll for transmit timestamp captured on the IEEE 1588 ethernet channel
 */
#define IOCTL_1588_TX_POLL              IOH_1588_IOCTL(0x804)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_CAN_POLL
 * @brief Poll for timestamp captured on the IEEE 1588 CAN channel
 */
#define IOCTL_1588_CAN_POLL             IOH_1588_IOCTL(0x805)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_SYS_TIME_GET
 * @brief Get the IEEE 1588 system time from the module
 */
#define IOCTL_1588_SYS_TIME_GET         IOH_1588_IOCTL(0x806)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_SYS_TIME_SET
 * @brief Set the IEEE 1588 system time on the module
 */
#define IOCTL_1588_SYS_TIME_SET         IOH_1588_IOCTL(0x807)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_TICK_RATE_SET
 * @brief Set the frequency scaling value used on IEEE 1588 module
 */
#define IOCTL_1588_TICK_RATE_SET        IOH_1588_IOCTL(0x808)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_TICK_RATE_GET
 * @brief Get the frequency scaling value used on IEEE 1588 module
 */
#define IOCTL_1588_TICK_RATE_GET        IOH_1588_IOCTL(0x809)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_TARG_TIME_INTRPT_ENABLE
 * @brief Enable the target time reached/exceeded interrupt on IEEE 1588 module
 */
#define IOCTL_1588_TARG_TIME_INTRPT_ENABLE  IOH_1588_IOCTL(0x80A)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_TARG_TIME_INTRPT_DISABLE
 * @brief Disable the target time reached/exceeded interrupt on IEEE 1588 module
 */
#define IOCTL_1588_TARG_TIME_INTRPT_DISABLE     IOH_1588_IOCTL(0x80B)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_TARG_TIME_POLL
 * @brief Poll for the target time reached/exceeded condition on IEEE 1588 module
 */
#define IOCTL_1588_TARG_TIME_POLL           IOH_1588_IOCTL(0x80C)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_TARG_TIME_SET
 * @brief Set the target time to match on IEEE 1588 module
 */
#define IOCTL_1588_TARG_TIME_SET            IOH_1588_IOCTL(0x80D)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_TARG_TIME_GET
 * @brief Get the target time currently set on IEEE 1588 module
 */
#define IOCTL_1588_TARG_TIME_GET            IOH_1588_IOCTL(0x80E)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TIME_INTRPT_ENABLE
 * @brief Enable the auxiliary time captured interrupt on IEEE 1588 module
 */
#define IOCTL_1588_AUX_TIME_INTRPT_ENABLE   IOH_1588_IOCTL(0x80F)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TIME_INTRPT_DISABLE
 * @brief Disable the auxiliary time captured interrupt on IEEE 1588 module
 */
#define IOCTL_1588_AUX_TIME_INTRPT_DISABLE  IOH_1588_IOCTL(0x810)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TIME_POLL
 * @brief Poll for the auxiliary time captured on IEEE 1588 module
 */
#define IOCTL_1588_AUX_TIME_POLL            IOH_1588_IOCTL(0x811)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_RESET
 * @brief Reset the IEEE 1588 module
 */
#define IOCTL_1588_RESET                    IOH_1588_IOCTL(0x812)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_CHNL_RESET
 * @brief Reset the IEEE 1588 channel
 */
#define IOCTL_1588_CHNL_RESET               IOH_1588_IOCTL(0x813)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_STATS_GET
 * @brief Get the timestamp captured counters from the IEEE 1588 module
 */
#define IOCTL_1588_STATS_GET                IOH_1588_IOCTL(0x814)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_STATS_RESET
 * @brief Reset the timestamp captured counters maintained for IEEE 1588 module
 */
#define IOCTL_1588_STATS_RESET              IOH_1588_IOCTL(0x815)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_SHOW_ALL
 * @brief Display the register contents of IEEE 1588 module
 */
#define IOCTL_1588_SHOW_ALL                 IOH_1588_IOCTL(0x816)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TARG_TIME_INTRPT_ENABLE
 * @brief Enable Auxiliary target time reached interrupt - not supported
 */
#define IOCTL_1588_AUX_TARG_TIME_INTRPT_ENABLE  IOH_1588_IOCTL(0x817)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TARG_TIME_INTRPT_DISABLE
 * @brief Disable Auxiliary target time reached interrupt - not supported
 */
#define IOCTL_1588_AUX_TARG_TIME_INTRPT_DISABLE  IOH_1588_IOCTL(0x818)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TARG_TIME_POLL
 * @brief Poll for Auxiliary target time captured - not supported
 */
#define IOCTL_1588_AUX_TARG_TIME_POLL           IOH_1588_IOCTL(0x819)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TARG_TIME_SET
 * @brief Set Auxiliary target time - not supported
 */
#define IOCTL_1588_AUX_TARG_TIME_SET            IOH_1588_IOCTL(0x81A)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TARG_TIME_GET
 * @brief Get Auxiliary target time currently set - not supported
 */
#define IOCTL_1588_AUX_TARG_TIME_GET            IOH_1588_IOCTL(0x81B)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PULSE_PER_SEC_INTRPT_ENABLE
 * @brief Enable Pulse per second match interrupt
 */
#define IOCTL_1588_PULSE_PER_SEC_INTRPT_ENABLE  IOH_1588_IOCTL(0x81C)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PULSE_PER_SEC_INTRPT_DISABLE
 * @brief Disable Pulse per second match interrupt
 */
#define IOCTL_1588_PULSE_PER_SEC_INTRPT_DISABLE IOH_1588_IOCTL(0x81D)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_TARG_TIME_NOTIFY
 * @brief Block till a target time reached interrupt occurs
 */
#define IOCTL_1588_TARG_TIME_NOTIFY             IOH_1588_IOCTL(0x81E)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TIME_NOTIFY
 * @brief Block till an auxiliary time captured interrupt occurs
 */
#define IOCTL_1588_AUX_TIME_NOTIFY              IOH_1588_IOCTL(0x81F)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TARG_TIME_NOTIFY
 * @brief Block till an auxiliary target time reached interrupt occurs - not supported
 */
#define IOCTL_1588_AUX_TARG_TIME_NOTIFY         IOH_1588_IOCTL(0x820)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PULSE_PER_SEC_NOTIFY
 * @brief Block till a pulse per second match interrupt occurs
 */
#define IOCTL_1588_PULSE_PER_SEC_NOTIFY         IOH_1588_IOCTL(0x821)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_TARG_TIME_CLR_NOTIFY
 * @brief Unblock a process waiting on target time reached interrupt
 */
#define IOCTL_1588_TARG_TIME_CLR_NOTIFY         IOH_1588_IOCTL(0x822)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TIME_CLR_NOTIFY
 * @brief Unblock a process waiting on auxiliary time captured interrupt
 */
#define IOCTL_1588_AUX_TIME_CLR_NOTIFY          IOH_1588_IOCTL(0x823)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_AUX_TARG_TIME_CLR_NOTIFY
 * @brief Unblock a process waiting on an auxiliary target time reached interrupt - not supported
 */
#define IOCTL_1588_AUX_TARG_TIME_CLR_NOTIFY     IOH_1588_IOCTL(0x824)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PULSE_PER_SEC_CLR_NOTIFY
 * @brief Unblock a process waiting on a pulse per second match interrupt
 */
#define IOCTL_1588_PULSE_PER_SEC_CLR_NOTIFY     IOH_1588_IOCTL(0x825)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PULSE_PER_SEC_TIME_GET
 * @brief Get the currently specified pulse per second match time
 */
#define IOCTL_1588_PULSE_PER_SEC_TIME_GET       IOH_1588_IOCTL(0x826)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PULSE_PER_SEC_TIME_SET
 * @brief Specify the pulse per second match time
 */
#define IOCTL_1588_PULSE_PER_SEC_TIME_SET       IOH_1588_IOCTL(0x827)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PORT_VERSION_SET
 * @brief Set the PTP version to be used on the given PTP channel
 */
#define IOCTL_1588_PORT_VERSION_SET             IOH_1588_IOCTL(0x828)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PORT_VERSION_GET
 * @brief Get the PTP version used on the given PTP channel
 */
#define IOCTL_1588_PORT_VERSION_GET             IOH_1588_IOCTL(0x829)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PORT_OPERATION_MODE_SET
 * @brief Set the PTP messages that are matched by the module on the given PTP channel
 */
#define IOCTL_1588_PORT_OPERATION_MODE_SET      IOH_1588_IOCTL(0x82A)

/*! @ingroup InterfaceLayer
 * @def IOCTL_1588_PORT_OPERATION_MODE_GET
 * @brief Get the PTP messages that are currently matched by the module on given PTP channel
 */
#define IOCTL_1588_PORT_OPERATION_MODE_GET      IOH_1588_IOCTL(0x82B)

#endif


