/**
* @file ioh_can_common.h
*
* @author Wipro Technologies 
* @date 3 July 2009
*
* @brief Can common file used both by application and driver
*
* 
*
* 
 * @par
 * IOH_Windows Driver Release version 1.0 
 * 
 * -- Copyright Notice --
 * 
 * @par
 * Copyright (C) 2009-2012 LAPIS SEMICONDUCTOR Co., LTD.
 * All rights reserved.
 * 
 * @par
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the LAPIS SEMICONDUCTOR  nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * 
 * @par
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * 
 * @par
 * -- End of Copyright Notice --
*/

#ifndef __IOH_CAN_COMMON_H__
#define __IOH_CAN_COMMON_H__

/**
 * @ingroup InterfaceLayer
 * @define  GUID_DEVINTERFACE_IOHCAN
 * @brief Guid Device Inteface used from the user application to control the device
 */
DEFINE_GUID(GUID_DEVINTERFACE_IOHCAN, 
0x875d7e44, 0x2133, 0x45bd, 0x88, 0xf1, 0x31, 0xb4, 0xc, 0x1b, 0xcf, 0x60);



/*!	@ingroup	HALLayer
	@def		MAX_MSG_OBJ
	@brief		The maximum number of message objects available.

	<hr>
*/
#define MAX_MSG_OBJ 			(32)

#define IOH_CAN_MSG_DATA_LEN			(8)		/* CAN Msg data length */
/*!	@ingroup	HALLayer
@def		IOH_CAN_BIT_MASK
@brief	Used to do the bit masking	

<hr>
*/
#define IOH_CAN_BIT_MASK		(1)
/*! @ingroup	HALLayer
/*! @ingroup	InterfaceLayer
	@struct		ioh_can_msg	
	@brief		This type defines a CAN messages.
	@note
	@see
*/
typedef struct ioh_can_msg 
{
	unsigned short ide;							/* Standard/extended msg                     */
	unsigned int id;							/* 11 or 29 bit msg id                       */
	unsigned short dlc;							/* Size of data                              */
	unsigned char data[IOH_CAN_MSG_DATA_LEN];	/* Message pay load                          */
	unsigned short rtr;							/* Remote Transmission Request (RTR) message */
} ioh_can_msg_t;

/*! @ingroup	InterfaceLayer
	@struct		ioh_can_timing
	@brief		This type defines the parameters that define the CAN timing.
	@note
	@see
*/
typedef struct ioh_can_timing 
{
	unsigned int bitrate;						/* Bitrate (kbps)                    */
	unsigned int cfg_bitrate;					/* Baud rate prescaler               */
	unsigned int cfg_tseg1;						/* Timing segment 1                  */
	unsigned int cfg_tseg2;						/* Timing segment 2                  */
	unsigned int cfg_sjw;						/* Sync jump width                   */
	unsigned int smpl_mode;						/* Sampling mode                     */
	unsigned int edge_mode;						/* Edge Recessive (R) / Dominant (D) */
} ioh_can_timing_t;

/*! @ingroup	InterfaceLayer
	@struct		ioh_can_error
	@brief		This type defines a CAN error stats.
	@note
	@see
*/
typedef struct ioh_can_error 
{
	unsigned int rxgte96;						/* Rx error cnt >=96       */
	unsigned int txgte96;						/* Tx error cnt >=96       */
	unsigned int error_stat;					/* Error state of CAN node 
												   00=error active (normal)
												   01=error passive        
												   1x=bus off              */
	unsigned int rx_err_cnt;					/* Rx counter              */
	unsigned int tx_err_cnt;					/* Tx counter              */
} ioh_can_error_t;

/*! @ingroup	InterfaceLayer
	@struct		ioh_can_acc_filter
	@brief		This structure contains the filter information.
	@note
	@see
*/
typedef struct ioh_can_acc_filter 
{
	unsigned int id;							/* Identifier value      */
	unsigned int id_ext;						/* Standard/extended ID? */
	unsigned int rtr;							/* RTR message           */
} ioh_can_acc_filter_t;

/*! @ingroup	InterfaceLayer
	@struct		ioh_can_rx_filter
	@brief		This structures describes the ACR and AMR filter for an Rx buffer.
	@note
	@see
*/
typedef struct ioh_can_rx_filter 
{
	unsigned int num;					/* Message Object Number                               */
	unsigned int umask;					/* UMask value                                         */
	ioh_can_acc_filter_t amr;			/* Mask value for receive message object register      */
	ioh_can_acc_filter_t aidr;			/* Message Identifier value for receive message object */
} ioh_can_rx_filter_t;

/*! @ingroup	InterfaceLayer
	@enum		ioh_can_listen_mode_t
	@brief		Idententies the valid values for the Active/Listen mode.
	@note
	@see
*/
typedef enum 
{
	IOH_CAN_ACTIVE = 0,							/* R/w to/from the CAN    */
	IOH_CAN_LISTEN								/* Only read from the CAN */
} ioh_can_listen_mode_t;

/*! @ingroup	InterfaceLayer
	@enum		ioh_can_run_mode_t
	@brief		Identifies the valid values for the Run/Stop mode.
	@note
	@see
*/
typedef enum 
{
	IOH_CAN_STOP = 0,							/* CAN stopped */
	IOH_CAN_RUN									/* CAN running */
} ioh_can_run_mode_t;

/*! @ingroup	InterfaceLayer
	@enum		ioh_can_arbiter_t
	@brief		Identifies the valid values for the arbitration mode.
	@note
	@see
*/
typedef enum 
{
	IOH_CAN_ROUND_ROBIN = 0,					/* Equal priority              */
	IOH_CAN_FIXED_PRIORITY						/* Message Object num priority */
} ioh_can_arbiter_t;

/*! @ingroup	InterfaceLayer
	@enum		ioh_can_auto_restart_t
	@brief		Identifies the valid values for the auto-restart mode.
	@note
	@see
*/
typedef enum 
{
	CAN_MANUAL = 0,								/* Manual restart    */
	CAN_AUTO									/* Automatic restart */
} ioh_can_auto_restart_t;
 
/*! @ingroup	InterfaceLayer
	@enum		ioh_can_baud_t
	@brief		Identifies common baudrates.
	@note
	@see
*/
typedef enum 
{
	IOH_CAN_BAUD_10 = 0,						/* 10   kbps */
	IOH_CAN_BAUD_20,							/* 20   kbps */
	IOH_CAN_BAUD_50,							/* 50   kbps */
	IOH_CAN_BAUD_125,							/* 125  kbps */
	IOH_CAN_BAUD_250,							/* 250  kbps */
	IOH_CAN_BAUD_500,							/* 500  kbps */
	IOH_CAN_BAUD_800,							/* 800  kbps */
	IOH_CAN_BAUD_1000							/* 1000 kbps */
} ioh_can_baud_t;

/*! @ingroup	InterfaceLayer
	@enum		ioh_can_interrupt_t
	@brief		Identifies interrupt enables/disables.
	@note
	@see
*/
typedef enum 
{
	CAN_ENABLE,									/* Enable bit only  */
	CAN_DISABLE,								/* Disable bit only */
	CAN_ALL,									/* All interrupts   */
	CAN_NONE									/* No interrupt     */
} ioh_can_interrupt_t;

/*! @ingroup	InterfaceLayer
	@enum		ioh_can_filter_mode_t
	@brief		Identifies the valid values for the filter mode.
	@note
	@see
*/
typedef enum 
{
	IOH_CAN_FILTER_NORMAL = 0,					/* Normal mode  */
	IOH_CAN_FILTER_ADVANCED						/* Advanced mode*/
} ioh_can_filter_mode_t;

#define IOH_CAN_SUCCESS 					( 0)		/* CAN success return value. */
#define IOH_CAN_FAIL 						(-1)	    /* CAN failure return value. */
#define IOH_CAN_EINVAL                    (-2)   /*CAN-Invalid parameters*/ 

#endif
