#ifndef __IOH_CAN_IOCTL_H__
#define __IOH_CAN_IOCTL_H__
/**
* @file ioh_can_ioctl.h
*
* @author Wipro Technologies 
* @date 17 July 2009
*
* @brief Can IOCLTS defined 
*
* This file contains the various ioctls supported by can driver 
*
*
* 
 * @par
 * IOH_Windows Driver Release version 1.0 
 * 
 * -- Copyright Notice --
 * 
 * @par
 * Copyright (C) 2009-2012 LAPIS SEMICONDUCTOR Co., LTD.
 * All rights reserved.
 * 
 * @par
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the LAPIS SEMICONDUCTOR  nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * 
 * @par
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * 
 * @par
 * -- End of Copyright Notice --
*/

/*
Define the IOCTL codes we will use.  The IOCTL code contains a command
identifier, plus other information about the device, the type of access
with which the file must have been opened, and the type of buffering.


The IOCTL function codes from 0x800 to 0xFFF are for customer use.*/

/*! @ingroup InterfaceLayer
  @def DEV_TYPE
  @brief Outlines the Device Type
  */
#define DEV_TYPE 40002
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_RESET
  @brief Outlines the ioclt IOCTL_CAN_RESET
  */
#define IOCTL_CAN_RESET \
    (CTL_CODE( DEV_TYPE, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_RUN
  @brief Outlines the ioctl IOCTL_CAN_RUN
  */    
#define IOCTL_CAN_RUN \
    (CTL_CODE( DEV_TYPE, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_STOP
  @brief Outlines the ioctl IOCTL_CAN_STOP
  */    
#define IOCTL_CAN_STOP \
    (CTL_CODE( DEV_TYPE, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_RUN_GET
  @brief Outlines the ioctl IOCTL_CAN_RUN_GET
  */
#define IOCTL_CAN_RUN_GET \
    (CTL_CODE( DEV_TYPE, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_FILTER
  @brief Outlines the ioctl IOCTL_CAN_FILTER
  */
#define IOCTL_CAN_FILTER \
    (CTL_CODE( DEV_TYPE, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_FILTER_GET
  @brief Outlines the ioctl IOCTL_CAN_FILTER_GET
  */
#define IOCTL_CAN_FILTER_GET \
    (CTL_CODE( DEV_TYPE, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_CUSTOM
  @brief Outlines the ioctl IOCTL_CAN_CUSTOM
  */	
#define IOCTL_CAN_CUSTOM \
    (CTL_CODE( DEV_TYPE, 0x806, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_SIMPLE
  @brief Outlines the ioctl IOCTL_CAN_SIMPLE
  */    
#define IOCTL_CAN_SIMPLE \
    (CTL_CODE( DEV_TYPE, 0x807, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_TIMING_GET
  @brief Outlines the ioctl IOCTL_CAN_TIMING_GET
  */    
#define IOCTL_CAN_TIMING_GET \
    (CTL_CODE( DEV_TYPE, 0x808, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_BLOCK
  @brief Outlines the ioctl IOCTL_CAN_BLOCK
  */    
#define IOCTL_CAN_BLOCK \
    (CTL_CODE( DEV_TYPE, 0x809, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_NON_BLOCK
  @brief Outlines the ioctl IOCTL_CAN_NON_BLOCK
  */    
#define IOCTL_CAN_NON_BLOCK \
    (CTL_CODE( DEV_TYPE, 0x80A, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_BLOCK_GET
  @brief Outlines the ioctl IOCTL_CAN_BLOCK_GET
  */    
#define IOCTL_CAN_BLOCK_GET \
    (CTL_CODE( DEV_TYPE, 0x80B, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_LISTEN
  @brief Outlines the ioctl IOCTL_CAN_LISTEN
  */    
#define IOCTL_CAN_LISTEN \
    (CTL_CODE( DEV_TYPE, 0x80C, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_ACTIVE
  @brief Outlines the ioctl IOCTL_CAN_ACTIVE
  */    
#define IOCTL_CAN_ACTIVE \
    (CTL_CODE( DEV_TYPE, 0x80D, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_LISTEN_GET
  @brief Outlines the ioctl IOCTL_CAN_LISTEN_GET
  */    
#define IOCTL_CAN_LISTEN_GET \
    (CTL_CODE( DEV_TYPE, 0x80E, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_ARBITER_ROUND_ROBIN
  @brief Outlines the ioctl IOCTL_CAN_ARBITER_ROUND_ROBIN
  */    
#define IOCTL_CAN_ARBITER_ROUND_ROBIN \
    (CTL_CODE( DEV_TYPE, 0x810, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_ARBITER_FIXED_PRIORITY
  @brief Outlines the ioctl IOCTL_CAN_ARBITER_FIXED_PRIORITY
  */    
#define IOCTL_CAN_ARBITER_FIXED_PRIORITY \
    (CTL_CODE( DEV_TYPE, 0x811, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_ARBITER_GET
  @brief Outlines the ioctl IOCTL_CAN_ARBITER_GET
  */    
#define IOCTL_CAN_ARBITER_GET \
    (CTL_CODE( DEV_TYPE, 0x812, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_ERROR_STATS_GET
  @brief Outlines the ioctl IOCTL_CAN_ERROR_STATS_GET
  */    
#define IOCTL_CAN_ERROR_STATS_GET \
    (CTL_CODE( DEV_TYPE, 0x813, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_BUFFER_LINK_SET
  @brief Outlines the ioctl IOCTL_CAN_BUFFER_LINK_SET
  */    
#define IOCTL_CAN_BUFFER_LINK_SET \
    (CTL_CODE( DEV_TYPE, 0x814, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_BUFFER_LINK_CLEAR
  @brief Outlines the ioctl IOCTL_CAN_BUFFER_LINK_CLEAR
  */    
#define IOCTL_CAN_BUFFER_LINK_CLEAR \
    (CTL_CODE( DEV_TYPE, 0x815, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_BUFFER_LINK_GET
  @brief Outlines the ioctl IOCTL_CAN_BUFFER_LINK_GET
  */    
#define IOCTL_CAN_BUFFER_LINK_GET \
    (CTL_CODE( DEV_TYPE, 0x816, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_RX_ENABLE_SET
  @brief Outlines the ioctl IOCTL_CAN_RX_ENABLE_SET
  */    
#define IOCTL_CAN_RX_ENABLE_SET \
    (CTL_CODE( DEV_TYPE, 0x817, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_RX_ENABLE_CLEAR
  @brief Outlines the ioctl IOCTL_CAN_RX_ENABLE_CLEAR
  */    
#define IOCTL_CAN_RX_ENABLE_CLEAR \
    (CTL_CODE( DEV_TYPE, 0x818, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_RX_ENABLE_GET
  @brief Outlines the ioctl IOCTL_CAN_RX_ENABLE_GET
  */    
#define IOCTL_CAN_RX_ENABLE_GET \
    (CTL_CODE( DEV_TYPE, 0x819, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_TX_ENABLE_SET
  @brief Outlines the ioctl IOCTL_CAN_TX_ENABLE_SET
  */    
#define IOCTL_CAN_TX_ENABLE_SET \
    (CTL_CODE( DEV_TYPE, 0x81A, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_TX_ENABLE_CLEAR
  @brief Outlines the ioctl IOCTL_CAN_TX_ENABLE_CLEAR
  */    
#define IOCTL_CAN_TX_ENABLE_CLEAR \
    (CTL_CODE( DEV_TYPE, 0x81B, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_TX_ENABLE_GET
  @brief Outlines the ioctl IOCTL_CAN_TX_ENABLE_GET
  */    
#define IOCTL_CAN_TX_ENABLE_GET \
    (CTL_CODE( DEV_TYPE, 0x81C, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_READ
  @brief Outlines the ioctl IOCTL_CAN_READ
  */    
#define IOCTL_CAN_READ \
    (CTL_CODE( DEV_TYPE, 0x81D, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_WRITE
  @brief Outlines the ioctl IOCTL_CAN_WRITE
  */    
#define IOCTL_CAN_WRITE \
    (CTL_CODE( DEV_TYPE, 0x81E, METHOD_BUFFERED, FILE_ANY_ACCESS ))

#define IOCTL_CAN_RESTART_MODE_AUTO \
    (CTL_CODE( DEV_TYPE, 0x81F, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_RESTART_MODE_MANUAL
  @brief Outlines the ioctl IOCTL_CAN_RESTART_MODE_MANUAL
  */    
#define IOCTL_CAN_RESTART_MODE_MANUAL \
    (CTL_CODE( DEV_TYPE, 0x820, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_RESTART_MODE_GET
  @brief Outlines the ioctl IOCTL_CAN_RESTART_MODE_GET
  */    
#define IOCTL_CAN_RESTART_MODE_GET \
    (CTL_CODE( DEV_TYPE, 0x821, METHOD_BUFFERED, FILE_ANY_ACCESS ))

/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_FILTER_MODE_NORMAL
  @brief Outlines the ioctl IOCTL_CAN_FILTER_MODE_NORMAL
  */    
#define IOCTL_CAN_FILTER_MODE_NORMAL \
    (CTL_CODE( DEV_TYPE, 0x822, METHOD_BUFFERED, FILE_ANY_ACCESS ))

/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_FILTER_MODE_ADVANCED
  @brief Outlines the ioctl IOCTL_CAN_FILTER_MODE_ADVANCED
  */    
#define IOCTL_CAN_FILTER_MODE_ADVANCED \
    (CTL_CODE( DEV_TYPE, 0x823, METHOD_BUFFERED, FILE_ANY_ACCESS ))

/*! @ingroup InterfaceLayer
  @def IOCTL_CAN_FILTER_MODE_GET
  @brief Outlines the ioctl IOCTL_CAN_FILTER_MODE_GET
  */    
#define IOCTL_CAN_FILTER_MODE_GET \
    (CTL_CODE( DEV_TYPE, 0x824, METHOD_BUFFERED, FILE_ANY_ACCESS ))

#endif
