/**
* @file ioh_dma_ioctl.h
*
* @author Wipro Technologies 
* @date 21 Aug 2009
*
* @brief IOCTLs supported by the dma driver
*
* This file contains the various driver loading related
*files
*
* 
 * @par
 * IOH_Windows Driver Release version 1.0 
 * 
 * -- Copyright Notice --
 * 
 * @par
 * Copyright (C) 2009-2012 LAPIS SEMICONDUCTOR Co., LTD.
 * All rights reserved.
 * 
 * @par
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the LAPIS SEMICONDUCTOR  nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * 
 * @par
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * 
 * @par
 * -- End of Copyright Notice --
*/
#ifndef __IOH_DMA_IOCTL_H__
#define __IOH_DMA_IOCTL_H__

/*
Define the IOCTL codes we will use.  The IOCTL code contains a command
identifier, plus other information about the device, the type of access
with which the file must have been opened, and the type of buffering.
The IOCTL function codes from 0x800 to 0xFFF are for customer use.*/

/*! @ingroup InterfaceLayer
  @def DEV_TYPE
  @brief Outlines the Device Type
  */
#define IOH_DMA_DEVICE_TYPE 40003

/*! @ingroup InterfaceLayer
  @def IOH_dma_IOCTL
  @brief Macro to define the IOCTLs
  */
#define IOH_DMA_IOCTL(_index_) \
    CTL_CODE ( IOH_DMA_DEVICE_TYPE, _index_, METHOD_BUFFERED, FILE_ANY_ACCESS)

/*! @ingroup InterfaceLayer
 * @def IOCTL_dma_PORT_CONFIG_SET
 * @brief Set the  dma Ethernet port to Mater/Slave/All mode
 */
//#define IOCTL_DMA_REQUEST_DMA      IOH_DMA_IOCTL(0x801)


#define IOCTL_DMA_REQUEST_DMA           IOH_DMA_IOCTL(0x801)

#define IOCTL_DMA_FREE_DMA              IOH_DMA_IOCTL(0x802)

#define IOCTL_DMA_SET_DMA               IOH_DMA_IOCTL(0x803)

#define IOCTL_DMA_ADD_DESCRIPTOR        IOH_DMA_IOCTL(0x804)

#define IOCTL_DMA_ENABLE_DMA            IOH_DMA_IOCTL(0x805)

#define IOCTL_DMA_DISABLE_DMA           IOH_DMA_IOCTL(0x806)

#define IOCTL_DMA_DIRECT_START          IOH_DMA_IOCTL(0x807)

#endif


