#ifndef __IOH_GPIO_COMMON_H__
#define __IOH_GPIO_COMMON_H__
/**
* @file ioh_gpio_common.h
*
* @author Wipro Technologies 
* @date 17 June 2009
*
* @brief Gpio common dtructures
*
* This file contains the various common structures
*
* 
 * @par
 * IOH_Windows Driver Release version 1.0 
 * 
 * -- Copyright Notice --
 * 
 * @par
 * Copyright (C) 2009-2012 LAPIS SEMICONDUCTOR Co., LTD.
 * All rights reserved.
 * 
 * @par
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the LAPIS SEMICONDUCTOR  nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * 
 * @par
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * 
 * @par
 * -- End of Copyright Notice --
*/
/**
 * @ingroup InterfaceLayer
 * @define  GUID_DEVINTEFACE_IOHGPIO
 * @brief Guid Device Inteface used from the user application to control the device
 */
DEFINE_GUID(GUID_DEVINTERFACE_IOHGPIO, 
0xd326ab9, 0x4298, 0x4394, 0x97, 0xe8, 0xb1, 0x9d, 0xff, 0xc4, 0x9, 0x58);


/*! @ingroup InterfaceLayer
  @def IOH_GPIO_ALL_PINS
  @brief Outlines specifies all pins
  */
#define IOH_GPIO_ALL_PINS  0x00000fff
 
/*! @ingroup HALLayer
  @enum _GPIO_SET_MODE
  @brief It is a enum used for perserving information related to the
  imode
  @note
  The concerned details should be provided  during the initialization mode,
  direction mode, read mode and write mode.
  @see
  ioh_gpio_int_mode
  ioh_gpio_dir_mode
  ioh_gpio_read
  ioh_gpio_write
  */
typedef enum _GPIO_SET_MODE
 {
    DISABLE_SEL,
    ENABLE_SEL,
    NEITHER
} GPIO_SET_MODE;
/*! @ingroup HALLayer
  @enum _GPIO_SET_DIR
  @brief It is a enum used for perserving information related to the
  direction
  @note
  The concerned details should be provided  during the initialization mode,
  direction mode, read mode and write mode.
  @see
  ioh_gpio_int_mode
  ioh_gpio_dir_mode
  ioh_gpio_read
  ioh_gpio_write
  */
typedef enum _GPIO_SET_DIR 
{
    INPUT_SEL,
    OUTPUT_SEL,
    NEITHER_
} GPIO_SET_DIR;

/*! @ingroup HALLayer
  @enum _GPIO_SET_VALUE
  @brief It is a enum used for perserving information related to the
  direction
  @note
  The concerned details should be provided  during the initialization mode,
  direction mode, read mode and write mode.
  @see
  ioh_gpio_int_mode
  ioh_gpio_dir_mode
  ioh_gpio_read
  ioh_gpio_write
  */
typedef enum _GPIO_SET_VALUE 
{
    GPIO_LOW,
    GPIO_HIGH
} GPIO_SET_VALUE;

/*! @ingroup HALLayer
  @struct ioh_gpio_reqt
  @brief It is a structure used for perserving information related to the
  gpio request.
  @note
  The concerned details should be provided  during the initialization mode,
  direction mode, read mode and write mode.
  @see
  ioh_gpio_int_mode
  ioh_gpio_dir_mode
  ioh_gpio_read
  ioh_gpio_write
  */
typedef struct _ioh_gpio_reqt
{
    ULONG port;/*set the port number*/
    ULONG pins;/*Data in the case of read and write
                       and other cases it indicates applicable pins*/ 
    UINT64 mode; /* Set the interrupt mode and direction mode */ //change to support 12 pins
    ULONG enable;/*1 for enable the interrupt and 0 for disable
                         the interrupt*/
} ioh_gpio_reqt, *pioh_gpio_reqt;
#endif