#ifndef __IOH_GPIO_IOCTL_H__
#define __IOH_GPIO_IOCTL_H__
/**
* @file ioh_gpio_ioctl.h
*
* @author Wipro Technologies 
* @date 17 June 2009
*
* @brief Gpio ioctls 
*
* This file contains the various ioclts supported by gpio
*
*
* 
 * @par
 * IOH_Windows Driver Release version 1.0 
 * 
 * -- Copyright Notice --
 * 
 * @par
 * Copyright (C) 2009-2012 LAPIS SEMICONDUCTOR Co., LTD.
 * All rights reserved.
 * 
 * @par
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the LAPIS SEMICONDUCTOR  nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * 
 * @par
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * 
 * @par
 * -- End of Copyright Notice --
*/


/*
Define the IOCTL codes we will use.  The IOCTL code contains a command
identifier, plus other information about the device, the type of access
with which the file must have been opened, and the type of buffering.


The IOCTL function codes from 0x800 to 0xFFF are for customer use.*/

/*! @ingroup InterfaceLayer
  @def IOH_GPIO_DEV_TYPE
  @brief Outlines the Device Type
  */
#define IOH_GPIO_DEV_TYPE 40000
/*! @ingroup InterfaceLayer
  @def IOCTL_GPIO_INT_ENABLE
  @brief Outlines the ioclt IOCTL_GPIO_INT_ENABLE
  */
#define IOCTL_GPIO_INT_ENABLE \
    (CTL_CODE( IOH_GPIO_DEV_TYPE, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_GPIO_INT_DISABLE
  @brief Outlines the ioctl IOCTL_GPIO_INT_DISABLE
  */    
#define IOCTL_GPIO_INT_DISABLE \
    (CTL_CODE( IOH_GPIO_DEV_TYPE, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_GPIO_DIRECTION
  @brief Outlines the ioctl IOCTL_GPIO_DIRECTION
  */    
#define IOCTL_GPIO_DIRECTION \
    (CTL_CODE( IOH_GPIO_DEV_TYPE, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_GPIO_WRITE
  @brief Outlines the ioctl IOCTL_GPIO_WRITE
  */
#define IOCTL_GPIO_WRITE \
    (CTL_CODE( IOH_GPIO_DEV_TYPE, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_GPIO_READ
  @brief Outlines the ioctl IOCTL_GPIO_READ
  */
#define IOCTL_GPIO_READ \
    (CTL_CODE( IOH_GPIO_DEV_TYPE, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_GPIO_NOTIFY
  @brief Outlines the ioctl IOCTL_GPIO_NOTIFY
  */
#define IOCTL_GPIO_NOTIFY \
    (CTL_CODE( IOH_GPIO_DEV_TYPE, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS ))

#endif


