/**
* @file ioh_i2c_common.h
*
* @author Wipro Technologies 
* @date 3 July 2009
*
* @brief I2c common file used both by application and driver
*
* This file contains the various driver loading related
*files
*
* 
 * @par
 * IOH_Windows Driver Release version 1.0 
 * 
 * -- Copyright Notice --
 * 
 * @par
 * Copyright (C) 2009-2012 LAPIS SEMICONDUCTOR Co., LTD.
 * All rights reserved.
 * 
 * @par
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the LAPIS SEMICONDUCTOR  nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * 
 * @par
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * 
 * @par
 * -- End of Copyright Notice --
*/

#ifndef __IOH_I2C_COMMON_H__
#define __IOH_I2C_COMMON_H__

/**
 * @ingroup InterfaceLayer
 * @define  GUID_DEVINTERFACE_I2C
 * @brief Guid Device Inteface used from the user application to control the device
 */
DEFINE_GUID(GUID_DEVINTERFACE_IOHI2C, 
0xc2bfdb60, 0x8992, 0x4862, 0x84, 0xfa, 0x34, 0x26, 0x90, 0x5c, 0xee, 0x5b);


#define I2C_M_TEN				0x0010	/*his is a ten bit chip address*/
#define I2C_M_RD				0x1000	/*read data, from slave to master*/
#define I2C_M_WR				0x0008
#define IOH_NORMAL_MODE_ENABLE	0x0000	/*flag for normal mode enable*/
#define IOH_BUFFER_MODE_ENABLE	0x0001	/*flag for buffer mode enable*/
#define IOH_EEPROM_SW_RST_MODE_ENABLE	0x0100	/*flag for EEPROM SW RST enable*/
#define I2C_M_RECV_LEN				0x0400	/*length will be first received byte*/

/*! @ingroup InterfaceLayer
  @struct _I2C_MSG
  @brief This is the input message structure 
  @note This is the input message structure 
  @see
ioh_i2c_xfer
  */
typedef struct _I2C_MSG 
{
	ULONG SlaveAddress;	/*slave address*/
	ULONG Flags;
	ULONG   MsgLength;
	PUCHAR  MsgData;
}IOH_I2C_MSG, *PIOH_I2C_MSG;

/*! @ingroup InterfaceLayer
  @struct I2C_COMPOUND_DATA
  @brief This is the input  compound mode message structure 
  @note This is the input message structure 
  @see
ioh_i2c_xfer
  */
typedef struct I2C_COMPOUND_DATA 
{
	PIOH_I2C_MSG msgs;
	ULONG dwNumMsgs;
}IOH_I2C_COMPOUND_DATA, *PIOH_I2C_COMPOUND_DATA;

/*! @ingroup InterfaceLayer
  @def I2C_COMPOUND_RDWR_MAX_MSG_LENGTH
  @brief Maximum compound messages
  */
#define I2C_COMPOUND_RDWR_MAX_MSG_LENGTH 		8192
/*! @ingroup InterfaceLayer
  @def I2C_COMPOUND_RDWR_MAX_MSGS
  @brief Maximum compound messages
  */
#define I2C_COMPOUND_RDWR_MAX_MSGS 		42
#define EEPROM_RST_PATTERN1                 2
#define EEPROM_RST_PATTERN2                 3
#define EEPROM_RST_PATTERN3                 4
/*! @ingroup InterfaceLayer
  @def IOH_I2C_SUCCESS
  @brief Success
  */
#define IOH_I2C_SUCCESS 					( 0)		/* I2C success return value. */
/*! @ingroup InterfaceLayer
  @def IOH_I2C_FAIL
  @brief Failure mode
  */
#define IOH_I2C_FAIL 						(-1)	    /* I2C failure return value. */
/*! @ingroup InterfaceLayer
  @def IOH_I2C_EINVAL
  @brief Invalid input mode
  */
#define IOH_I2C_EINVAL                    (-2)   /*I2C-Invalid parameters*/ 

/*! @ingroup InterfaceLayer
  @def IOH_I2C_CONST
  @brief Invalid input mode
  */
#define IOH_I2C_CONST                    (0xff)    

/*! @ingroup InterfaceLayer
  @def IOH_I2C_SHIFT_7
  @brief sHIFT BY 7 BITS
  */
#define IOH_I2C_SHIFT_7                    (7)   
/*! @ingroup InterfaceLayer
  @def IOH_I2C_SHIFT_2
  @brief sHIFT BY 2 BITS
  */
#define IOH_I2C_SHIFT_2                    (2)  
/*! @ingroup InterfaceLayer
  @def IOH_I2C_SHIFT_1
  @brief sHIFT BY 1 BITS
  */
#define IOH_I2C_SHIFT_1                    (1) 
/*! @ingroup InterfaceLayer
  @def IOH_I2C_SHIFT_4
  @brief sHIFT BY 4 BITS
  */
#define IOH_I2C_SHIFT_4                    (4) 
/*! @ingroup InterfaceLayer
  @def IOH_I2C_MAX_TIME_INTERVAL
  @brief maximum time interval
  */
#define IOH_I2C_MAX_TIME_INTERVAL          (10) 
/*! @ingroup InterfaceLayer
  @def IOH_I2C_PCLK_DIV
  @brief i2c timer div
  */
#define IOH_I2C_PCLK_DIV                    (8) 
/*! @ingroup InterfaceLayer
  @def IOH_I2C_SUBADDR_LEN
  @brief I2C SUBADDRE
  */
#define IOH_I2C_SUBADDR_LEN                  (2) 
/*! @ingroup InterfaceLayer
  @def IOH_I2C_PATTERN
  @brief IOH_I2C_PATTERN
  */
#define IOH_I2C_PATTERN                 	 (2) 
#endif
