#ifndef __IOH_I2C_IOCTL_H__
#define __IOH_I2C_IOCTL_H__
/**
* @file ioh_i2c_ioctl.h
*
* @author Wipro Technologies 
* @date 17 July 2009
*
* @brief I2c ioctl defined 
*
* This file contains the various ioclts supported by i2c
*
*
* 
 * @par
 * IOH_Windows Driver Release version 1.0 
 * 
 * -- Copyright Notice --
 * 
 * @par
 * Copyright (C) 2009-2012 LAPIS SEMICONDUCTOR Co., LTD.
 * All rights reserved.
 * 
 * @par
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the LAPIS SEMICONDUCTOR  nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * 
 * @par
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * 
 * @par
 * -- End of Copyright Notice --
*/

/*
Define the IOCTL codes we will use.  The IOCTL code contains a command
identifier, plus other information about the device, the type of access
with which the file must have been opened, and the type of buffering.


The IOCTL function codes from 0x800 to 0xFFF are for customer use.*/

/*! @ingroup InterfaceLayer
  @def IOH_I2C_DEV_TYPE
  @brief Outlines the Device Type
  */
#define IOH_I2C_DEV_TYPE 40002
/*! @ingroup InterfaceLayer
  @def IOCTL_I2C_ENABLE_INT
  @brief Outlines the ioclt IOCTL_I2C_ENABLE_INT
  */
#define IOCTL_I2C_ENABLE_INT \
    (CTL_CODE( IOH_I2C_DEV_TYPE, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_I2C_DISABLE_INT
  @brief Outlines the ioctl IOCTL_I2C_DISABLE_INT
  */    
#define IOCTL_I2C_DISABLE_INT \
    (CTL_CODE( IOH_I2C_DEV_TYPE, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_I2C_CONFIG
  @brief Outlines the ioctl IOCTL_I2C_CONFIG
  */    
#define IOCTL_I2C_CONFIG \
    (CTL_CODE( IOH_I2C_DEV_TYPE, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_I2C_RESET
  @brief Outlines the ioctl IOCTL_I2C_RESET
  */
#define IOCTL_I2C_RESET \
    (CTL_CODE( IOH_I2C_DEV_TYPE, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_I2C_READ
  @brief Outlines the ioctl IOCTL_I2C_READ
  */
#define IOCTL_I2C_READ \
    (CTL_CODE( IOH_I2C_DEV_TYPE, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_I2C_WRITE
  @brief Outlines the ioctl IOCTL_I2C_WRITE
  */
#define IOCTL_I2C_WRITE \
    (CTL_CODE( IOH_I2C_DEV_TYPE, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS ))
/*! @ingroup InterfaceLayer
  @def IOCTL_I2C_COMPOUND_RDWR
  @brief Outlines the ioctl IOCTL_I2C_COMPOUND_RDWR
  */	
#define IOCTL_I2C_COMPOUND_RDWR \
    (CTL_CODE( IOH_I2C_DEV_TYPE, 0x806, METHOD_BUFFERED, FILE_ANY_ACCESS ))

#endif






















