/**
* @file ioh_pcieqos_common.h
*
* @author Wipro Technologies 
* @date 3 July 2009
*
* @brief pcieqos common file used both by application and driver
*
* 
*
* 
 * @par
 * IOH_Windows Driver Release version 1.0 
 * 
 * -- Copyright Notice --
 * 
 * @par
 * Copyright (C) 2009-2012 LAPIS SEMICONDUCTOR Co., LTD.
 * All rights reserved.
 * 
 * @par
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the LAPIS SEMICONDUCTOR  nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * 
 * @par
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * 
 * @par
 * -- End of Copyright Notice --
*/

#ifndef __IOH_PCIEQOS_COMMON_H__
#define __IOH_PCIEQOS_COMMON_H__

/**
 * @ingroup PCIEQOS_InterfaceLayer
 * @define  GUID_DEVINTEFACE_IOHPACKETHUB
 * @brief Guid Device Inteface used from the user application to control the device
 */
// {A2166D13-54FD-4173-8EE6-0E09E2E507B3}
DEFINE_GUID(GUID_DEVINTERFACE_IOHPACKETHUB, 
0xa2166d13, 0x54fd, 0x4173, 0x8e, 0xe6, 0xe, 0x9, 0xe2, 0xe5, 0x7, 0xb3);

#define IOH_PCIEQOS_EPROM_SIZE			(0X800)
#define IOH_PCIQOS_WRITE_PCI_CONFIG		(1)
#define IOH_PCIQOS_READ_PCI_CONFIG		(0)
#define IOH_PCIQOS_PCI_CONFIG_OFFSET_TO_RW		(0)
#define IOH_PCIEQOS_PHY_ADDRESS_ZERO	(0)
/*! @ingroup PCIEQOS_InterfaceLayer
  @struct ioh_pcieqos_reqt
  @brief It is a structure used for perserving information related to the
  pcieqos request.
  @note
  The concerned details should be provided during the read register,
   write register and read / modify / write register.
  @see
  ioh_pcieqos_ioctl
  */
typedef struct _ioh_pcieqos_reqt
  {
	unsigned long addr_offset;	/*specifies the register address offset*/
	unsigned long data;					/*specifies the data*/
	unsigned long mask;					/*specifies the mask*/
  } ioh_pcieqos_reqt, *pioh_pcieqos_reqt;
#define IOH_WRITE8(val,addr) WRITE_REGISTER_UCHAR((PUCHAR)addr,val)
#define IOH_WRITE16(val,addr) WRITE_REGISTER_USHORT((PUSHORT)addr,val)
#define IOH_WRITE32(val,addr)  WRITE_REGISTER_ULONG((PULONG)addr,val)

#define IOH_READ8(addr)   READ_REGISTER_UCHAR((PUCHAR)addr)
#define IOH_READ16(addr)  READ_REGISTER_USHORT((PUSHORT)addr)
#define IOH_READ32(addr)  READ_REGISTER_ULONG((PULONG)addr)

#define IOH_WRITE_BYTE IOH_WRITE8
#define IOH_WRITE_WORD IOH_WRITE16
#define IOH_WRITE_LONG IOH_WRITE32

#define IOH_READ_BYTE  IOH_READ8
#define IOH_READ_WORD  IOH_READ16
#define IOH_READ_LONG  IOH_READ32

/* Bit Manipulation Macros */

/* macro to set a specified bit(mask) at the specified address */
#define ioh_set_addr_bit(addr,bitmask) IOH_WRITE_WORD((IOH_READ_WORD(addr) | bitmask), addr)						\
 
/* macro to clear a specified bit(mask) at the specified address */
#define ioh_clr_addr_bit(addr,bitmask) IOH_WRITE_WORD((IOH_READ_WORD(addr) & ~(bitmask)), addr)

/* macro to set a specified bitmask for a variable */
#define ioh_set_bitmsk(var,bitmask ) ((var) |= (bitmask))

/* macro to clear a specified bitmask for a variable */
#define ioh_clr_bitmsk(var,bitmask ) ((var) &= (~bitmask))

/* macro to set a specified bit for a variable */
#define ioh_set_bit(var,bit) ((var) |= (1<<(bit)))

/* macro to clear a specified bit for a variable */
#define ioh_clr_bit(var,bit) ((var) &= ~(1<<(bit)))

#endif
