/**
* @file ioh_pcieqos_ioctl.h
*
* @author Wipro Technologies 
* @date 3 Jul 2009
*
* @brief PCIEQOS IOCTLs
*
* This file contains the various driver loading related
*files
*
* 
 * @par
 * IOH_Windows Driver Release version 1.0 
 * 
 * -- Copyright Notice --
 * 
 * @par
 * Copyright (C) 2009-2012 LAPIS SEMICONDUCTOR Co., LTD.
 * All rights reserved.
 * 
 * @par
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the LAPIS SEMICONDUCTOR  nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * 
 * @par
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * 
 * @par
 * -- End of Copyright Notice --
*/
#ifndef __IOH_PCIEQOS_IOCTL_H__
#define __IOH_PCIEQOS_IOCTL_H__

/*
Define the IOCTL codes we will use.  The IOCTL code contains a command
identifier, plus other information about the device, the type of access
with which the file must have been opened, and the type of buffering.
The IOCTL function codes from 0x800 to 0xFFF are for customer use.*/

/*! @ingroup InterfaceLayer
  @def DEV_TYPE
  @brief Outlines the Device Type
  */
#define IOH_PCIEQOS_DEVICE_TYPE 40004

/*! @ingroup InterfaceLayer
  @def IOH_PCIEQOS_IOCTL
  @brief Macro to define the IOCTLs
  */
#define IOH_PCIEQOS_IOCTL(_index_) \
    CTL_CODE ( IOH_PCIEQOS_DEVICE_TYPE, _index_, METHOD_BUFFERED, FILE_ANY_ACCESS)

/*! @ingroup InterfaceLayer
  @def IOCTL_PCIEQOS_CONFIG
  @brief IOCTLs to configure the PCIEQOS controller
  @see IOH_PCIEQOS_CONFIG
  */
#define IOCTL_PCIEQOS_READ_REG                IOH_PCIEQOS_IOCTL (0x800)

/*! @ingroup InterfaceLayer
  @def IOCTL_PCIEQOS_ENABLE_INT
  @brief IOCTL to enable PCIEQOS interrupts
  */
#define IOCTL_PCIEQOS_WRITE_REG            IOH_PCIEQOS_IOCTL (0x801)

/*! @ingroup InterfaceLayer
  @def IOCTL_PCIEQOS_DISABLE_INT
  @brief IOCTL to disable PCIEQOS interrupts
  */
#define IOCTL_PCIEQOS_READ_MODIFY_WRITE_REG           IOH_PCIEQOS_IOCTL (0x802)

/*! @ingroup InterfaceLayer
  @def IOCTL_PCIEQOS_READ
  @brief IOCTLs for PCIEQOS read operation
  @see IOH_PCIEQOS_RW
  */
#define IOCTL_PCIEQOS_READ_OROM                  IOH_PCIEQOS_IOCTL (0x803)

/*! @ingroup InterfaceLayer
  @def IOCTL_PCIEQOS_WRITE
  @brief IOCTL for PCIEQOS write operation
  @see IOH_PCIEQOS_RW
  */
#define IOCTL_PCIEQOS_WRITE_OROM                 IOH_PCIEQOS_IOCTL (0x804)
    
/*! @ingroup InterfaceLayer
  @def IOCTL_PCIEQOS_GET_CONFIG
  @brief IOCTL to get current configuration details
  @see IOH_PCIEQOS_CONFIG
  @note this is an undocumented IOCTL
  */
#define IOCTL_PCIEQOS_READ_MAC_ADDR            IOH_PCIEQOS_IOCTL(0x805)
/*! @ingroup InterfaceLayer
  @def IOCTL_PCIEQOS_WRITE_MAC_ADDR
  @brief IOCTL to get current configuration details
  @see IOCTL_PCIEQOS_WRITE_MAC_ADDR
  @note this is an undocumented IOCTL
  */
#define IOCTL_PCIEQOS_WRITE_MAC_ADDR            IOH_PCIEQOS_IOCTL(0x806)

/*! @ingroup InterfaceLayer
  @def IOCTL_PCIEQOS_MM_ALLOC_CONT_MEM
  @brief IOCTL to allocate contiguous memory
  @see IOCTL_PCIEQOS_MM_ALLOC_CONT_MEM
  @note this is an undocumented IOCTL
  */
#define IOCTL_PCIEQOS_MM_ALLOC_CONT_MEM          IOH_PCIEQOS_IOCTL(0x807)

/*! @ingroup InterfaceLayer
  @def IOCTL_PCIEQOS_MM_FREE_CONT_MEM
  @brief IOCTL to free contiguous memory
  @see IOCTL_PCIEQOS_MM_FREE_CONT_MEM
  @note this is an undocumented IOCTL
  */
#define IOCTL_PCIEQOS_MM_FREE_CONT_MEM           IOH_PCIEQOS_IOCTL(0x808)

/*! @ingroup InterfaceLayer
  @def IOCTL_PCIEQOS_MM_QUERY_CONT_MEM_SIZE
  @brief IOCTL to query contiguous memory size
  @see IOCTL_PCIEQOS_MM_QUERY_CONT_MEM_SIZE
  @note this is an undocumented IOCTL
  */
#define IOCTL_PCIEQOS_MM_QUERY_CONT_MEM_SIZE     IOH_PCIEQOS_IOCTL(0x809)
#endif


