/**
* @file ioh_spi_common.h
*
* @author Wipro Technologies 
* @date 3 July 2009
*
* @brief SPI common file used both by application and driver
*
* This file contains the various driver loading related
*files
*
* 
 * @par
 * IOH_Windows Driver Release version 1.0 
 * 
 * -- Copyright Notice --
 * 
 * @par
 * Copyright (C) 2009-2012 LAPIS SEMICONDUCTOR Co., LTD.
 * All rights reserved.
 * 
 * @par
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the LAPIS SEMICONDUCTOR  nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * 
 * @par
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * 
 * @par
 * -- End of Copyright Notice --
*/

#ifndef __IOH_SPI_COMMON_H__
#define __IOH_SPI_COMMON_H__

/**
 * @ingroup InterfaceLayer
 * @define  GUID_DEVINTERFACE_IOHSPI
 * @brief Guid Device Inteface used from the user application to control the device
 */
DEFINE_GUID(GUID_DEVINTERFACE_IOHSPI, 
0x4725f1f0, 0xca24, 0x42c7, 0x93, 0x6a, 0x53, 0x53, 0x3a, 0x5a, 0x99, 0xcc);

/*! @ingroup InterfaceLayer
    @def IOH_SPI_CPHA
    @brief clock phase
    @see IOH_SPI_MODE_1
    @see IOH_SPI_MODE_2
    @see IOH_SPI_MODE_3
*/
#define IOH_SPI_CPHA        ( 0x01 )

/*! @ingroup InterfaceLayer
    @def IOH_SPI_CPOL
    @brief clock polarity
    @see IOH_SPI_MODE_1
    @see IOH_SPI_MODE_2
    @see IOH_SPI_MODE_3
*/
#define IOH_SPI_CPOL        ( 0x02 )

/*! @ingroup InterfaceLayer
    @def IOH_SPI_MODE_0
    @brief Mode 0 => CPHA = 0 and CPOL =0

*/
#define IOH_SPI_MODE_0        ( 0 | 0 )

/*! @ingroup InterfaceLayer
    @def IOH_SPI_MODE_1
    @brief Mode 1 => CPHA = 1 and CPOL =0
*/
#define IOH_SPI_MODE_1        ( 0 | IOH_SPI_CPHA )

/*! @ingroup InterfaceLayer
    @def IOH_SPI_MODE_2
    @brief Mode 2 => CPHA = 0 and CPOL =1

*/
#define IOH_SPI_MODE_2        ( IOH_SPI_CPOL | 0 )

/*! @ingroup InterfaceLayer
    @def IOH_SPI_MODE_3
    @brief Mode 3 => CPHA = 1 and CPOL = 1
*/
#define IOH_SPI_MODE_3      ( IOH_SPI_CPOL | IOH_SPI_CPHA )

/*! @ingroup InterfaceLayer
    @def IOH_SPI_LSB_FIRST
    @brief LSB fist data transfer
*/
#define IOH_SPI_LSB_FIRST   ( 0x08 )

/* valid bits per word settings*/

/*! @ingroup    InterfaceLayer
@def        IOH_SPI_8_BPW
@brief        Macro to denote 8 Bits per word transfer
*/
#define IOH_SPI_8_BPW                     (8)

/*! @ingroup    InterfaceLayer
@def            IOH_SPI_16_BPW
@brief            Macro to denote 16 Bits per word transfer
*/
#define IOH_SPI_16_BPW                     (16)

/* status codes */

/*! @ingroup InterfaceLayer
    @def IOH_SPI_SUCCESS
    @brief return value for success full operation
*/
#define IOH_SPI_SUCCESS                    ( 1 )

/*! @ingroup InterfaceLayer
    @def IOH_SPI_FAILURE
    @brief operation failed
*/
#define IOH_SPI_FAILURE                    ( 0 )

/*! @ingroup InterfaceLayer
    @def IOH_SPI_INVALID_PARAMETER
    @brief invalid parameter
*/
#define IOH_SPI_INVALID_PARAMETER        ( -1 )

/*! @ingroup InterfaceLayer
    @def IOH_SPI_ENABLE
    @brief Enable SPI interrupts
*/
#define IOH_SPI_ENABLE        ( 1 )

/*! @ingroup InterfaceLayer
    @def IOH_SPI_DISABLE
    @brief Disable SPI interrupts
*/
#define IOH_SPI_DISABLE        ( 0 )

/*! @ingroup InterfaceLayer
    @struct IOH_SPI_CONFIG
    @brief This structure holds the uses supplied configuration 
           information for the setup the SPI controller
    @see IOCTL_SPI_CONFIG
*/
typedef struct _IOH_SPI_CONFIG
{
    ULONG        SlaveNo;           /*!< Slave device number */
    ULONG        BaudRate;          /*!< Baud rate of the device */
    UCHAR        BitsPerWord;       /*!< Transfer size 8 bit or 16 bit */
    UCHAR        Mode;              /*!< Mode0,1,2,3 and MSB/LSB first */
}IOH_SPI_CONFIG, *PIOH_SPI_CONFIG;


/*! @ingroup InterfaceLayer
    @struct IOH_SPI_RW
    @brief  data structure used for read/ write IOCTLs
*/
typedef struct _IOH_SPI_RW
{
    IOH_SPI_CONFIG SpiConfig; /*!< Configuration information */
    ULONG nSize;
    PVOID Buffer;             /*!< Data buffer  */

}IOH_SPI_RW,*PIOH_SPI_RW;

#endif