/**
* @file ioh_udc_ioctls.h
*
* @author LAPIS SEMICONDUCTOR
* @date 30 Man 2012
*
* @brief The user interface definition of USB device driver.
*		 GUID, IOCTL, etc.
*
* @par
* IOH_Windows Driver Release version 2.5.1
*
* -- Copyright Notice --
*
* @par
* Copyright (c) 2010-2012, LAPIS SEMICONDUCTOR CO.,LTD.
* All rights reserved.
*
* @par
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1. Redistributions of source code must retain the above copyright
*	 notice, this list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright
*	 notice, this list of conditions and the following disclaimer in the
*	 documentation and/or other materials provided with the distribution.
* 3. Neither the name of the LAPIS semiconductor	nor the names of its
*	contributors  may be used to endorse or promote products derived
*	from this software without specific prior written permission.
*
*
* @par
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
* IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 * @par
 * -- End of Copyright Notice --
*/

#ifndef __IOH_UDC_IOCTLS_H__
#define __IOH_UDC_IOCTLS_H__

#include <initguid.h> /*Required for GUID definitions*/


/*!@defgroup UserAPI		User API
   @ingroup UDCDriver
*/

/**
 * @ingroup UserAPI
 * @def GUID_DEVINTERFACE_IOHUSBD
 * @brief Guid Device Inteface used from the user application to control the device
 */
DEFINE_GUID(GUID_DEVINTERFACE_IOHUSBD,
0x66fde0f3, 0x69eb, 0x427f, 0xa9, 0x1a, 0xe3, 0xce, 0x4c, 0x13, 0xb3, 0x6a);

/*
Define the IOCTL codes we will use.  The IOCTL code contains a command
identifier, plus other information about the device, the type of access
with which the file must have been opened, and the type of buffering.

The IOCTL function codes from 0x800 to 0xFFF are for customer use. */

#define IOH_USB_DEVICE_TYPE 40002

/*! @ingroup UserAPI
  @def IOCTL_SET_USB_DESCRIPTORS
  @brief IOCTL to Handle Notify.
  */
#define IOCTL_SET_USB_DESCRIPTORS \
	CTL_CODE( IOH_USB_DEVICE_TYPE, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS )

/*! @ingroup UserAPI
  @def IOCTL_USB_GET_CONFIG_NUMBER
  @brief IOCTL to enable GET_CONFIG_NUMBER feature of USB Device.
  */
#define IOCTL_USB_GET_CONFIG_NUMBER \
	CTL_CODE( IOH_USB_DEVICE_TYPE, 0x810, METHOD_BUFFERED, FILE_ANY_ACCESS )

#endif


