 //*-- Intel Copyright Notice --
 //* 
 //* 
 //* Copyright (c) 2002-2010 Intel Corporation All Rights Reserved.
 //* 
 //*
 //* The source code contained or described herein and all documents
 //* related to the source code ("Material") are owned by Intel Corporation
 //* or its suppliers or licensors.  Title to the Material remains with
 //* Intel Corporation or its suppliers and licensors.
 //* 
 //*
 //* The Material is protected by worldwide copyright and trade secret laws
 //* and treaty provisions. No part of the Material may be used, copied,
 //* reproduced, modified, published, uploaded, posted, transmitted,
 //* distributed, or disclosed in any way except in accordance with the
 //* applicable license agreement .
 //* 
 //*
 //* No license under any patent, copyright, trade secret or other
 //* intellectual property right is granted to or conferred upon you by
 //* disclosure or delivery of the Materials, either expressly, by
 //* implication, inducement, estoppel, except in accordance with the
 //* applicable license agreement.
 //* 
 //*
 //* Unless otherwise agreed by Intel in writing, you may not remove or
 //* alter this notice or any other notice embedded in Materials by Intel
 //* or Intel's suppliers or licensors in any way.
 //* 
 //* 
 //* For further details, please see the file README.TXT distributed with
 //* this software.
 //* 
 //*
 //* -- End Intel Copyright Notice --/
 //


`timescale 1 ns/1 ns

module lcd_fmt_wr (
    input [7:0]         data_in,
    input               row,
    input               wr,
    input               rd,             // assert for 1 clock cycle before read
    input               clk,
    input               reset,
    input               busy_in,
    output reg          wr_out,
    output reg  [7:0]   data_out,
    output reg          rs_out,  
    output reg          busy_out,
    output      [7:0]   rd_data_out
    );

	parameter ssUpdateRegLen = 16;

	parameter STATE_FORMAT_WR_RESET = 0;

	parameter STATE_FORMAT_WR_INIT_0    =     1  ;
	parameter STATE_FORMAT_WR_INIT_1    =      2  ;
	parameter STATE_FORMAT_WR_INIT_2    =      3  ;
	parameter STATE_FORMAT_WR_INIT_3    =      4 ;
	parameter STATE_FORMAT_WR_INIT_4    =      5  ;


	parameter STATE_FORMAT_WR_IDLE      =      6 ;
	parameter STATE_FORMAT_REDRAW       =      7 ;

	parameter STATE_FORMAT_WR_DDRAM     =      8 ;
	parameter STATE_FORMAT_PUTC_HI      =      9 ;
	parameter STATE_FORMAT_PUTC_LO      =      10 ;
	parameter STATE_FORMAT_PUTC_SPACE   =      11 ;
	parameter STATE_FORMAT_CONT_ROW     =      12 ;
	parameter STATE_FORMAT_NEXT_ROW     =      13 ;
	parameter IDLE	= 	14;

    
    reg [7:0] disp_bytes [0:1][0:4];        // 8 bit, 2 rows, 5 bytes data
    reg [2:0] draw_column;                  // 3 bit, 0-7, only 0-4 is used
    reg       draw_row;
    reg [4:0] cur_state;
    reg [4:0] next_state;
    reg       next_wr_out;
    reg [7:0] next_data_out;
    reg       next_hold_wr_out;
    reg       rd_row;
    reg [20:0] count_init;	//	
    reg		count_33ms, count_45us, count_16ms;

    reg       need_redraw;

    reg hold_wr_out;      // not ff
    
    // reg down_stream_busy;
    
    wire [7:0] ascii_hi;
    wire [7:0] ascii_lo;

    assign ascii_hi = (draw_column < 5)? 
                      (disp_bytes[draw_row][draw_column][7:4] + ((disp_bytes[draw_row][draw_column][7:4] > 9)? 55 : 48)) 
                      : 0 ;
    assign ascii_lo = (draw_column < 5)? 
                      (disp_bytes[draw_row][draw_column][3:0] + ((disp_bytes[draw_row][draw_column][3:0] > 9)? 55 : 48))
                      : 0 ;
    assign rd_data_out = disp_bytes[rd_row][4] ;

    always @(posedge clk or negedge reset)
    begin
	    if(!reset)
	    begin
		    count_init	<= 0;
		    cur_state	<= IDLE;
	            count_33ms	<= 0;
	            count_45us	<= 0;
	            count_16ms	<= 0;
	    end
	    else
	    begin
		    cur_state	<= next_state;
		    case(next_state)
			    STATE_FORMAT_WR_RESET:begin
				    			if(count_init==/*1100000*/264000)		//33 ms for 33/8 MHz clock
							begin
								count_33ms	<=	1;
								count_init	<=	0;
							end
							else
							begin
								count_33ms	<=	0;
								count_init	<=	count_init + 1;
							end
						end
			    STATE_FORMAT_WR_INIT_0:begin
				    			if(count_init==/*1500*/360)		//45 us for 33/8 MHz clock
							begin
								count_45us	<=	1;
								count_init	<=	0;
							end
							else
							begin
								count_45us	<=	0;
								count_init	<=	count_init + 1;
							end
						end
			    STATE_FORMAT_WR_INIT_1:begin
				    			if(count_init==/*1500*/360)		//45 us for 33/8 MHz clock
							begin
								count_45us	<=	1;
								count_init	<=	0;
							end
							else
							begin
								count_45us	<=	0;
								count_init	<=	count_init + 1;
							end
						end
			    STATE_FORMAT_WR_INIT_2:begin
				    			if(count_init==/*54000*/12960)		//1.6 ms for 33/8 MHz clock
							begin
								count_16ms	<=	1;
								count_init	<=	0;
							end
							else
							begin
								count_16ms	<=	0;
								count_init	<=	count_init + 1;
							end
						end
			    STATE_FORMAT_WR_INIT_3:begin
				    			if(count_init==/*1500*/360)		//45 us for 33/8 MHz clock
							begin
								count_45us	<=	1;
								count_init	<=	0;
							end
							else
							begin
								count_45us	<=	0;
								count_init	<=	count_init + 1;
							end
						end
			    STATE_FORMAT_WR_DDRAM:begin
				    			if(count_init==/*1500*/360)		//33 ms for 33/8 MHz clock
							begin
								count_45us	<=	1;
								count_init	<=	0;
							end
							else
							begin
								count_45us	<=	0;
								count_init	<=	count_init + 1;
							end
						end
			    STATE_FORMAT_PUTC_HI:begin
				    			if(count_init==/*1500*/360)		//33 ms for 33/8 MHz clock
							begin
								count_45us	<=	1;
								count_init	<=	0;
							end
							else
							begin
								count_45us	<=	0;
								count_init	<=	count_init + 1;
							end
						end
			    STATE_FORMAT_PUTC_LO:begin
				    			if(count_init==/*1500*/360)		//33 ms for 33/8 MHz clock
							begin
								count_45us	<=	1;
								count_init	<=	0;
							end
							else
							begin
								count_45us	<=	0;
								count_init	<=	count_init + 1;
							end
						end
			    STATE_FORMAT_PUTC_SPACE:begin
				    			if(count_init==/*1500*/360)		//33 ms for 33/8 MHz clock
							begin
								count_45us	<=	1;
								count_init	<=	0;
							end
							else
							begin
								count_45us	<=	0;
								count_init	<=	count_init + 1;
							end
						end
			endcase

	    end
    end

    //-----------------------------------------------------------------------
    // Try to do as much as possible with combinational logic
    //-----------------------------------------------------------------------
    always @(*)
    begin
       next_state = IDLE;
       next_data_out = 0;
       rs_out = 0;
       next_hold_wr_out = 0;
	   busy_out = 0;
       next_wr_out = 0;


        case (cur_state)
                IDLE:
                    begin 
                                next_wr_out = 0;
                                next_data_out = 8'h00;   // setup command for DDRAM write
                                next_hold_wr_out = 0;
                                next_state = STATE_FORMAT_WR_RESET;
                    end

		STATE_FORMAT_WR_RESET:
                    begin 
                        busy_out = 1;   // Hold the turn on VFD command and wait
                        rs_out = 0;
                        next_wr_out = 0;
                        next_data_out = 8'h00;   // setup command for DDRAM write
                        next_hold_wr_out = 0;
                        next_state = STATE_FORMAT_WR_RESET;
                        if (hold_wr_out)
                            begin
                                next_hold_wr_out = 0;
                            end
                        else
                            begin
                            if (!busy_in && count_33ms)
                                begin
                                    next_wr_out = 1;
                                    next_data_out = 8'h3C;   // setup command for DDRAM write
                                    next_hold_wr_out = 1;
                                    next_state = STATE_FORMAT_WR_INIT_0;
                                end
                            end
                    end

                STATE_FORMAT_WR_INIT_0:
                    begin
                        busy_out = 1;   // Hold the turn on VFD command and wait
                        rs_out = 0;
                        next_wr_out = 0;
                        next_hold_wr_out = 0;
                        next_state = STATE_FORMAT_WR_INIT_0;
                        next_data_out = 8'h3C;   // 2 line, display on
                        if (hold_wr_out)
                            begin
                                next_hold_wr_out = 0;
                            end
                        else
                            begin
                            if (!busy_in && count_45us)
                                begin
                                    next_wr_out = 1;
                                    next_data_out = 8'h0E;   // setup command for DDRAM write
                                    next_hold_wr_out = 1;
                                    next_state = STATE_FORMAT_WR_INIT_1;
                                end
                            end
                    end

	    	STATE_FORMAT_WR_INIT_1:
                    begin
                        busy_out = 1;   // Hold the turn on VFD command and wait
                        rs_out = 0;
                        next_wr_out = 0;
                        next_hold_wr_out = 0;
                        next_state = STATE_FORMAT_WR_INIT_1;
                        next_data_out = 8'h0E;   // display on, cursor on, blink off
                        if (hold_wr_out)
                            begin
                                next_hold_wr_out = 0;
                            end
                        else
                            begin
                            if (!busy_in && count_45us)
                                begin
                                    next_wr_out = 1;
                                    next_data_out = 8'h01;   // setup command for DDRAM write
                                    next_hold_wr_out = 1;
                                    next_state = STATE_FORMAT_WR_INIT_2;
                                end
                            end
                    end


                STATE_FORMAT_WR_INIT_2:
                    begin
                        busy_out = 1;   // Hold the turn on VFD command and wait
                        rs_out = 0;
                        next_wr_out = 0;
                        next_hold_wr_out = 0;
                        next_state = STATE_FORMAT_WR_INIT_2;
                        next_data_out = 8'h01;   // display clear
                        if (hold_wr_out)
                            begin
                                next_hold_wr_out = 0;
                            end
                        else
                            begin
                            if (!busy_in && count_16ms)
                                begin
                                    next_wr_out = 1;
                                    next_data_out = 8'h06;   // setup command for DDRAM write
                                    next_hold_wr_out = 1;
                                    next_state = STATE_FORMAT_WR_INIT_3;
                                end
                            end
                    end

                STATE_FORMAT_WR_INIT_3:
                    begin
                        busy_out = 1;   // Hold the turn on VFD command and wait
                        rs_out = 0;
                        next_wr_out = 0;
                        next_hold_wr_out = 0;
                        next_state = STATE_FORMAT_WR_INIT_3;
                        next_data_out = 8'h06;   // increment mode, shift off
                        if (hold_wr_out)
                            begin
                                next_hold_wr_out = 0;
                            end
                        else
                            begin
                            if (!busy_in && count_45us)
                                begin
                                    next_wr_out = 1;
                                    next_hold_wr_out = 1;
                                    next_state = STATE_FORMAT_WR_IDLE;
                                end
                            end
                    end


                STATE_FORMAT_WR_IDLE:
                    begin
                        busy_out = 0;   // Hold the turn on VFD command and wait
                        rs_out = 0;
                        next_wr_out = 0;
                        next_hold_wr_out = 0;
                        next_state = STATE_FORMAT_WR_IDLE;
                        next_data_out = 8'h80;   // setup command for DDRAM write for first row
                        if (need_redraw == 1)
                            begin
                               next_state = STATE_FORMAT_REDRAW;
                            end
                        else
                            begin
                                next_state = STATE_FORMAT_WR_IDLE;
                            end
                    end

                STATE_FORMAT_REDRAW:
                    begin
                        next_wr_out = 1;
                        next_hold_wr_out = 1;
                        next_state = STATE_FORMAT_WR_INIT_0;

                        if (!draw_row)
                            next_data_out = 8'h80;   // setup command for DDRAM write
                        else
                            next_data_out = 8'hC0;
                        next_state = STATE_FORMAT_WR_DDRAM;
                    end

                STATE_FORMAT_WR_DDRAM:
                    begin
                        busy_out = 1;   // Hold the turn on VFD command and wait
                        rs_out = 0;
                        next_wr_out = 0;
                        next_hold_wr_out = 0;
                        next_state = STATE_FORMAT_WR_DDRAM;
                                if (!draw_row)
                                    next_data_out = 8'h80;   // setup command for DDRAM write
                                else
                                    next_data_out = 8'hC0;
                        if (hold_wr_out)
                            begin
                                next_hold_wr_out = 0;
                            end
                        else
                            begin
                            if (!busy_in && count_45us)
                                begin
                                    next_wr_out = 1;
                                    next_data_out = ascii_hi;   // setup command for DDRAM write
                                    next_hold_wr_out = 1;
                                    next_state = STATE_FORMAT_PUTC_HI;
                                end
                            end
                    end

                STATE_FORMAT_PUTC_HI:
                    begin
                        busy_out = 1;   // Hold the turn on VFD command and wait
                        rs_out = 1;
                        next_wr_out = 0;
                        next_hold_wr_out = 0;
                        next_state = STATE_FORMAT_PUTC_HI;
                        next_data_out = ascii_hi;   // setup command for DDRAM write
                        if (hold_wr_out)
                            begin
                                next_hold_wr_out = 0;
                            end
                        else
                            begin
                            if (!busy_in && count_45us)
                                begin
                                    next_wr_out = 1;
                                    next_data_out = ascii_lo;   // setup command for DDRAM write
                                    next_hold_wr_out = 1;
                                    next_state = STATE_FORMAT_PUTC_LO;
                                end
                            end
                    end

                STATE_FORMAT_PUTC_LO:
                    begin
                        busy_out = 1;   // Hold the turn on VFD command and wait
                        rs_out = 1;
                        next_wr_out = 0;
                        next_hold_wr_out = 0;
                        next_state = STATE_FORMAT_PUTC_LO;
                        next_data_out = ascii_lo;   // setup command for DDRAM write
                        if (hold_wr_out)
                            begin
                                next_hold_wr_out = 0;
                            end
                        else
                            begin
                            if (!busy_in && count_45us)
                                begin
                                    next_wr_out = 1;
                                    next_data_out = 8'h20;   // setup command for DDRAM write
                                    next_hold_wr_out = 1;
                                    next_state = STATE_FORMAT_PUTC_SPACE;
                                end
                            end
                    end

                STATE_FORMAT_PUTC_SPACE:
                    begin
                        busy_out = 1;   // Hold the turn on VFD command and wait
                        rs_out = 1;
                        next_wr_out = 0;
                        next_hold_wr_out = 0;
                        next_state = STATE_FORMAT_PUTC_SPACE;
                        next_data_out = 8'h20;   // setup command for DDRAM write
                        if (hold_wr_out)
                            begin
                                next_hold_wr_out = 0;
                            end
                        else
                            begin
                            if (!busy_in && count_45us)
                                begin
                                    next_state = STATE_FORMAT_CONT_ROW;
                                end
                            end
                     end

                STATE_FORMAT_CONT_ROW:
                    begin
                        busy_out = 1;   // Hold the turn on VFD command and wait
                        rs_out = 0;
                        next_wr_out = 0;
                        next_hold_wr_out = 0;
                        next_data_out = ascii_hi;   // setup command for DDRAM write
                        if (draw_column<5) begin
                                next_wr_out = 1;
                                next_data_out = ascii_hi;   // setup command for DDRAM write
                                next_hold_wr_out = 1;
                                next_state = STATE_FORMAT_PUTC_HI;
                        end else if (!draw_row) begin
                                next_data_out = 8'hC0;   // setup command for DDRAM write
                                next_state = STATE_FORMAT_NEXT_ROW;
                        end else begin
                                next_state = STATE_FORMAT_WR_IDLE;
                        end
                    end

                STATE_FORMAT_NEXT_ROW:
                    begin
                        next_wr_out = 1;
                        next_hold_wr_out = 1;
                        if (!draw_row)
                            next_data_out = 8'h80;   // setup command for DDRAM write
                        else
                            next_data_out = 8'hC0;
                        next_state = STATE_FORMAT_WR_DDRAM;
                    end



                default: ;

                    // should never be here     
        endcase
    end

    
    //-----------------------------------------------------------------------
    // This sequential logic is needed to shift and memorize the 10 bytes of 
    // display data.
    //-----------------------------------------------------------------------
    always @(posedge clk)
    begin

    end
    
    // -----------------------
    // FMS state transition
    // -----------------------
    always @(posedge clk or negedge reset)
    begin
        if (!reset)
            begin
                wr_out <= 0;
                data_out <= 0;
                hold_wr_out <= 0;
                rd_row <= 0;
                need_redraw <= 1;
                draw_column <= 0; // when it redraw the whole line. Start with draw_column 0
                draw_row <= 0; // when it redraw the whole line. Start with draw_column 0


                // when unit held in reset
                    disp_bytes[0][0] <= 8'h0;
                    disp_bytes[0][1] <= 8'h0;
                    disp_bytes[0][2] <= 8'h0;
                    disp_bytes[0][3] <= 8'h0;
                    disp_bytes[0][4] <= 8'h0;
                    disp_bytes[1][0] <= 8'h0;
                    disp_bytes[1][1] <= 8'h0;
                    disp_bytes[1][2] <= 8'h0;
                    disp_bytes[1][3] <= 8'h0;
                    disp_bytes[1][4] <= 8'h0;
            end
        else
            begin
                // As long as the unit is not in reset, and it sees wr assert for this
                // cycle implies a write request. 
                if (wr) begin
                    // shift one byte to the left for this row
                    disp_bytes[row][0] <= disp_bytes[row][1] ;
                    disp_bytes[row][1] <= disp_bytes[row][2] ;
                    disp_bytes[row][2] <= disp_bytes[row][3] ;
                    disp_bytes[row][3] <= disp_bytes[row][4] ;
                    disp_bytes[row][4] <= data_in;  // The 5th byte is the data_in
                    need_redraw <= 1;
                end

                case (next_state)
                    STATE_FORMAT_REDRAW:
                        begin
                            draw_column <= 0; // when it redraw the whole line. Start with draw_column 0
                            draw_row <= 0; // when it redraw the whole line. Start with draw_column 0
                            need_redraw <= 0;
                        end
                    STATE_FORMAT_CONT_ROW:  // continue to render the row
                        begin
                                draw_column <= draw_column + 1;
                        end
                    STATE_FORMAT_NEXT_ROW:
                        begin
                            draw_row <= 1;
                            draw_column <= 0;
                        end
                endcase

                wr_out <= next_wr_out;
                data_out <= next_data_out;
                hold_wr_out <= next_hold_wr_out;
                if (rd) begin
                    rd_row <= row;
                end

            end
    end

    
endmodule
