 //*-- Intel Copyright Notice --
 //* 
 //* 
 //* Copyright (c) 2002-2010 Intel Corporation All Rights Reserved.
 //* 
 //*
 //* The source code contained or described herein and all documents
 //* related to the source code ("Material") are owned by Intel Corporation
 //* or its suppliers or licensors.  Title to the Material remains with
 //* Intel Corporation or its suppliers and licensors.
 //* 
 //*
 //* The Material is protected by worldwide copyright and trade secret laws
 //* and treaty provisions. No part of the Material may be used, copied,
 //* reproduced, modified, published, uploaded, posted, transmitted,
 //* distributed, or disclosed in any way except in accordance with the
 //* applicable license agreement .
 //* 
 //*
 //* No license under any patent, copyright, trade secret or other
 //* intellectual property right is granted to or conferred upon you by
 //* disclosure or delivery of the Materials, either expressly, by
 //* implication, inducement, estoppel, except in accordance with the
 //* applicable license agreement.
 //* 
 //*
 //* Unless otherwise agreed by Intel in writing, you may not remove or
 //* alter this notice or any other notice embedded in Materials by Intel
 //* or Intel's suppliers or licensors in any way.
 //* 
 //* 
 //* For further details, please see the file README.TXT distributed with
 //* this software.
 //* 
 //*
 //* -- End Intel Copyright Notice --/
 //


// This module manage the 4 phases of physically writing to vfd
`timescale 1 ns/1 ns

// `define HOLD_NUM_CYCLES     20
// `define HOLD_NUM_CYCLES     8  

// Use 80 for Stellar Cove 
// `define HOLD_NUM_CYCLES     80

// Use 1 for Kodiak Island
//`define HOLD_NUM_CYCLES     1

// General Timing met requirement
`define HOLD_NUM_CYCLES     21		//33MHz
//`define HOLD_NUM_CYCLES     10		//8MHz


module lcd_phy_wr (
    input   [7:0] data_in, 
    input   rs_in,                         // rs value for vfd writing
    input   wr, 
    input   clk,
    input   reset,
    output  busy,    
    output  reg vfd_data_out_en,        // used by top level to enable/tri-state pins. Combin - no ff
    output  reg vfd_wr_n_out,           // tell vfd to start writing. Combin - no ff
    output  reg vfd_rd_n_out,
    output  [7:0] vfd_data_out,         // simply bypass data_in
    output  vfd_rs                      // simply bypass rs_in
    );
    
	parameter STATE_PHY_VFD_IDLE                    = 0;
	parameter STATE_PHY_VFD_SETUP                   = 1;
	parameter STATE_PHY_VFD_WRITE_ASSERT            = 2;
	parameter STATE_PHY_VFD_WRITE_DEASSERT_START    = 3;
	parameter STATE_PHY_VFD_WRITE_DEASSERT          = 4;
	parameter STATE_PHY_VFD_RECOVERY                = 5;

    // Local registers
    reg [2:0] cur_state;

    // reg wr_requested;
    reg [2:0] next_state;       // no flip flop.

    // Hold counter to make it work at silicon speed (33 MHz LPC bus)
    reg [4:0] hold_counter;       // 5 bit counter - could hold up to 32 cycles

    
    // simply bypass signals
    assign  vfd_data_out = data_in;
    assign  vfd_rs = rs_in;

    // assign busy = wr |(cur_state != STATE_PHY_VFD_IDLE);

    assign busy = (cur_state != STATE_PHY_VFD_IDLE);

    
    always @(*)
    begin

        next_state = STATE_PHY_VFD_IDLE;
        vfd_wr_n_out = 1;
	vfd_rd_n_out = 0;

        vfd_data_out_en = 0;   // outside buffer will be enabled

        case (cur_state)
                STATE_PHY_VFD_IDLE:

                    if (wr)
                        next_state = STATE_PHY_VFD_SETUP;

                STATE_PHY_VFD_SETUP:

                    begin

                        vfd_data_out_en = 1;   // outside buffer will be enabled

                        // assume external modules will drive and hold data_in and rs_in through the whole cycle

                        next_state = STATE_PHY_VFD_WRITE_ASSERT;

                    end

                STATE_PHY_VFD_WRITE_ASSERT:
                    begin
                            vfd_data_out_en = 1;   // outside buffer will be enabled
                            vfd_wr_n_out = 0;
			    if(hold_counter==(`HOLD_NUM_CYCLES - 1) | hold_counter==(`HOLD_NUM_CYCLES - 2) | hold_counter==(`HOLD_NUM_CYCLES - 3) | hold_counter== 5'd1 | hold_counter==5'd0 )
			    begin
				    vfd_rd_n_out = 0;
			    end
			    else
			    begin
				    vfd_rd_n_out = 1;
			    end
                            next_state = (hold_counter==0)?
                                    STATE_PHY_VFD_WRITE_DEASSERT_START :
                                    STATE_PHY_VFD_WRITE_ASSERT ;
                    end
                STATE_PHY_VFD_WRITE_DEASSERT_START:
                    begin
                            vfd_data_out_en = 1;   // outside buffer will be enabled
                            vfd_wr_n_out = 1;
			    vfd_rd_n_out = 0;
                            next_state = STATE_PHY_VFD_WRITE_DEASSERT;
                    end
                STATE_PHY_VFD_WRITE_DEASSERT:
                    begin
                            vfd_data_out_en = 1;   // outside buffer will be enabled
                            vfd_wr_n_out = 1;
			    vfd_rd_n_out = 0;
                            next_state = (hold_counter==0)?
                                    STATE_PHY_VFD_RECOVERY :
                                    STATE_PHY_VFD_WRITE_DEASSERT ;
                    end
                STATE_PHY_VFD_RECOVERY:
                    begin
                            next_state = STATE_PHY_VFD_IDLE;
                    end
                default:    ;
                    // should never be here     
        endcase
    end
    
    
    always @(posedge clk or negedge reset)
    begin
        if (!reset)
            begin
                cur_state    <= STATE_PHY_VFD_IDLE;
                        hold_counter <=  0;  

                // wr_requested <= 0;
                // busy <= 0;   // busy de-asserted

            end
        else
            begin

                cur_state <= next_state;
                case (next_state)
                    STATE_PHY_VFD_SETUP:
                        // if entering the STATE_PHY_VFD_WRITE_ASSERT state,
                        // set the hold counter
                        hold_counter <=  `HOLD_NUM_CYCLES;
                    STATE_PHY_VFD_WRITE_DEASSERT_START:
                        hold_counter <=  `HOLD_NUM_CYCLES;
                    default:
                        if (hold_counter > 0 ) begin
                            hold_counter <=  hold_counter - 1;  
                        end
                endcase
            end
    end

/*

    always @(negedge clk)

    begin



        if ((cur_state == STATE_PHY_VFD_IDLE) && wr)

            wr_requested <= 1;

        else

            wr_requested <= 0;

    end

*/
    
endmodule
