 //*-- Intel Copyright Notice --
 //* 
 //* 
 //* Copyright (c) 2002-2010 Intel Corporation All Rights Reserved.
 //* 
 //*
 //* The source code contained or described herein and all documents
 //* related to the source code ("Material") are owned by Intel Corporation
 //* or its suppliers or licensors.  Title to the Material remains with
 //* Intel Corporation or its suppliers and licensors.
 //* 
 //*
 //* The Material is protected by worldwide copyright and trade secret laws
 //* and treaty provisions. No part of the Material may be used, copied,
 //* reproduced, modified, published, uploaded, posted, transmitted,
 //* distributed, or disclosed in any way except in accordance with the
 //* applicable license agreement .
 //* 
 //*
 //* No license under any patent, copyright, trade secret or other
 //* intellectual property right is granted to or conferred upon you by
 //* disclosure or delivery of the Materials, either expressly, by
 //* implication, inducement, estoppel, except in accordance with the
 //* applicable license agreement.
 //* 
 //*
 //* Unless otherwise agreed by Intel in writing, you may not remove or
 //* alter this notice or any other notice embedded in Materials by Intel
 //* or Intel's suppliers or licensors in any way.
 //* 
 //* 
 //* For further details, please see the file README.TXT distributed with
 //* this software.
 //* 
 //*
 //* -- End Intel Copyright Notice --/
 //


`timescale 1 ns/1 ns

module lcd_seven_segment(
    input [3:0] 	data_in, 
    input   		clk,
    input   		reset,
	 input			port_option,
	 input 			row_port_80,
	 output reg [6:0] seg_data_out
    );

always @(posedge clk, negedge reset)
begin
	if(!reset)
	begin
		seg_data_out	<= 7'b0111111;
	end
	else
	begin
		if (row_port_80 && port_option)
		  begin
			  case(data_in)
				4'h0:	seg_data_out	<= 7'b0111111;
				4'h1:	seg_data_out	<= 7'b0000110;
				4'h2:	seg_data_out	<= 7'b1011011;
				4'h3:	seg_data_out	<= 7'b1001111;
				4'h4:	seg_data_out	<= 7'b1100110;
				4'h5:	seg_data_out	<= 7'b1101101;
				4'h6:	seg_data_out	<= 7'b1111101;
				4'h7:	seg_data_out	<= 7'b0000111;
				4'h8:	seg_data_out	<= 7'b1111111;
				4'h9:	seg_data_out	<= 7'b1101111;
				4'hA:	seg_data_out	<= 7'b1110111;
				4'hB:	seg_data_out	<= 7'b1111100;
				4'hC:	seg_data_out	<= 7'b0111001;
				4'hD:	seg_data_out	<= 7'b1011110;
				4'hE:	seg_data_out	<= 7'b1111001;
				4'hF:	seg_data_out	<= 7'b1110001;
				default:seg_data_out	<= 7'b0111111;
			  endcase // case (data_in)
		  end
		else
		  seg_data_out <= seg_data_out;
	end
end
    
endmodule
