 //*-- Intel Copyright Notice --
 //* 
 //* 
 //* Copyright (c) 2002-2010 Intel Corporation All Rights Reserved.
 //* 
 //*
 //* The source code contained or described herein and all documents
 //* related to the source code ("Material") are owned by Intel Corporation
 //* or its suppliers or licensors.  Title to the Material remains with
 //* Intel Corporation or its suppliers and licensors.
 //* 
 //*
 //* The Material is protected by worldwide copyright and trade secret laws
 //* and treaty provisions. No part of the Material may be used, copied,
 //* reproduced, modified, published, uploaded, posted, transmitted,
 //* distributed, or disclosed in any way except in accordance with the
 //* applicable license agreement .
 //* 
 //*
 //* No license under any patent, copyright, trade secret or other
 //* intellectual property right is granted to or conferred upon you by
 //* disclosure or delivery of the Materials, either expressly, by
 //* implication, inducement, estoppel, except in accordance with the
 //* applicable license agreement.
 //* 
 //*
 //* Unless otherwise agreed by Intel in writing, you may not remove or
 //* alter this notice or any other notice embedded in Materials by Intel
 //* or Intel's suppliers or licensors in any way.
 //* 
 //* 
 //* For further details, please see the file README.TXT distributed with
 //* this software.
 //* 
 //*
 //* -- End Intel Copyright Notice --/
 //

// Title:         lpc_i2c_cpld_top.v
// Device target: Altera EPM570M100C5


`timescale 1 ns/1 ns

module lpc_cpld_top
(
	 input               LPC_CLK_CPLD,       // 2 MHz in emulation. 33 MHz in post-silicon
 
 // LPC
	 inout [3:0] 			LPC_AD,
	 input               LPC_FRAME_N,
	 input 					LPC_RESET_N,
 
 //I2C
	 input 					SCL,
	 inout 					SDA,
	 input 					HEADER1, 
	 input 					HEADER2,
	 output 					SWITCH_OUT,
	 output 					PCIE_OUT1,
	 output 					PCIE_OUT2,
 
 // VFD / LCD
	 output              LCD_RS,
	 output              LCD_WR_N,
	 output              LCD_RD_N,
	 inout [7:0] 			LCD_DATA,
 	 input 					PORT_OPTION,
 
// 7-Segment
	 output [6:0] 			SEG_LOWER_DATA,
	 output 					DP_UPPER,
	 output 					DP_LOWER,
	 output [6:0] 			SEG_UPPER_DATA
);

    wire    [15:0] snoop_addr;
    wire    [7:0] snoop_data;
    wire    vfd_row_wr;
    wire    vfd_wr_req;
    wire    vfd_rd_req;
    wire    vfd_fmt_busy;

    // read from ports
    wire    [7:0] io_data_out;

    wire    vfd_phy_wr;

    wire    [7:0] vfd_data_in;
    wire    phy_rs;         // rs value for vfd writing
    wire    vfd_wr;         // wr trigger to vfd_phy_wr
    wire    phy_busy;       // vfd_phy_wr

    wire    vfd_data_out_en;    // control the tri-state buffer;
    wire    [7:0] vfd_data_out;


    // tri-state VFD_DATA when it is not writing. We only do writing now
    // but this will be needed when we will do reading from vfd later.
    assign LCD_DATA = (vfd_data_out_en) ? vfd_data_out : 8'hz;
    assign vfd_rd_req = 0;  // to be implemented

	assign DP_UPPER = 0;
	assign DP_LOWER = 0;
    
    
    // Instantiate the lpc_snooper
    lpc_snooper lpc_snooper_1(
        .lad (LPC_AD),
        .lframe_n (LPC_FRAME_N),
        .reset   (LPC_RESET_N),
        .lclk   (LPC_CLK_CPLD),
        .addr (snoop_addr),
        .data (snoop_data),
        .vfd_row (vfd_row_wr),
        .vfd_wr_req (vfd_wr_req),
        .downstream_busy(vfd_fmt_busy)
    );

	i2c_eeprom i2c1
	  (
		.CLK (LPC_CLK_CPLD),
		.RST_N (LPC_RESET_N),
		.SCL (SCL),
		.SDA (SDA),
		.HEADER1(HEADER1),
		.HEADER2(HEADER2),
		.SWITCH_OUT (SWITCH_OUT),
		.PCIE_OUT1(PCIE_OUT1),
		.PCIE_OUT2(PCIE_OUT2)
		);
	
    // Instantiate the vfd_fmt_wr
    lcd_fmt_wr lcd_fmt_wr_1 (
        .data_in (snoop_data),
        .row (vfd_row_wr),
        .wr (vfd_wr_req),
        .rd (vfd_rd_req),
        .clk (LPC_CLK_CPLD),
        .reset (LPC_RESET_N),
        .busy_in (phy_busy),
        .wr_out (vfd_phy_wr),
        .data_out (vfd_data_in),
        .rs_out (phy_rs),
        .busy_out (vfd_fmt_busy),        // to LPC snooper
        .rd_data_out (io_data_out)
    );

    // Instantiate the vfd_phy_wr
    lcd_phy_wr lcd_phy_wr_1(
        .data_in (vfd_data_in), 
        .rs_in (phy_rs),
        .wr (vfd_phy_wr), 
        .clk (LPC_CLK_CPLD),
        .reset (LPC_RESET_N),
        .busy (phy_busy),    
        .vfd_data_out_en (vfd_data_out_en), 
        .vfd_wr_n_out (LCD_WR_N),
	     .vfd_rd_n_out (LCD_RD_N),
        .vfd_data_out (vfd_data_out),
        .vfd_rs (LCD_RS)
    );

    //Lower nibble seven segment
    lcd_seven_segment seven_segment_low(
    	.data_in	(snoop_data [3:0]), 
    	.clk		(LPC_CLK_CPLD),
    	.reset		(LPC_RESET_N),
    	.port_option (PORT_OPTION),
	   .row_port_80	(vfd_row_wr),
		.seg_data_out	(SEG_LOWER_DATA)
    );

    //Higher nibble seven segment
    lcd_seven_segment seven_segment_high(
    	.data_in	(snoop_data [7:4]), 
    	.clk		(LPC_CLK_CPLD),
    	.reset		(LPC_RESET_N),
		.port_option (PORT_OPTION),
		.row_port_80	(vfd_row_wr),
	   .seg_data_out	(SEG_UPPER_DATA)
    );

endmodule
