 //*-- Intel Copyright Notice --
 //* 
 //* 
 //* Copyright (c) 2002-2010 Intel Corporation All Rights Reserved.
 //* 
 //*
 //* The source code contained or described herein and all documents
 //* related to the source code ("Material") are owned by Intel Corporation
 //* or its suppliers or licensors.  Title to the Material remains with
 //* Intel Corporation or its suppliers and licensors.
 //* 
 //*
 //* The Material is protected by worldwide copyright and trade secret laws
 //* and treaty provisions. No part of the Material may be used, copied,
 //* reproduced, modified, published, uploaded, posted, transmitted,
 //* distributed, or disclosed in any way except in accordance with the
 //* applicable license agreement .
 //* 
 //*
 //* No license under any patent, copyright, trade secret or other
 //* intellectual property right is granted to or conferred upon you by
 //* disclosure or delivery of the Materials, either expressly, by
 //* implication, inducement, estoppel, except in accordance with the
 //* applicable license agreement.
 //* 
 //*
 //* Unless otherwise agreed by Intel in writing, you may not remove or
 //* alter this notice or any other notice embedded in Materials by Intel
 //* or Intel's suppliers or licensors in any way.
 //* 
 //* 
 //* For further details, please see the file README.TXT distributed with
 //* this software.
 //* 
 //*
 //* -- End Intel Copyright Notice --/
 //


// File : lpc.v - A simple exercise to implement the lpc protocol

`define LPC_START_TARGET    4'b0000     // Start cycle for Target
`define LPC_START_MASTER_0  4'b0010     // Start cycle for Master 0
`define LPC_START_MASTER_1  4'b0011     // Start cycle for Master 1
`define LPC_CT_IOREAD       4'b0000     // Cycle types of IO read and write.
`define LPC_CT_IOWRITE      4'b0010     // Other cycle types are not processed
`timescale 1 ns/1 ns

module lpc_snooper (
    inout   [3:0] lad,
    input   lframe_n,
    input   reset,
    input   lclk,
    output reg [15:0] addr,
    output reg [7:0]  data,
    // ----

    output reg vfd_row,
    output reg vfd_wr_req,

    input  downstream_busy

);
	
    reg [3:0]  cur_state;
    reg [3:0] write_lpc_data;
    reg lad_enable;
    assign lad = (lad_enable) ? write_lpc_data : 4'hz;


   parameter STATE_LPC_IDLE = 0;
   parameter STATE_LPC_START = 1;
   parameter STATE_LPC_CTDIR = 2;
   parameter STATE_LPC_ADDR = 3;
   parameter STATE_LPC_DATA = 4;
   parameter STATE_LPC_TAR_1 = 5;
   parameter STATE_LPC_TAR_2 = 6;
   parameter STATE_LPC_SYNC_WAIT = 7;
   parameter STATE_LPC_TAR_SLAVE = 8;
   parameter STATE_LPC_TAR_4 = 9;

    reg [3:0] next_state;
    reg [3:0] lad_ff;
    // reg [3:0] lad_ff2;
    reg [3:0] cntr;
    reg start_cnt, stop_cnt;


   always @(*)
     begin
        lad_enable = 0;
        write_lpc_data = 4'h0;
        start_cnt = 0;
        stop_cnt = 0;
		  next_state = STATE_LPC_IDLE;
        case (cur_state)
			 STATE_LPC_IDLE: begin       
             if (!lframe_n) begin
					 next_state = STATE_LPC_START;
             end
          end
			 STATE_LPC_START: begin
             if (!lframe_n) 
					next_state = STATE_LPC_START; // still assert. stay here
             else 
					begin            
						if (lad_ff==`LPC_START_TARGET)
                    next_state = STATE_LPC_CTDIR; // de-asserted and start code is 4'b0000
						else
                    next_state = STATE_LPC_IDLE;
					end
			 end    
			 STATE_LPC_CTDIR: begin
            case (lad_ff)
                `LPC_CT_IOREAD: begin 
                    next_state = STATE_LPC_IDLE; // need to work on the read logic
                  end
                `LPC_CT_IOWRITE: begin 
                    start_cnt = 1;
                    next_state = STATE_LPC_ADDR; // address phase
                  end
                default: begin
                    // Only process IOREAD and IOWRITE cycles, anything other
                    // than these will be ignored.
                    next_state = STATE_LPC_IDLE;
                  end
            endcase
        end
        STATE_LPC_ADDR: begin
            if (cntr<4) begin
                start_cnt = 1;
                next_state = STATE_LPC_ADDR;
            end
            else begin
                stop_cnt = 0;
                start_cnt = 1;
                next_state = STATE_LPC_DATA;
            end
        end
        STATE_LPC_DATA: begin
            if (cntr<6) begin
                start_cnt = 1;
                next_state = STATE_LPC_DATA;
            end
            else begin
                stop_cnt = 1;
                next_state = STATE_LPC_TAR_1;
            end
        end
        STATE_LPC_TAR_1: begin
           next_state = STATE_LPC_TAR_2;
        end
        STATE_LPC_TAR_2: begin
          write_lpc_data = 4'b0000; // long wait 
          lad_enable = 1;
          next_state = STATE_LPC_SYNC_WAIT;
        end
        STATE_LPC_SYNC_WAIT: begin
          lad_enable = 1;
/*
          if (downstream_busy) begin
                write_lpc_data = 4'b0110; // long wait 
                next_state = STATE_LPC_SYNC_WAIT;
           end else 
*/
           begin
            write_lpc_data = 4'hf;
            lad_enable = 1;
            next_state = STATE_LPC_TAR_SLAVE;
          end
        end
        STATE_LPC_TAR_SLAVE: begin
          write_lpc_data = 4'hf;
          lad_enable = 0;
          next_state = STATE_LPC_IDLE;
        end
        /*
        STATE_LPC_TAR_4: begin
          write_lpc_data = 4'h0;
          lad_enable = 0;
          next_state = STATE_LPC_IDLE;
        end
        */
		default:  begin
		next_state = STATE_LPC_IDLE;
		end
      endcase
    end

    /*
    always @(posedge lclk) begin
      case (next_state)
        STATE_LPC_IDLE: begin 
          end
        default:;
      endcase

    end
    */

    // -----------------------
    // FMS state transition
    // -----------------------
    // Do not use that for CPLD
    //always @(posedge lclk or negedge lreset_n  or negedge reset) begin
    //
    always @(posedge lclk) begin
      if (!reset) begin
          lad_ff <= 0;
          addr <= 16'h0;
          data <= 8'h0;
          cur_state <= STATE_LPC_IDLE;
          cntr <= 0;
          vfd_wr_req <= 0;
      end else begin
          // always flop in the lframe_n
          // ff_lframe_n <= lframe_n;     
          lad_ff <= lad;
          // lad_ff2 <= lad_ff;

          case (next_state)
				STATE_LPC_IDLE:
				  begin
					  vfd_row <= 0;
					  vfd_wr_req <= 0;
					  addr <= 16'h0;
					  data <= 8'h0;
				  end
				
            STATE_LPC_ADDR: begin 
              case (cntr)
                // Address Nibbles comes in Big Endian order
                0: addr[15:12] <= lad;
                1: addr[11:8] <= lad;
                2: addr[7:4] <= lad;
                3: addr[3:0] <= lad;
                default: addr <= addr;
              endcase
              end
            STATE_LPC_DATA: begin 
              case (cntr)
                // 2 Data Nibbles comes in Little Endian order 
                4: data[3:0] <= lad;
                5: data[7:4] <= lad;
                default: data <= data;
              endcase
              end
            STATE_LPC_TAR_1: begin
                if (addr == 16'h80)
                    vfd_row <= 1;
					 else
                    vfd_row <= 0;
                if (addr == 16'h80) //((addr==16'h80)||(addr==16'h84))
                    vfd_wr_req <= 1;
					 else
						vfd_wr_req <= 0;
					
              end
            STATE_LPC_TAR_2: begin
                vfd_wr_req <= 0;
              end
            default:
				  begin
					  vfd_row <= 0;
					  vfd_wr_req <= 0;
				  end
			 endcase

          // state transition
          cur_state <= next_state;
          
          if(start_cnt)
          cntr <= cntr+1;
          else if(stop_cnt)
          cntr <= 0;
          else
          cntr <= cntr;

      end
    end

endmodule
