 //*-- Intel Copyright Notice --
 //* 
 //* 
 //* Copyright (c) 2002-2011 Intel Corporation All Rights Reserved.
 //* 
 //*
 //* The source code contained or described herein and all documents
 //* related to the source code ("Material") are owned by Intel Corporation
 //* or its suppliers or licensors.  Title to the Material remains with
 //* Intel Corporation or its suppliers and licensors.
 //* 
 //*
 //* The Material is protected by worldwide copyright and trade secret laws
 //* and treaty provisions. No part of the Material may be used, copied,
 //* reproduced, modified, published, uploaded, posted, transmitted,
 //* distributed, or disclosed in any way except in accordance with the
 //* applicable license agreement .
 //* 
 //*
 //* No license under any patent, copyright, trade secret or other
 //* intellectual property right is granted to or conferred upon you by
 //* disclosure or delivery of the Materials, either expressly, by
 //* implication, inducement, estoppel, except in accordance with the
 //* applicable license agreement.
 //* 
 //*
 //* Unless otherwise agreed by Intel in writing, you may not remove or
 //* alter this notice or any other notice embedded in Materials by Intel
 //* or Intel's suppliers or licensors in any way.
 //* 
 //* 
 //* For further details, please see the file README.TXT distributed with
 //* this software.
 //* 
 //*
 //* -- End Intel Copyright Notice --/
 //

 //                              -*- Mode: Verilog -*-
 // Filename        : cru.v
 // Description     : Clock unit
 // Version         : 0.4


module cru
  (
	output CLK,
	output SLOW_CLK
	);
	
	reg [13:0] slow_clk_cntr = 0;
	wire 		  clk_5_56m;
	assign 	  CLK = clk_5_56m;

	// Instantiate internal oscillator. 
	max_osc	max_osc_inst (
								  .oscena (1'b1 ),
								  .osc (clk_5_56m)  // 5.56MHz
								  );

	// 5.56mhz 179ns period
	// [0] = 358ns
	// [1] = 716ns
	// [2] = 1.432us
	// [3] = 2.864us
	// [4] = 5.728us
	// [5] = 11.45us
	// [6] = 22.91us
	// [7] = 45.82us
	// [8] = 91.65us
	//[9] = 183.3us
	//[10] = 366.6us
	//[11] = 733.2us
	//[12] = 1.466ms

	always @ (posedge clk_5_56m)
	  slow_clk_cntr[13:0] <= slow_clk_cntr[12:0] + 1'b1;
	
	// SLOW_CLK has a period of 1.466ms
	assign SLOW_CLK = slow_clk_cntr[12];
		
	
endmodule // cru
