//*-- Intel Copyright Notice --
 //* 
 //* 
 //* Copyright (c) 2002-2011 Intel Corporation All Rights Reserved.
 //* 
 //*
 //* The source code contained or described herein and all documents
 //* related to the source code ("Material") are owned by Intel Corporation
 //* or its suppliers or licensors.  Title to the Material remains with
 //* Intel Corporation or its suppliers and licensors.
 //* 
 //*
 //* The Material is protected by worldwide copyright and trade secret laws
 //* and treaty provisions. No part of the Material may be used, copied,
 //* reproduced, modified, published, uploaded, posted, transmitted,
 //* distributed, or disclosed in any way except in accordance with the
 //* applicable license agreement .
 //* 
 //*
 //* No license under any patent, copyright, trade secret or other
 //* intellectual property right is granted to or conferred upon you by
 //* disclosure or delivery of the Materials, either expressly, by
 //* implication, inducement, estoppel, except in accordance with the
 //* applicable license agreement.
 //* 
 //*
 //* Unless otherwise agreed by Intel in writing, you may not remove or
 //* alter this notice or any other notice embedded in Materials by Intel
 //* or Intel's suppliers or licensors in any way.
 //* 
 //* 
 //* For further details, please see the file README.TXT distributed with
 //* this software.
 //* 
 //*
 //* -- End Intel Copyright Notice --/
 //

//                              -*- Mode: Verilog -*-
// Filename        : debouncer.v
// Description     : Debouncer Circuit.
// Version         : 0.01
// Description     : Debouncer Circuit Module.
`timescale 1ns/100ps

/*	Button/Switch debouncer */

module debouncer (
	input		CLK,
	input		RESET,
	input		BUTTON_IN,
	output	reg	BUTTON_OUT
);

`ifdef sim
	parameter	debounce_delay	= 15'h2BF0;
`else
	parameter	debounce_delay	= 15'h2BF0;	//2ms when CLK = ~6mhz
`endif


reg	[14:0]	debounce_timer;

always @(posedge CLK, posedge RESET)
begin
	if (RESET) begin
		debounce_timer	<= 0;
	end else begin
		if (!BUTTON_IN && (debounce_timer < debounce_delay)) begin
			debounce_timer[14:0]	<= debounce_timer[13:0] + 1'b1;
		end
		if (BUTTON_IN) begin
			debounce_timer	<= 0;
		end
	end
end


always @(posedge CLK, posedge RESET)
begin
	if (RESET) begin
		BUTTON_OUT	<= 1'b1;
	end else begin
		if (debounce_timer	== debounce_delay) begin
			BUTTON_OUT	<= 1'b0;
		end else begin
			BUTTON_OUT	<= 1'b1;
		end
	end
end



endmodule
